/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.auth;

import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidInputException;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.server.auth.ESMethod;
import org.eclipse.emf.emfstore.server.model.ESSessionId;

public class ESMethodInvocation {
    private final ESMethod.MethodId methodId;
    private final Object[] allParameters;
    private final SessionId sessionId;
    private final String methodName;

    public ESMethodInvocation(String methodName, Object[] params) throws InvalidInputException {
        this.sessionId = (SessionId)params[0];
        if (this.sessionId == null) {
            throw new InvalidInputException("operations requires session id");
        }
        this.allParameters = params;
        this.methodId = ESMethod.MethodId.valueOf(methodName.toUpperCase());
        this.methodName = methodName;
    }

    public ESMethod.MethodId getType() {
        return this.methodId;
    }

    public Object[] getParameters() {
        if (this.allParameters.length > 1) {
            Object[] result = new Object[this.allParameters.length - 1];
            int i = 1;
            while (i < this.allParameters.length) {
                result[i - 1] = this.allParameters[i];
                ++i;
            }
            return result;
        }
        return new Object[0];
    }

    public Object[] getAllParameters() {
        return this.allParameters;
    }

    public ESSessionId getSessionId() {
        return (ESSessionId)this.sessionId.toAPI();
    }

    public String getMethodName() {
        return this.methodName;
    }
}

