/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.annotations;

import com.fasterxml.jackson.databind.DatabindContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.utils.ValueReader;
import org.eclipse.emfcloud.jackson.utils.ValueWriter;

public class EcoreTypeInfo {
    public static final String PROPERTY = "eClass";
    public static final ValueReader<String, EClass> DEFAULT_VALUE_READER = (value, context) -> EMFContext.findEClass((DatabindContext)context, value);
    public static final ValueWriter<EClass, String> DEFAULT_VALUE_WRITER = (value, context) -> EMFContext.getURI((DatabindContext)context, (EObject)value).toString();
    public static final ValueReader<String, EClass> READ_BY_NAME = (value, context) -> EMFContext.findEClassByName((DatabindContext)context, value);
    public static final ValueWriter<EClass, String> WRITE_BY_NAME = (value, context) -> value != null ? value.getName() : null;
    public static final ValueReader<String, EClass> READ_BY_CLASS = (value, context) -> EMFContext.findEClassByQualifiedName((DatabindContext)context, value);
    public static final ValueWriter<EClass, String> WRITE_BY_CLASS_NAME = (value, context) -> value != null ? value.getInstanceClassName() : null;
    private final String property;
    private final ValueReader<String, EClass> valueReader;
    private final ValueWriter<EClass, String> valueWriter;

    public EcoreTypeInfo() {
        this(null, null, null);
    }

    public EcoreTypeInfo(String property) {
        this(property, null, null);
    }

    public EcoreTypeInfo(String property, ValueReader<String, EClass> valueReader) {
        this(property, valueReader, null);
    }

    public EcoreTypeInfo(String property, ValueWriter<EClass, String> valueWriter) {
        this(property, null, valueWriter);
    }

    public EcoreTypeInfo(String property, ValueReader<String, EClass> valueReader, ValueWriter<EClass, String> valueWriter) {
        this.property = property == null ? PROPERTY : property;
        this.valueReader = valueReader == null ? DEFAULT_VALUE_READER : valueReader;
        this.valueWriter = valueWriter == null ? DEFAULT_VALUE_WRITER : valueWriter;
    }

    public String getProperty() {
        return this.property;
    }

    public ValueReader<String, EClass> getValueReader() {
        return this.valueReader;
    }

    public ValueWriter<EClass, String> getValueWriter() {
        return this.valueWriter;
    }

    public static EcoreTypeInfo create(String property, USE use) {
        switch (use) {
            case NAME: {
                return new EcoreTypeInfo(property, READ_BY_NAME, WRITE_BY_NAME);
            }
            case CLASS: {
                return new EcoreTypeInfo(property, READ_BY_CLASS, WRITE_BY_CLASS_NAME);
            }
        }
        return new EcoreTypeInfo(property, DEFAULT_VALUE_READER, DEFAULT_VALUE_WRITER);
    }

    public static enum USE {
        URI,
        NAME,
        CLASS;

    }
}

