/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.converter;

import org.eclipse.fx.ide.fxgraph.fXGraph.BindValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ConstValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ControllerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Element;
import org.eclipse.fx.ide.fxgraph.fXGraph.IncludeValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueElement;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.LocationValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Property;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ResourceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ScriptHandlerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ScriptValueExpression;
import org.eclipse.fx.ide.fxgraph.fXGraph.ScriptValueReference;
import org.eclipse.fx.ide.fxgraph.fXGraph.SimpleValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticCallValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticValueProperty;

public class ValuePropertyFormatter {
    private String formattedValue;

    public ValuePropertyFormatter(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (value instanceof Property) {
            Property p = (Property)value;
            StringBuffer sb = new StringBuffer();
            if ("Integer".equals(p.getName()) || "Double".equals(p.getName())) {
                sb.append(new ValuePropertyFormatter(p.getValue()).getFormattedValue().replaceAll("\"", ""));
            } else {
                if (p.getModifier() != null) {
                    sb.append(p.getModifier() + " ");
                }
                sb.append(p.getName() + " : ");
                sb.append(new ValuePropertyFormatter(p.getValue()).getFormattedValue());
            }
            this.formattedValue = sb.toString();
        } else if (value instanceof ResourceValueProperty) {
            ResourceValueProperty p = (ResourceValueProperty)value;
            this.formattedValue = "rstring \"" + p.getValue().getValue() + "\"";
        } else if (value instanceof LocationValueProperty) {
            LocationValueProperty p = (LocationValueProperty)value;
            this.formattedValue = "location \"" + p.getValue() + "\"";
        } else if (value instanceof BindValueProperty) {
            BindValueProperty p = (BindValueProperty)value;
            this.formattedValue = "bind " + p.getElementReference().getName() + "#" + p.getAttribute();
        } else if (value instanceof ControllerHandledValueProperty) {
            this.formattedValue = "controllermethod " + ((ControllerHandledValueProperty)value).getMethodname();
        } else if (value instanceof ScriptHandlerHandledValueProperty) {
            this.formattedValue = "scriptmethod " + ((ScriptHandlerHandledValueProperty)value).getFunctionname();
        } else if (value instanceof ScriptValueExpression) {
            this.formattedValue = "scriptexpression " + ((ScriptValueExpression)value).getSourcecode();
        } else if (value instanceof ScriptValueReference) {
            this.formattedValue = "scriptvalue " + ((ScriptValueReference)value).getReference();
        } else if (value instanceof StaticValueProperty) {
            StaticValueProperty p = (StaticValueProperty)value;
            StringBuffer sb = new StringBuffer();
            if (p.getModifier() != null) {
                sb.append(p.getModifier() + " ");
            }
            sb.append("static " + p.getName() + " : ");
            sb.append(new ValuePropertyFormatter(p.getValue()).getFormattedValue());
            this.formattedValue = sb.toString();
        } else if (value instanceof StaticCallValueProperty) {
            StaticCallValueProperty p = (StaticCallValueProperty)value;
            StringBuffer sb = new StringBuffer();
            if (p.getModifier() != null) {
                sb.append(p.getModifier() + " ");
            }
            sb.append("call " + p.getType().getSimpleName() + " # " + p.getName() + " : ");
            sb.append(new ValuePropertyFormatter(p.getValue()).getFormattedValue());
            this.formattedValue = sb.toString();
        } else if (value instanceof ConstValueProperty) {
            ConstValueProperty p = (ConstValueProperty)value;
            StringBuffer sb = new StringBuffer();
            sb.append("const " + p.getType().getSimpleName() + "#" + p.getField());
            this.formattedValue = sb.toString();
        } else if (value instanceof IncludeValueProperty) {
            IncludeValueProperty inc = (IncludeValueProperty)value;
            this.formattedValue = "include source=" + String.valueOf(inc.getSource()) + " name=" + inc.getName();
        } else if (value instanceof ReferenceValueProperty) {
            ReferenceValueProperty ref = (ReferenceValueProperty)value;
            StringBuffer sb = new StringBuffer();
            sb.append("idref ");
            if (ref.getReference() instanceof Element) {
                sb.append(((Element)ref.getReference()).getType().getSimpleName());
            }
            if (!ref.getStaticCallProperties().isEmpty() || !ref.getStaticProperties().isEmpty()) {
                sb.append("{");
                boolean comma = false;
                for (Object p : ref.getStaticCallProperties()) {
                    if (comma) {
                        sb.append(",");
                    }
                    sb.append(new ValuePropertyFormatter(p).getFormattedValue());
                    comma = true;
                }
                for (Object p : ref.getStaticProperties()) {
                    if (comma) {
                        sb.append(",");
                    }
                    sb.append(new ValuePropertyFormatter(p).getFormattedValue());
                    comma = true;
                }
                sb.append("}");
            }
            this.formattedValue = sb.toString();
        } else if (value instanceof SimpleValueProperty) {
            SimpleValueProperty v = (SimpleValueProperty)value;
            this.formattedValue = v.getBooleanValue() != null ? v.getBooleanValue() : (v.getStringValue() != null ? "\"" + v.getStringValue() + "\"" : (v.getNumber() != null ? v.getNumber() : v.getNumber()));
        } else if (value instanceof ListValueProperty) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < ((ListValueProperty)value).getValue().size()) {
                ListValueElement o = (ListValueElement)((ListValueProperty)value).getValue().get(i);
                if (o instanceof SimpleValueProperty) {
                    String val = ((SimpleValueProperty)o).getStringValue();
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(val);
                    if (i + 1 < ((ListValueProperty)value).getValue().size()) {
                        sb.append(",");
                    }
                }
                ++i;
            }
            if (sb.length() == 0) {
                sb.append("value : \"no value found\"");
            }
            this.formattedValue = sb.toString();
        } else {
            this.formattedValue = value.toString();
        }
    }

    public String getFormattedValue() {
        return this.formattedValue;
    }
}

