/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.ui.adapter;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CssExtension;
import org.eclipse.fx.ide.css.cssext.ui.adapter.ExtensionHolder;
import org.eclipse.fx.ide.css.cssext.ui.adapter.ExtensionRegistry;
import org.eclipse.fx.ide.css.cssext.ui.adapter.ICssResource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.linking.impl.XtextLinkingDiagnostic;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.util.CancelIndicator;

public abstract class ACssResource
implements ICssResource {
    private static final String PLUGIN_ID = "org.eclipse.fx.ide.css.cssext.ui";
    protected QualifiedName KEY_USE_CUSTOM = new QualifiedName("org.eclipse.fx.ide.css.cssext.ui", "useCustom");
    protected QualifiedName KEY_CUSTOM_EXTENSIONS = new QualifiedName("org.eclipse.fx.ide.css.cssext.ui", "customExtensions");
    protected QualifiedName KEY_DISABLED_EXTENSIONS = new QualifiedName("org.eclipse.fx.ide.css.cssext.ui", "disabledExtensions");
    private Logger logger;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ICssResource parent;
    private IResource adaptedObject;
    private boolean useCustom;
    private List<URI> disabledExtensions = new ArrayList<URI>();
    private List<URI> customExtensions = new ArrayList<URI>();
    private ResourceSet rs;
    private IResourceDescription.Manager manager;
    private IResourceDescriptions x;
    private ExtensionHolder cachedExtensionHolder;

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerCreator.createLogger(this.getClass());
        }
        return this.logger;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public ICssResource getParentResource() {
        if (this.parent == null) {
            this.parent = this.findParent();
        }
        return this.parent;
    }

    public ACssResource(IResource adaptedObject) {
        this.adaptedObject = adaptedObject;
        try {
            this.load();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void save() throws CoreException {
        this.adaptedObject.setPersistentProperty(this.KEY_USE_CUSTOM, Boolean.toString(this.useCustom));
        try {
            this.getLogger().debug("after save: " + String.valueOf(this.adaptedObject.getPersistentProperties()));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        String disabled = this.disabledExtensions.stream().map(uri -> uri.toString()).collect(Collectors.joining(","));
        this.adaptedObject.setPersistentProperty(this.KEY_DISABLED_EXTENSIONS, disabled);
        String custom = this.customExtensions.stream().map(uri -> uri.toString()).collect(Collectors.joining(","));
        this.adaptedObject.setPersistentProperty(this.KEY_CUSTOM_EXTENSIONS, custom);
    }

    private List<URI> parseURIs(String data) {
        this.getLogger().debug("parseURIs(" + data + ")");
        String[] disabledExtensionURIs = data.split(",");
        ArrayList<URI> uris = new ArrayList<URI>();
        String[] stringArray = disabledExtensionURIs;
        int n = disabledExtensionURIs.length;
        int n2 = 0;
        while (n2 < n) {
            String uriString = stringArray[n2];
            if (uriString != null && uriString.trim().length() > 0) {
                URI uri = URI.createURI((String)uriString);
                uris.add(uri);
            }
            ++n2;
        }
        this.getLogger().debug(" result = " + uris.size() + " / " + String.valueOf(uris));
        return uris;
    }

    @Override
    public void load() throws CoreException {
        this.setUseCustom(Boolean.parseBoolean(this.adaptedObject.getPersistentProperty(this.KEY_USE_CUSTOM)));
        String disabledExtensionsData = this.adaptedObject.getPersistentProperty(this.KEY_DISABLED_EXTENSIONS);
        if (disabledExtensionsData != null) {
            List<URI> uris = this.parseURIs(disabledExtensionsData);
            this.disabledExtensions = uris;
            this.propertyChangeSupport.firePropertyChange("disabledCssExtensions", this.disabledExtensions, this.disabledExtensions);
        } else {
            this.disabledExtensions = new ArrayList<URI>();
            this.propertyChangeSupport.firePropertyChange("disabledCssExtensions", this.disabledExtensions, this.disabledExtensions);
        }
        String customExtensionsData = this.adaptedObject.getPersistentProperty(this.KEY_CUSTOM_EXTENSIONS);
        if (customExtensionsData != null) {
            List<URI> uris = this.parseURIs(customExtensionsData);
            this.customExtensions = uris;
            this.propertyChangeSupport.firePropertyChange("customCssExtensions", this.customExtensions, this.customExtensions);
        } else {
            this.customExtensions = new ArrayList<URI>();
            this.propertyChangeSupport.firePropertyChange("customCssExtensions", this.customExtensions, this.customExtensions);
        }
        this.getLogger().debug("load done");
        this.getLogger().debug("disabled: " + String.valueOf(this.disabledExtensions));
        this.getLogger().debug("custom: " + String.valueOf(this.customExtensions));
    }

    protected IProject findProject() {
        IResource res = (IResource)Platform.getAdapterManager().getAdapter(this.getAdaptedObject(), IResource.class);
        IProject project = (IProject)Platform.getAdapterManager().getAdapter((Object)res, IProject.class);
        while (project == null && res.getParent() != null) {
            res = res.getParent();
            project = (IProject)Platform.getAdapterManager().getAdapter((Object)res, IProject.class);
        }
        return project;
    }

    private ICssResource findParent() {
        ICssResource parent = null;
        this.getLogger().debug(String.valueOf(this.adaptedObject) + " searching parent for " + String.valueOf(this.adaptedObject) + " " + this.adaptedObject.getClass().getName());
        IContainer container = this.adaptedObject.getParent();
        parent = (ICssResource)Platform.getAdapterManager().getAdapter((Object)container, ICssResource.class);
        this.getLogger().debug(String.valueOf(this.adaptedObject) + " => returning parent " + String.valueOf(parent));
        return parent;
    }

    protected Object getAdaptedObject() {
        return this.adaptedObject;
    }

    @Override
    public boolean isUseCustom() {
        return this.useCustom;
    }

    @Override
    public void setUseCustom(boolean useCustom) {
        this.useCustom = useCustom;
        this.propertyChangeSupport.firePropertyChange("useCustom", this.useCustom, this.useCustom);
    }

    @Override
    public CssExtension getExtension(URI uri) {
        try {
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource resource = rs.createResource(uri);
            resource.setURI(uri);
            resource.load(Collections.emptyMap());
            return (CssExtension)resource.getContents().get(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private CssExtension loadModel(URI uri) {
        try {
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource resource = rs.createResource(uri);
            resource.setURI(uri);
            resource.load(Collections.emptyMap());
            return (CssExtension)resource.getContents().get(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<URI> getAllEnabledExtensions() {
        this.getLogger().trace("getAllEnabledExtensions()");
        ArrayList<URI> allEnabled = new ArrayList<URI>();
        ICssResource parentResource = this.getParentResource();
        if (parentResource != null) {
            allEnabled.addAll(parentResource.getAllEnabledExtensions());
        }
        allEnabled.addAll(this.getClasspathExtensions());
        if (this.useCustom) {
            allEnabled.addAll(this.getCustomExtensions());
            allEnabled.removeAll(this.getDisabledExtensions());
        }
        return allEnabled;
    }

    private CssExtension load(URI uri, boolean linkAll) {
        Resource resource = this.rs.getResource(uri, true);
        if (linkAll) {
            for (Resource r : this.rs.getResources()) {
                EcoreUtil2.resolveLazyCrossReferences((Resource)r, (CancelIndicator)CancelIndicator.NullImpl);
                for (Resource.Diagnostic d : r.getErrors()) {
                    if (!(d instanceof XtextLinkingDiagnostic)) continue;
                    XtextLinkingDiagnostic xtextLinkingDiagnostic = (XtextLinkingDiagnostic)d;
                }
            }
        }
        IResourceDescription desc = this.manager.getResourceDescription(resource);
        return (CssExtension)resource.getContents().get(0);
    }

    @Override
    public Set<CssExtension> getEnabledCssExtensions(EObject context) {
        if (this.cachedExtensionHolder == null) {
            this.cachedExtensionHolder = new ExtensionHolder(this.findProject(), context, this);
        }
        return new HashSet<CssExtension>(this.cachedExtensionHolder.getModels());
    }

    public ExtensionRegistry getRegistry() {
        return ExtensionRegistry.REGISTRY;
    }

    @Override
    public List<URI> getClasspathExtensions() {
        return Collections.emptyList();
    }

    @Override
    public List<URI> getDisabledExtensions() {
        return Collections.unmodifiableList(this.disabledExtensions);
    }

    @Override
    public List<URI> getCustomExtensions() {
        return Collections.unmodifiableList(this.customExtensions);
    }

    @Override
    public List<URI> getInheritedClasspathExtensions() {
        ArrayList<URI> result = new ArrayList<URI>();
        ICssResource parentResource = this.getParentResource();
        if (parentResource != null) {
            result.addAll(parentResource.getClasspathExtensions());
            result.addAll(parentResource.getInheritedClasspathExtensions());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<URI> getInheritedCustomExtensions() {
        ArrayList<URI> result = new ArrayList<URI>();
        ICssResource parentResource = this.getParentResource();
        if (parentResource != null) {
            result.addAll(parentResource.getCustomExtensions());
            result.addAll(parentResource.getInheritedCustomExtensions());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<URI> getInheritedDisabledExtensions() {
        ArrayList<URI> result = new ArrayList<URI>();
        ICssResource parentResource = this.getParentResource();
        if (parentResource != null) {
            result.addAll(parentResource.getDisabledExtensions());
            result.addAll(parentResource.getInheritedDisabledExtensions());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void addDisabledExtension(URI uri) {
        this.disabledExtensions.add(uri);
    }

    @Override
    public void removeDisabledExtension(URI uri) {
        this.disabledExtensions.remove(uri);
    }

    @Override
    public void addCustomExtension(URI uri) {
        this.customExtensions.add(uri);
    }

    @Override
    public void removeCustomExtension(URI uri) {
        this.customExtensions.remove(uri);
    }

    @Override
    public void clearCustomExtensions() {
        this.customExtensions.clear();
    }

    @Override
    public void clearDisabledExtensions() {
        this.disabledExtensions.clear();
    }
}

