/*******************************************************************************
 * Copyright (c) 2016 BestSolution.at and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v.2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Christoph Caks<ccaks@bestsolution.at> - initial API and implementation
 *******************************************************************************/
package org.eclipse.fx.core.bindings.internal;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

import javafx.beans.Observable;
import javafx.beans.binding.ListBinding;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

@SuppressWarnings("javadoc")
public class FlatMapListBinding<A, B> extends ListBinding<B> {

	private Observable[] currentDependencies;

	private ObservableList<A> source;
	private Function<A, ObservableList<B>> map;

	public FlatMapListBinding(ObservableList<A> source, Function<A, ObservableList<B>> map) {
		this.source = source;
		this.map = map;
	}

	private Observable[] computeDependencies() {
		List<Observable> toWatch = this.source.stream().map(this.map).collect(Collectors.toList());
		toWatch.add(this.source);
		return toWatch.toArray(new Observable[0]);
	}

	private void updateDependencies() {
		if (this.currentDependencies != null) {
			unbind(this.currentDependencies);
		}
		this.currentDependencies = computeDependencies();
		bind(this.currentDependencies);
	}

	@Override
	protected ObservableList<B> computeValue() {
		this.updateDependencies();
		return FXCollections.observableList(this.source.stream().map(this.map).flatMap(o->o.stream()).collect(Collectors.toList()));
	}

	@Override
	public void dispose() {
		if (this.currentDependencies != null) {
			unbind(this.currentDependencies);
			this.currentDependencies = null;
		}
		super.dispose();
	}
}