/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.admin;

import jakarta.inject.Singleton;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class RestSessionManager {
    private final SecureRandom randomGenerator = new SecureRandom();
    private Map<String, SessionData> activeSessions = new ConcurrentHashMap<String, SessionData>();

    RestSessionManager() {
    }

    public String createSession(String remoteAddr, Subject subject, int sessionTimeoutInMins) {
        String sessionId;
        while (this.isSessionExist(sessionId = new BigInteger(130, this.randomGenerator).toString(16))) {
        }
        this.saveSession(sessionId, remoteAddr, subject, sessionTimeoutInMins);
        return sessionId;
    }

    public Subject authenticate(String sessionId, String remoteAddress) {
        SessionData sessionData;
        Subject result = null;
        boolean authenticated = false;
        this.purgeInactiveSessions();
        if (sessionId != null && (sessionData = this.activeSessions.get(sessionId)) != null) {
            authenticated = sessionData.authenticate(remoteAddress);
            if (authenticated) {
                sessionData.updateLastAccessTime();
                result = sessionData.subject();
            } else {
                this.activeSessions.remove(sessionId);
            }
        }
        return result;
    }

    public boolean deleteSession(String sessionId) {
        boolean sessionDeleted = false;
        if (sessionId != null) {
            SessionData removedSession = this.activeSessions.remove(sessionId);
            sessionDeleted = removedSession != null;
        }
        return sessionDeleted;
    }

    private void saveSession(String sessionId, String remoteAddr, Subject subject, int sessionTimeoutInMins) {
        this.purgeInactiveSessions();
        this.activeSessions.put(sessionId, new SessionData(sessionId, remoteAddr, subject, sessionTimeoutInMins));
    }

    private void purgeInactiveSessions() {
        Set<Map.Entry<String, SessionData>> activeSessionsSet = this.activeSessions.entrySet();
        for (Map.Entry<String, SessionData> entry : activeSessionsSet) {
            if (entry.getValue().isSessionActive()) continue;
            activeSessionsSet.remove(entry);
        }
    }

    private boolean isSessionExist(String sessionId) {
        return this.activeSessions.containsKey(sessionId);
    }

    private static class SessionData {
        private String clientAddress;
        private long lastAccessedTime = System.currentTimeMillis();
        private final long inactiveSessionLifeTime;
        private static final String DISABLE_REMOTE_ADDRESS_VALIDATION_PROPERTY_NAME = "org.glassfish.admin.rest.disable.remote.address.validation";
        private final boolean disableRemoteAddressValidation = Boolean.getBoolean("org.glassfish.admin.rest.disable.remote.address.validation");
        private final Subject subject;

        public SessionData(String sessionId, String remoteAddr, Subject subject, int sessionTimeoutInMins) {
            this.clientAddress = remoteAddr;
            this.subject = subject;
            this.inactiveSessionLifeTime = (long)sessionTimeoutInMins * 60000L;
        }

        public boolean isSessionActive() {
            return this.lastAccessedTime + this.inactiveSessionLifeTime > System.currentTimeMillis();
        }

        public void updateLastAccessTime() {
            this.lastAccessedTime = System.currentTimeMillis();
        }

        public boolean authenticate(String remoteAddress) {
            return this.isSessionActive() && (this.clientAddress.equals(remoteAddress) || this.disableRemoteAddressValidation);
        }

        public Subject subject() {
            return this.subject;
        }
    }
}

