/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.io;

import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.ObjectAnalyzer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;

public class ServerDirs {
    private final String serverName;
    private final File serverDir;
    private final File parentDir;
    private final File agentDir;
    private final File grandParentDir;
    private final File configDir;
    private final File domainXml;
    private final File pidFile;
    private final File lastPidFile;
    private final boolean valid;
    private final String localPassword;
    private final File localPasswordFile;
    private final File dasPropertiesFile;
    static final LocalStringsImpl strings = new LocalStringsImpl(ServerDirs.class);

    public ServerDirs() {
        this.serverName = null;
        this.serverDir = null;
        this.agentDir = null;
        this.parentDir = null;
        this.grandParentDir = null;
        this.configDir = null;
        this.domainXml = null;
        this.pidFile = null;
        this.lastPidFile = null;
        this.valid = false;
        this.localPassword = null;
        this.localPasswordFile = null;
        this.dasPropertiesFile = null;
    }

    public ServerDirs(File serverDir) throws IOException {
        if (serverDir == null) {
            throw new IllegalArgumentException(strings.get("ServerDirs.nullArg", new Object[]{"ServerDirs.ServerDirs()"}));
        }
        if (!serverDir.isDirectory()) {
            throw new IOException(strings.get("ServerDirs.badDir", new Object[]{serverDir}));
        }
        this.serverDir = SmartFile.sanitize(serverDir);
        this.serverName = serverDir.getName();
        this.parentDir = serverDir.getParentFile();
        if (this.parentDir == null || !this.parentDir.isDirectory()) {
            throw new IOException(strings.get("ServerDirs.badParentDir", new Object[]{serverDir}));
        }
        this.grandParentDir = this.parentDir.getParentFile();
        this.configDir = new File(serverDir, "config");
        this.domainXml = new File(this.configDir, "domain.xml");
        this.pidFile = new File(this.configDir, "pid");
        this.lastPidFile = new File(this.configDir, "pid.prev");
        this.localPasswordFile = new File(this.configDir, "local-password");
        if (this.localPasswordFile.exists()) {
            try (BufferedReader r = new BufferedReader(new FileReader(this.localPasswordFile, StandardCharsets.UTF_8));){
                this.localPassword = r.readLine();
            }
        } else {
            this.localPassword = null;
        }
        this.agentDir = new File(this.parentDir, "agent");
        this.dasPropertiesFile = new File(this.parentDir, "agent/config/das.properties");
        this.valid = true;
    }

    public final String getServerName() {
        return this.valid ? this.serverName : null;
    }

    public ServerDirs refresh() throws IOException {
        return new ServerDirs(this.serverDir);
    }

    public final File getServerDir() {
        return this.valid ? this.serverDir : null;
    }

    public final File getAgentDir() {
        return this.valid ? this.agentDir : null;
    }

    public final File getServerParentDir() {
        return this.valid ? this.parentDir : null;
    }

    public final File getServerGrandParentDir() {
        return this.valid ? this.grandParentDir : null;
    }

    public final File getDomainXml() {
        return this.valid ? this.domainXml : null;
    }

    public final File getConfigDir() {
        return this.valid ? this.configDir : null;
    }

    public final File getPidFile() {
        return this.valid ? this.pidFile : null;
    }

    public final File getLastPidFile() {
        return this.lastPidFile;
    }

    public final File getDasPropertiesFile() {
        return this.dasPropertiesFile;
    }

    public String getLocalPassword() {
        return this.localPassword;
    }

    public final File getLocalPasswordFile() {
        return this.valid ? this.localPasswordFile : null;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public File getRestartLogFile() {
        return this.getServerDir().toPath().resolve(Path.of("logs", "restart.log")).toFile();
    }

    public String toString() {
        return ObjectAnalyzer.toString(this);
    }
}

