/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.context.spi.AlterableContext;
import jakarta.enterprise.inject.build.compatible.spi.ClassConfig;
import jakarta.enterprise.inject.build.compatible.spi.MetaAnnotations;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.configurator.AnnotatedConstructorConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedFieldConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.weld.lite.extension.translator.ClassConfigImpl;

class MetaAnnotationsImpl
implements MetaAnnotations {
    private final BeforeBeanDiscovery bbd;
    private final BeanManager bm;
    private final List<StereotypeConfigurator<?>> stereotypes;
    private final List<ContextData> contexts;

    MetaAnnotationsImpl(BeforeBeanDiscovery bbd, List<StereotypeConfigurator<?>> stereotypes, List<ContextData> contexts, BeanManager bm) {
        this.bbd = bbd;
        this.stereotypes = stereotypes;
        this.contexts = contexts;
        this.bm = bm;
    }

    @Override
    public ClassConfig addQualifier(Class<? extends Annotation> annotation) {
        AnnotatedTypeConfigurator<? extends Annotation> cfg = this.bbd.configureQualifier(annotation);
        return new ClassConfigImpl(cfg, this.bm);
    }

    @Override
    public ClassConfig addInterceptorBinding(Class<? extends Annotation> annotation) {
        AnnotatedTypeConfigurator<? extends Annotation> cfg = this.bbd.configureInterceptorBinding(annotation);
        return new ClassConfigImpl(cfg, this.bm);
    }

    @Override
    public ClassConfig addStereotype(Class<? extends Annotation> annotation) {
        StereotypeConfigurator<? extends Annotation> cfg = new StereotypeConfigurator<Annotation>(annotation, this.bm);
        this.stereotypes.add(cfg);
        return new ClassConfigImpl(cfg, this.bm);
    }

    @Override
    public void addContext(Class<? extends Annotation> scopeAnnotation, Class<? extends AlterableContext> contextClass) {
        this.contexts.add(new ContextData(scopeAnnotation, null, contextClass));
    }

    @Override
    public void addContext(Class<? extends Annotation> scopeAnnotation, boolean isNormal, Class<? extends AlterableContext> contextClass) {
        this.contexts.add(new ContextData(scopeAnnotation, isNormal, contextClass));
    }

    static final class StereotypeConfigurator<T extends Annotation>
    implements AnnotatedTypeConfigurator<T> {
        final Class<T> annotation;
        final Set<Annotation> annotations = new HashSet<Annotation>();
        final BeanManager bm;

        StereotypeConfigurator(Class<T> annotation, BeanManager bm) {
            this.annotation = annotation;
            this.bm = bm;
        }

        @Override
        public AnnotatedType<T> getAnnotated() {
            return this.bm.createAnnotatedType(this.annotation);
        }

        @Override
        public AnnotatedTypeConfigurator<T> add(Annotation annotation) {
            this.annotations.add(annotation);
            return this;
        }

        @Override
        public AnnotatedTypeConfigurator<T> remove(Predicate<Annotation> predicate) {
            this.annotations.removeIf(predicate);
            return this;
        }

        @Override
        public Set<AnnotatedMethodConfigurator<? super T>> methods() {
            return Collections.emptySet();
        }

        @Override
        public Set<AnnotatedFieldConfigurator<? super T>> fields() {
            return Collections.emptySet();
        }

        @Override
        public Set<AnnotatedConstructorConfigurator<T>> constructors() {
            return Collections.emptySet();
        }
    }

    static final class ContextData {
        final Class<? extends Annotation> scopeAnnotation;
        final Boolean isNormal;
        final Class<? extends AlterableContext> contextClass;

        ContextData(Class<? extends Annotation> scopeAnnotation, Boolean isNormal, Class<? extends AlterableContext> contextClass) {
            this.scopeAnnotation = scopeAnnotation;
            this.isNormal = isNormal;
            this.contextClass = contextClass;
        }
    }
}

