/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Application;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.config.ApplicationName;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;

@Configured
public interface Applications
extends ConfigBeanProxy {
    @Element(value="*")
    @RestRedirect(opType=RestRedirect.OpType.PUT, commandName="deploy")
    public List<ApplicationName> getModules();

    default public <T> List<T> getModules(Class<T> type) {
        ArrayList<T> modules = new ArrayList<T>();
        for (ApplicationName module : this.getModules()) {
            if (!type.isInstance(module)) continue;
            modules.add(type.cast(module));
        }
        return Collections.unmodifiableList(modules);
    }

    default public <T> T getModule(Class<T> type, String moduleID) {
        if (moduleID == null) {
            return null;
        }
        for (ApplicationName module : this.getModules()) {
            if (!type.isInstance(module) || !module.getName().equals(moduleID)) continue;
            return type.cast(module);
        }
        return null;
    }

    default public List<Application> getApplications() {
        return this.getModules(Application.class);
    }

    default public Application getApplication(String moduleID) {
        if (moduleID == null) {
            return null;
        }
        for (ApplicationName module : this.getModules()) {
            if (!(module instanceof Application) || !module.getName().equals(moduleID)) continue;
            return (Application)module;
        }
        return null;
    }

    default public List<Application> getApplicationsWithSnifferType(String snifferType) {
        return this.getApplicationsWithSnifferType(snifferType, false);
    }

    default public List<Application> getApplicationsWithSnifferType(String snifferType, boolean onlyStandaloneModules) {
        ArrayList<Application> applications = new ArrayList<Application>();
        for (Application app : this.getModules(Application.class)) {
            if (!app.containsSnifferType(snifferType)) continue;
            if (onlyStandaloneModules) {
                if (!app.isStandaloneModule()) continue;
                applications.add(app);
                continue;
            }
            applications.add(app);
        }
        return Collections.unmodifiableList(applications);
    }
}

