/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.admin.handlers;

import com.sun.messaging.bridge.admin.BridgeServiceManagerImpl;
import com.sun.messaging.bridge.admin.handlers.AdminCmdHandler;
import com.sun.messaging.bridge.admin.handlers.DebugHandler;
import com.sun.messaging.bridge.admin.handlers.HelloHandler;
import com.sun.messaging.bridge.admin.handlers.ListHandler;
import com.sun.messaging.bridge.admin.handlers.PauseHandler;
import com.sun.messaging.bridge.admin.handlers.ResumeHandler;
import com.sun.messaging.bridge.admin.handlers.StartHandler;
import com.sun.messaging.bridge.admin.handlers.StopHandler;
import com.sun.messaging.bridge.admin.resources.BridgeManagerResources;
import com.sun.messaging.bridge.admin.util.AdminMessageType;
import com.sun.messaging.bridge.api.BridgeBaseContext;
import com.sun.messaging.bridge.api.BridgeException;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.Locale;

public class AdminMessageHandler {
    private static boolean DEBUG = false;
    private BridgeManagerResources _br = null;
    private BridgeBaseContext _bc = null;
    private BridgeServiceManagerImpl _bsm = null;
    private AdminCmdHandler[] _handlers = null;

    public AdminMessageHandler(BridgeServiceManagerImpl bsm) {
        DEBUG = bsm.getDEBUG();
        this._bc = bsm.getBridgeBaseContext();
        this._br = bsm.getBridgeManagerResources();
        this._bsm = bsm;
        this.initHandlers();
    }

    protected boolean getDEBUG() {
        return DEBUG;
    }

    public void handle(Session session, ObjectMessage msg) {
        block16: {
            BridgeManagerResources bmr = this._br;
            ObjectMessage reply = null;
            int msgType = 30;
            try {
                Object emsg;
                reply = session.createObjectMessage();
                if (DEBUG) {
                    this._bc.logInfo("BridgeAdminMessageHandler.handle:\n<<<<****" + String.valueOf(msg), null);
                }
                try {
                    String lang = msg.getStringProperty("JMQLocaleLanguage");
                    String country = msg.getStringProperty("JMQLocaleCountry");
                    String variant = msg.getStringProperty("JMQLocaleVariant");
                    Locale locale = new Locale(lang, country, variant);
                    bmr = BridgeServiceManagerImpl.getBridgeManagerResources(locale);
                }
                catch (Exception e) {
                    bmr = this._br;
                    String emsg2 = this._br.getKString("BB3006", e.toString(), msg.toString());
                    this._bc.logWarn(emsg2, null);
                }
                Destination dest = msg.getJMSDestination();
                if (!(dest instanceof Queue)) {
                    throw new BridgeException(this._br.getKString("BB4010", dest));
                }
                if (!((Queue)dest).getQueueName().equals(this._bsm.getAdminDestinationName())) {
                    throw new BridgeException(this._br.getKString("BB4011", dest));
                }
                try {
                    msgType = msg.getIntProperty("JMQMessageType");
                }
                catch (Exception e) {
                    msgType = 30;
                    emsg = this._br.getKString("BB4012", msg.toString());
                    this._bc.logError((String)emsg, e);
                    throw new BridgeException((String)emsg, e);
                }
                AdminCmdHandler ach = null;
                try {
                    ach = this._handlers[msgType];
                }
                catch (IndexOutOfBoundsException e) {
                    String emsg3 = this._br.getKString("BB4013", AdminMessageType.getString(msgType));
                    throw new BridgeException(emsg3);
                }
                if (ach == null) {
                    emsg = "No bridge admin handler for message type " + AdminMessageType.getString(msgType);
                    throw new BridgeException((String)emsg);
                }
                reply.setIntProperty("JMQMessageType", ++msgType);
                ach.handle(session, msg, reply, bmr);
            }
            catch (Throwable t) {
                int status = 500;
                if (t instanceof BridgeException) {
                    BridgeException be = (BridgeException)t;
                    status = be.getStatus();
                    if (be.getCause() == null) {
                        this._bc.logError(t.getMessage(), null);
                    }
                } else {
                    this._bc.logError(t.getMessage(), t);
                }
                if (DEBUG) {
                    this._bc.logInfo("BridgeAdminMessageHandler exception: " + t.getMessage() + (reply == null ? "no reply created" : "sending error reply"), t);
                }
                if (reply == null) break block16;
                this.sendReply(session, (Message)msg, reply, status, AdminCmdHandler.getMessageFromThrowable(t), bmr);
            }
        }
    }

    private void initHandlers() {
        this._handlers = new AdminCmdHandler[30];
        this._handlers[18] = new ListHandler(this, this._bsm);
        this._handlers[20] = new PauseHandler(this, this._bsm);
        this._handlers[22] = new ResumeHandler(this, this._bsm);
        this._handlers[24] = new StartHandler(this, this._bsm);
        this._handlers[26] = new StopHandler(this, this._bsm);
        this._handlers[28] = new HelloHandler(this, this._bsm);
        this._handlers[16] = new DebugHandler(this, this._bsm);
    }

    public void sendReply(Session session, Message msg, ObjectMessage replyMsg, int status, String emsg, BridgeManagerResources bmr) {
        ObjectMessage reply = replyMsg;
        try {
            Destination replyTo = msg.getJMSReplyTo();
            if (replyTo == null) {
                this._bc.logError("Bridge admin message has no JMSReplyTo destination. Not replying.", null);
                return;
            }
            if (reply == null) {
                reply = session.createObjectMessage();
            }
            reply.setIntProperty("JMQStatus", status);
            if (emsg != null) {
                reply.setStringProperty("JMQErrorString", emsg);
            }
            try (MessageProducer sender = session.createProducer(replyTo);){
                sender.send((Message)reply, 1, 4, 0L);
                if (DEBUG) {
                    try {
                        this._bc.logInfo("BridgeAdminMessageHandler: sent REPLY\n>>>>****" + String.valueOf(reply) + "Body:" + String.valueOf(reply.getObject()), null);
                    }
                    catch (Throwable t) {
                        this._bc.logWarn("Unexpected exception : " + t.getMessage(), t);
                    }
                }
            }
        }
        catch (Throwable t) {
            this._bc.logError(this._br.getKString("BB3007", String.valueOf(reply), msg.toString()), t);
        }
    }
}

