/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jms.admin.cli.JMSDestination;
import org.glassfish.jms.admin.cli.MQJMXConnectorInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="__get-jmsdest")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.GET, path="__get-jmsdest", description="Get JMS Destinations", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.GET, path="__get-jmsdest", description="Get JMS Destinations", params={@RestParam(name="target", value="$parent")})})
public class GetJmsPhysicalDestinationCommand
extends JMSDestination
implements AdminCommand {
    @Param(name="desttype", shortName="t", optional=false)
    String destType;
    @Param(name="dest_name", primary=true)
    String destName;
    @Param(optional=true)
    String target = "server";
    @Inject
    ConnectorRuntime connectorRuntime;
    @Inject
    Domain domain;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServerContext serverContext;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        logger.entering(this.getClass().getName(), "__getJmsPhysicalDestination", new Object[]{this.destName, this.destType});
        try {
            this.validateJMSDestName(this.destName);
            this.validateJMSDestType(this.destType);
            Map<String, Object> entity = this.getJMSDestination();
            Properties ep = new Properties();
            ep.put("entity", entity);
            report.setExtraProperties(ep);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    protected Map<String, Object> getJMSDestination() throws Exception {
        HashMap<String, Object> hashMap;
        block12: {
            logger.log(Level.FINE, "getJMSDestination ...");
            MQJMXConnectorInfo mqInfo = this.createMQJMXConnectorInfo(this.target, this.config, this.serverContext, this.domain, this.connectorRuntime);
            try {
                MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
                if (this.destType.equalsIgnoreCase("topic")) {
                    this.destType = "t";
                } else if (this.destType.equalsIgnoreCase("queue")) {
                    this.destType = "q";
                }
                ObjectName on = new ObjectName("com.sun.messaging.jms.server:type=Destination,subtype=Config,desttype=" + this.destType + ",name=\"" + this.destName + "\"");
                MBeanAttributeInfo[] attribs = mbsc.getMBeanInfo(on).getAttributes();
                HashMap<String, Object> destAttrs = new HashMap<String, Object>();
                for (MBeanAttributeInfo attrib : attribs) {
                    destAttrs.put(attrib.getName(), mbsc.getAttribute(on, attrib.getName()));
                }
                hashMap = destAttrs;
                if (mqInfo == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (mqInfo != null) {
                        try {
                            mqInfo.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.logAndHandleException(e, "admin.mbeans.rmb.error_getting_jms_dest");
                }
            }
            mqInfo.close();
        }
        return hashMap;
    }
}

