/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.web.validation;

import ee.jakarta.tck.data.framework.junit.anno.AnyEntity;
import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import ee.jakarta.tck.data.framework.junit.anno.Web;
import ee.jakarta.tck.data.framework.utilities.TestPropertyUtility;
import ee.jakarta.tck.data.web.validation.Rectangle;
import ee.jakarta.tck.data.web.validation.Rectangles;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.function.Executable;

@Web
@AnyEntity
public class ValidationTests {
    @Inject
    private Rectangles rectangles;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{Rectangle.class, Rectangles.class});
    }

    @BeforeEach
    public void cleanup() {
        this.rectangles.deleteEverything();
        TestPropertyUtility.waitForEventualConsistency();
    }

    @Assertion(id="133", strategy="Ensure that entities that do not violate the constraints can be successfully inserted into the database")
    public void testSaveWithValidConstraints() {
        Rectangle validRect = new Rectangle("RECT-000", 5L, 5L, 5, 5);
        validRect = this.rectangles.save(validRect);
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)1L, (long)this.rectangles.countAll());
        this.assertRectangleFields(validRect, this.getResults().get(0), new String[0]);
        List<Rectangle> validRects = List.of(validRect, new Rectangle("RECT-001", 0L, 0L, 1, 1), new Rectangle("RECT-002", 1800L, 1000L, 120, 80), new Rectangle("RECT-003", 1L, 1L, 1, 1));
        validRects = this.immutableListOf(this.rectangles.saveAll(validRects));
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)4L, (long)this.rectangles.countAll(), (String)"Number of results was incorrect");
        List<Rectangle> resultRects = this.getResults();
        for (int i = 0; i < resultRects.size(); ++i) {
            this.assertRectangleFields(validRects.get(i), resultRects.get(i), new String[0]);
        }
    }

    @Assertion(id="133", strategy="Ensure that entities that violate the constraints cannot be inserted into the database")
    public void testSaveWithInvalidConstraints() {
        Rectangle invalidRect = new Rectangle("RECT-010", -1L, -1L, -1, 0);
        ConstraintViolationException resultingException = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> this.rectangles.save(invalidRect));
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)0L, (long)this.rectangles.countAll(), (String)"No rectangles should have presisted to database while violating constraints.");
        Assertions.assertEquals((int)4, (int)resultingException.getConstraintViolations().size(), (String)"Incorrect number of constraint violations.");
        List<Rectangle> invalidRects = List.of(new Rectangle("", 5L, 5L, 5, 5), new Rectangle("RECT-012", 1801L, 5L, 5, 5), new Rectangle("RECT-013", 5L, 1001L, 5, 5), new Rectangle("RECT-014", 5L, 5L, 121, 5), new Rectangle("RECT-014", 5L, 5L, 5, 81));
        resultingException = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> this.rectangles.saveAll(invalidRects));
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)0L, (long)this.rectangles.countAll(), (String)"No rectangles should have presisted to database while violating constraints.");
        Assertions.assertEquals((int)5, (int)resultingException.getConstraintViolations().size(), (String)"Incorrect number of constraint violations.");
    }

    @Assertion(id="133", strategy="Ensure that entities that do not violate the constraints can be successfully updated in the database")
    public void testUpdateWithValidConstraints() {
        Rectangle validRect = new Rectangle("RECT-020", 5L, 5L, 5, 5);
        validRect = this.rectangles.save(validRect);
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)1L, (long)this.rectangles.countAll(), (String)"Number of results was incorrect");
        this.assertRectangleFields(validRect, this.getResults().get(0), new String[0]);
        Rectangle updatedRect = new Rectangle("RECT-020", 10L, 10L, 10, 10);
        updatedRect = this.rectangles.save(updatedRect);
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)1L, (long)this.rectangles.countAll(), (String)"Number of results was incorrect");
        this.assertRectangleFields(updatedRect, this.getResults().get(0), new String[0]);
    }

    @Assertion(id="133", strategy="Ensure that entities that do not violate the constraints can be successfully updated in the database")
    public void testUpdateAllWithValidConstraints() {
        List<Rectangle> validRects = List.of(new Rectangle("RECT-030", 5L, 5L, 5, 5), new Rectangle("RECT-031", 0L, 0L, 1, 1), new Rectangle("RECT-032", 1800L, 1000L, 120, 80), new Rectangle("RECT-033", 1L, 1L, 1, 1));
        this.rectangles.saveAll(validRects);
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)4L, (long)this.rectangles.countAll(), (String)"Number of results was incorrect");
        List<Rectangle> updatedRects = List.of(new Rectangle("RECT-030", 6L, 5L, 5, 5), new Rectangle("RECT-031", 0L, 1L, 1, 1), new Rectangle("RECT-032", 1800L, 999L, 120, 80), new Rectangle("RECT-033", 1L, 1L, 1, 2));
        updatedRects = this.immutableListOf(this.rectangles.saveAll(updatedRects));
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)4L, (long)this.rectangles.countAll(), (String)"Number of results was incorrect");
        List<Rectangle> resultRects = this.getResults();
        for (int i = 0; i < resultRects.size(); ++i) {
            this.assertRectangleFields(updatedRects.get(i), resultRects.get(i), new String[0]);
        }
    }

    @Assertion(id="133", strategy="Ensure that entities that violate the constraints cannot be updated in the database")
    public void testUpdateWithInvalidConstraints() {
        Rectangle validRect = new Rectangle("RECT-040", 5L, 5L, 5, 5);
        validRect = this.rectangles.save(validRect);
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)1L, (long)this.rectangles.countAll(), (String)"Number of results was incorrect");
        Rectangle updatedInvalidRect = new Rectangle("RECT-040", -5L, -5L, -5, -5);
        ConstraintViolationException resultingException = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> this.rectangles.save(updatedInvalidRect));
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)1L, (long)this.rectangles.countAll(), (String)"Number of results was incorrect");
        Assertions.assertEquals((int)4, (int)resultingException.getConstraintViolations().size());
        Rectangle resultRect = this.getResults().get(0);
        this.assertRectangleFields(validRect, resultRect, new String[0]);
    }

    @Assertion(id="133", strategy="Ensure that entities that violate the constraints cannot be updated in the database")
    public void testUpdateAllWithInvalidConstraints() {
        List<Rectangle> validRects = List.of(new Rectangle("RECT-050", 5L, 5L, 5, 5), new Rectangle("RECT-051", 5L, 5L, 5, 5), new Rectangle("RECT-052", 5L, 5L, 5, 5), new Rectangle("RECT-053", 5L, 5L, 5, 5));
        validRects = this.immutableListOf(this.rectangles.saveAll(validRects));
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)4L, (long)this.rectangles.countAll(), (String)"Number of results was incorrect");
        List<Rectangle> invalidRects = List.of(new Rectangle("RECT-050", 1801L, 5L, 5, 5), new Rectangle("RECT-051", 5L, 1001L, 5, 5), new Rectangle("RECT-052", 5L, 5L, 121, 5), new Rectangle("RECT-053", 5L, 5L, 5, 81));
        ConstraintViolationException resultingException = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> this.rectangles.saveAll(invalidRects));
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)4L, (long)this.rectangles.countAll(), (String)"Number of results was incorrect");
        Assertions.assertEquals((int)4, (int)resultingException.getConstraintViolations().size());
        List<Rectangle> resultRects = this.getResults();
        for (int i = 0; i < resultRects.size(); ++i) {
            this.assertRectangleFields(validRects.get(i), resultRects.get(i), new String[0]);
        }
    }

    @Assertion(id="133", strategy="Ensure that entities that do not violate the constraints on a method return data from the database")
    public void testValidResultsFromMethod() {
        List<Rectangle> validRects = List.of(new Rectangle("RECT-060", 5L, 5L, 5, 5), new Rectangle("RECT-061", 0L, 0L, 1, 1), new Rectangle("RECT-062", 1800L, 1000L, 120, 80));
        validRects = this.immutableListOf(this.rectangles.saveAll(validRects));
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)3L, (long)this.rectangles.countAll(), (String)"Number of results was incorrect");
        List<Rectangle> resultRects = this.rectangles.findEverythingIdSorted();
        for (int i = 0; i < resultRects.size(); ++i) {
            this.assertRectangleFields(validRects.get(i), resultRects.get(i), new String[0]);
        }
    }

    @Assertion(id="133", strategy="Ensure that entities that violate the constraints on a method do not return data from the database")
    public void testInvalidResultsFromMethod() {
        List<Rectangle> invalidRects = List.of(new Rectangle("RECT-070", 5L, 5L, 5, 5), new Rectangle("RECT-071", 0L, 0L, 1, 1), new Rectangle("RECT-072", 1800L, 1000L, 120, 80), new Rectangle("RECT-073", 1L, 1L, 1, 1));
        invalidRects = this.immutableListOf(this.rectangles.saveAll(invalidRects));
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)4L, (long)this.rectangles.countAll(), (String)"Number of results was incorrect");
        ConstraintViolationException resultingException = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> this.rectangles.findEverythingIdSorted());
        Assertions.assertEquals((int)1, (int)resultingException.getConstraintViolations().size());
    }

    private <T> List<T> immutableListOf(Iterable<T> objects) {
        return StreamSupport.stream(objects.spliterator(), false).collect(Collectors.toList());
    }

    private List<Rectangle> getResults() {
        return this.rectangles.findAll().sorted((o1, o2) -> o1.getId().compareTo(o2.getId())).toList();
    }

    private void assertRectangleFields(Rectangle expected, Rectangle actual, String ... additionalMessages) {
        Assertions.assertAll((String)("Asserting rectangle fields are equal." + Stream.of(additionalMessages).collect(Collectors.joining(" "))), (Executable[])new Executable[]{() -> Assertions.assertEquals((Object)expected.getId(), (Object)actual.getId(), (String)"Incorrect ID"), () -> Assertions.assertEquals((long)expected.getX(), (long)actual.getX(), (String)"Incorrect X value"), () -> Assertions.assertEquals((Long)expected.getY(), (Long)actual.getY(), (String)"Incorrect Y value"), () -> Assertions.assertEquals((int)expected.getWidth(), (int)actual.getWidth(), (String)"Incorrect width value"), () -> Assertions.assertEquals((Integer)expected.getHeight(), (Integer)actual.getHeight(), (String)"Incorrect height value")});
    }
}

