/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.core.rap;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecp.core.rap.SessionProvider;
import org.eclipse.emf.ecp.core.util.observer.ECPObserverBus;
import org.eclipse.emf.ecp.internal.core.util.observer.ECPObserverBusImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ECPObserverBusFactory
implements ServiceFactory<ECPObserverBus> {
    private SessionProvider sessionProvider;
    private final Map<String, ECPObserverBus> sessionRegistry = new HashMap<String, ECPObserverBus>();

    public ECPObserverBusFactory() {
        this.init();
    }

    public final void init() {
        this.getSessionProvider();
    }

    private SessionProvider getSessionProvider() {
        if (this.sessionProvider == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(SessionProvider.class);
            this.sessionProvider = (SessionProvider)bundleContext.getService(serviceReference);
        }
        return this.sessionProvider;
    }

    public final ECPObserverBus getService(Bundle bundle, ServiceRegistration<ECPObserverBus> registration) {
        ECPObserverBusImpl ecpObserverBus;
        String sessionId = this.getSessionProvider().getSessionId();
        if (this.sessionRegistry.containsKey(sessionId)) {
            ecpObserverBus = this.sessionRegistry.get(sessionId);
        } else {
            ecpObserverBus = new ECPObserverBusImpl();
            this.sessionRegistry.put(sessionId, (ECPObserverBus)ecpObserverBus);
        }
        return ecpObserverBus;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<ECPObserverBus> registration, ECPObserverBus service) {
    }
}

