/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.ide.internal.builder;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emfforms.ide.internal.builder.Activator;
import org.eclipse.emfforms.ide.internal.builder.ProjectNature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddRemoveProjectNatureHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        String natureID = event.getParameter("natureID");
        if (natureID == null) {
            natureID = "org.eclipse.emfforms.ide.builder.viewModelNature";
        }
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                try {
                    ProjectNature.toggleNature(project, natureID);
                }
                catch (CoreException e) {
                    Activator.log("Failed to toggle nature", e);
                    throw new ExecutionException("Failed to toggle nature", (Throwable)e);
                }
            }
        }
        return null;
    }
}

