/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dirigible.runtime.chrome.debugger.models.Location;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.ScriptRepository;

public class ScriptUtils {
    private static final String FUNCTION_PREFIX = "function";

    public static String getEnclosingFunctionName(String scriptId, Integer breakpointLine) {
        Location startLocation = ScriptUtils.getStartLocation(scriptId, breakpointLine);
        int lineWithFunction = startLocation.getLineNumber().intValue();
        String source = ScriptRepository.getInstance().getSourceFor(scriptId);
        String line = ScriptUtils.getLine(source, lineWithFunction);
        Integer indexOfFunc = line.indexOf(FUNCTION_PREFIX) + FUNCTION_PREFIX.length();
        Integer indexOfBracket = line.indexOf("(");
        return line.substring(indexOfFunc, indexOfBracket).trim();
    }

    public static Location getStartLocation(String scriptId, Integer breakpointLine) {
        String source = ScriptRepository.getInstance().getSourceFor(scriptId);
        Map<Integer, List<Integer>> lineScopes = ScriptUtils.getLineScopes(source);
        Integer startLine = ScriptUtils.getStartLine(lineScopes, breakpointLine);
        Integer startColumn = ScriptUtils.getStartColumn(source, startLine);
        Location location = new Location();
        location.setColumnNumber((double)startColumn.intValue() * 1.0);
        location.setLineNumber((double)startLine.intValue() * 1.0);
        location.setScriptId(scriptId);
        return location;
    }

    public static Location getEndLocation(String scriptId, Integer breakpointLine) {
        String source = ScriptRepository.getInstance().getSourceFor(scriptId);
        Map<Integer, List<Integer>> lineScopes = ScriptUtils.getLineScopes(source);
        Integer endLine = ScriptUtils.getEndLine(lineScopes, breakpointLine);
        Integer startColumn = ScriptUtils.getStartColumn(source, breakpointLine);
        Integer startLine = ScriptUtils.getStartLine(lineScopes, breakpointLine);
        Integer endColumn = ScriptUtils.getEndColumn(source, startLine, startColumn);
        Location location = new Location();
        location.setColumnNumber((double)endColumn.intValue() * 1.0);
        location.setLineNumber((double)endLine.intValue() * 1.0);
        location.setScriptId(scriptId);
        return location;
    }

    private static Map<Integer, List<Integer>> getLineScopes(String source) {
        HashMap<Integer, List<Integer>> lineScopes = new HashMap<Integer, List<Integer>>();
        Map<Integer, Integer> functionScopes = ScriptUtils.getFunctionScopes(source);
        for (Map.Entry<Integer, Integer> scope : functionScopes.entrySet()) {
            Integer startIndex = scope.getKey();
            Integer endIndex = scope.getValue();
            Integer startLine = ScriptUtils.getLineNumberForIndex(source, startIndex);
            ArrayList<Integer> functionsOnLine = (ArrayList<Integer>)lineScopes.get(startLine);
            if (functionsOnLine == null) {
                functionsOnLine = new ArrayList<Integer>();
            }
            Integer endLine = ScriptUtils.getLineNumberForIndex(source, endIndex);
            functionsOnLine.add(endLine);
            lineScopes.put(startLine, functionsOnLine);
        }
        return lineScopes;
    }

    private static Map<Integer, Integer> getFunctionScopes(String source) {
        HashMap<Integer, Integer> scopes = new HashMap<Integer, Integer>();
        List<Integer> indexes = ScriptUtils.getMatchingIndexes(source, FUNCTION_PREFIX);
        int i = 0;
        while (i < indexes.size()) {
            int startIndex = indexes.get(i);
            Integer endIndex = ScriptUtils.getClosingBracketIndex(source, startIndex);
            scopes.put(startIndex, endIndex);
            ++i;
        }
        return scopes;
    }

    /*
     * Unable to fully structure code
     */
    private static List<Integer> getMatchingIndexes(String source, String match) {
        indexes = new ArrayList<Integer>();
        index = source.indexOf(match) + match.length() - 1;
        ** GOTO lbl10
        {
            ++index;
            do {
                if (source.charAt(index) != '{') continue block0;
                indexes.add(index);
                index = source.indexOf(match, index + 1);
lbl10:
                // 2 sources

            } while (index >= 0);
        }
        return indexes;
    }

    private static Integer getClosingBracketIndex(String text, int startingIndex) {
        ArrayDeque<Character> stack = new ArrayDeque<Character>();
        while (text.charAt(startingIndex) != '{' && startingIndex < text.length()) {
            ++startingIndex;
        }
        int i = startingIndex;
        while (i < text.length()) {
            char current = text.charAt(i);
            if (current == '{') {
                stack.push(Character.valueOf(current));
            }
            if (current == '}') {
                stack.pop();
            }
            if (stack.isEmpty()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static Integer getLineNumberForIndex(String source, Integer index) {
        int lineNum = 0;
        int i = 0;
        while (i < source.length()) {
            if (source.charAt(i) == '\n') {
                ++lineNum;
            }
            if (i == index) {
                return lineNum;
            }
            ++i;
        }
        return lineNum;
    }

    private static Integer getStartLine(Map<Integer, List<Integer>> lineScopes, Integer lineNumber) {
        int closestLine = -1;
        for (Map.Entry<Integer, List<Integer>> scope : lineScopes.entrySet()) {
            Integer startLine = scope.getKey();
            List<Integer> endLines = scope.getValue();
            for (Integer line : endLines) {
                if (lineNumber < startLine || lineNumber > line || closestLine > startLine) continue;
                closestLine = startLine;
            }
        }
        return closestLine;
    }

    private static Integer getStartColumn(String source, Integer breakpointLine) {
        Map<Integer, Integer> functionScopes = ScriptUtils.getFunctionScopes(source);
        int closestLine = 0;
        for (Map.Entry<Integer, Integer> e : functionScopes.entrySet()) {
            Integer scopeStart = e.getKey();
            Integer scopeEnd = e.getValue();
            Integer startLine = ScriptUtils.getLineNumberForIndex(source, scopeStart);
            Integer endLine = ScriptUtils.getLineNumberForIndex(source, scopeEnd);
            if (breakpointLine < startLine || breakpointLine > endLine || closestLine > startLine) continue;
            closestLine = startLine;
        }
        String line = ScriptUtils.getLine(source, closestLine);
        int column = 0;
        int index = 0;
        while (index < line.length()) {
            if (line.charAt(index) == '{') {
                return column;
            }
            column = line.charAt(index) == '\t' ? (column += 4) : ++column;
            ++index;
        }
        return column;
    }

    private static String getLine(String source, Integer lineNumber) {
        return source.split("\n")[lineNumber];
    }

    private static Integer getEndLine(Map<Integer, List<Integer>> lineScopes, Integer lineNumber) {
        int closestEndLine = Integer.MAX_VALUE;
        Integer startLine = ScriptUtils.getStartLine(lineScopes, lineNumber);
        for (Map.Entry<Integer, List<Integer>> e : lineScopes.entrySet()) {
            if (!e.getKey().equals(startLine)) continue;
            for (Integer endLine : e.getValue()) {
                if (lineNumber > endLine || endLine > closestEndLine) continue;
                closestEndLine = endLine;
            }
        }
        if (closestEndLine == Integer.MAX_VALUE) {
            return -1;
        }
        return closestEndLine;
    }

    private static Integer getEndColumn(String source, Integer startLine, Integer startColumn) {
        Map<Integer, Map<Integer, Integer>> scopes = ScriptUtils.getColumnScopes(source);
        for (Map.Entry<Integer, Map<Integer, Integer>> scope : scopes.entrySet()) {
            Integer startLineForScope = scope.getKey();
            if (!startLineForScope.equals(startLine)) continue;
            Map<Integer, Integer> columnScopes = scope.getValue();
            for (Map.Entry<Integer, Integer> e : columnScopes.entrySet()) {
                Integer startColumnForScope = e.getKey();
                if (!startColumnForScope.equals(startColumn)) continue;
                Integer endColumn = e.getValue();
                return endColumn;
            }
        }
        return -1;
    }

    private static Map<Integer, Map<Integer, Integer>> getColumnScopes(String source) {
        HashMap<Integer, Map<Integer, Integer>> scopes = new HashMap<Integer, Map<Integer, Integer>>();
        Map<Integer, Integer> functionScopes = ScriptUtils.getFunctionScopes(source);
        for (Map.Entry<Integer, Integer> e : functionScopes.entrySet()) {
            Integer startScope = e.getKey();
            Integer endScope = e.getValue();
            Integer startLine = ScriptUtils.getLineNumberForIndex(source, startScope);
            Integer startColumn = ScriptUtils.getColumnNumberForIndex(source, startScope);
            Integer endColumn = ScriptUtils.getColumnNumberForIndex(source, endScope);
            HashMap<Integer, Integer> columnScope = new HashMap<Integer, Integer>();
            columnScope.put(startColumn, endColumn);
            scopes.put(startLine, columnScope);
        }
        return scopes;
    }

    private static Integer getColumnNumberForIndex(String source, Integer index) {
        int columnNum = 0;
        int i = 0;
        while (i < source.length()) {
            if (i == index) {
                return columnNum;
            }
            if (source.charAt(i) == '\n') {
                columnNum = 0;
            }
            if (source.charAt(i) == '\t') {
                columnNum += 4;
            }
            ++columnNum;
            ++i;
        }
        return columnNum;
    }
}

