/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.eclipse.dirigible.repository.datasource.WrappedDataSource;
import org.eclipse.dirigible.repository.logging.Logger;

public class WrappedConnection
implements Connection {
    private static final Logger logger = Logger.getLogger(WrappedConnection.class);
    private Connection originalConnection;
    private long timeAcquired;
    private WrappedDataSource dataSource;

    public WrappedConnection(Connection originalConnection, WrappedDataSource dataSource) {
        this.originalConnection = originalConnection;
        this.timeAcquired = GregorianCalendar.getInstance().getTime().getTime();
        this.dataSource = dataSource;
    }

    public long getTimeAcquired() {
        logger.debug("called - getTimeAcquired(): " + this.timeAcquired);
        return this.timeAcquired;
    }

    public long getTimeUsed() {
        long timeUsed = GregorianCalendar.getInstance().getTime().getTime() - this.timeAcquired;
        logger.debug("called - getTimeUsed(): " + timeUsed);
        return timeUsed;
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.debug("entering - clearWarnings()");
        this.originalConnection.clearWarnings();
        logger.debug("exiting - clearWarnings()");
    }

    @Override
    public void close() throws SQLException {
        logger.debug("entering - close()");
        if (!this.originalConnection.getAutoCommit()) {
            this.originalConnection.commit();
        }
        this.originalConnection.close();
        this.dataSource.closedConnection(this);
        logger.debug("exiting - close()");
    }

    @Override
    public void commit() throws SQLException {
        logger.debug("entering - commit()");
        if (!this.originalConnection.getAutoCommit()) {
            this.originalConnection.commit();
        }
        logger.debug("exiting - commit()");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        logger.debug("called - createArrayOf(String typeName, Object[] elements)");
        return this.originalConnection.createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        logger.debug("called - createBlob()");
        return this.originalConnection.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        logger.debug("called - createClob()");
        return this.originalConnection.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        logger.debug("called - createNClob()");
        return this.originalConnection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        logger.debug("called - createSQLXML()");
        return this.originalConnection.createSQLXML();
    }

    @Override
    public Statement createStatement() throws SQLException {
        logger.debug("called - createStatement()");
        return this.originalConnection.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.debug("called - createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
        return this.originalConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.debug("called - createStatement(int resultSetType, int resultSetConcurrency)");
        return this.originalConnection.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        logger.debug("called - createStatement(String typeName, Object[] attributes)");
        return this.originalConnection.createStruct(typeName, attributes);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        logger.debug("called - getAutoCommit()");
        return this.originalConnection.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        logger.debug("called - getCatalog()");
        return this.originalConnection.getCatalog();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        logger.debug("called - getClientInfo()");
        return this.originalConnection.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        logger.debug("called - getClientInfo(String name)");
        return this.originalConnection.getClientInfo(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        logger.debug("called - getHoldability()");
        return this.originalConnection.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        logger.debug("called - getMetaData()");
        return this.originalConnection.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        logger.debug("called - getTransactionIsolation()");
        return this.originalConnection.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        logger.debug("called - getTypeMap()");
        return this.originalConnection.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.debug("called - getWarnings()");
        return this.originalConnection.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        logger.debug("called - isClosed()");
        return this.originalConnection.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        logger.debug("called - isReadOnly()");
        return this.originalConnection.isReadOnly();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        logger.debug("called - isValid(int timeout)");
        return this.originalConnection.isValid(timeout);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.debug("called - isWrapperFor(Class<?> iface)");
        return this.originalConnection.isWrapperFor(iface);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        logger.debug("called - nativeSQL(String sql): " + sql);
        return this.originalConnection.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.debug("called - prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability): " + sql);
        return this.originalConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.debug("called - prepareCall(String sql, int resultSetType, int resultSetConcurrency): " + sql);
        return this.originalConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        logger.debug("called - prepareCall(String sql): " + sql);
        return this.originalConnection.prepareCall(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.debug("called - prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability): " + sql);
        return this.originalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.debug("called - prepareStatement(String sql, int resultSetType, int resultSetConcurrency): " + sql);
        return this.originalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        logger.debug("called - prepareStatement(String sql, int autoGeneratedKeys): " + sql);
        return this.originalConnection.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        logger.debug("called - prepareStatement(String sql, int[] columnIndexes): " + sql);
        return this.originalConnection.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        logger.debug("called - prepareStatement(String sql, String[] columnNames): " + sql);
        return this.originalConnection.prepareStatement(sql, columnNames);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        logger.debug("called - prepareStatement(String sql): " + sql);
        return this.originalConnection.prepareStatement(sql);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        logger.debug("called - releaseSavepoint(Savepoint savepoint)");
        this.originalConnection.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        logger.debug("called - rollback()");
        if (!this.originalConnection.getAutoCommit()) {
            this.originalConnection.rollback();
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        logger.debug("called - rollback(Savepoint savepoint)");
        if (!this.originalConnection.getAutoCommit()) {
            this.originalConnection.rollback(savepoint);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        logger.debug("called - setAutoCommit(boolean autoCommit)");
        this.originalConnection.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        logger.debug("called - setCatalog(String catalog)");
        this.originalConnection.setCatalog(catalog);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        logger.debug("called - setClientInfo(Properties properties)");
        this.originalConnection.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        logger.debug("called - setClientInfo(String name, String value)");
        this.originalConnection.setClientInfo(name, value);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        logger.debug("called - setHoldability(int holdability)");
        this.originalConnection.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        logger.debug("called - setReadOnly(boolean readOnly)");
        this.originalConnection.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        logger.debug("called - setSavepoint()");
        return this.originalConnection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        logger.debug("called - setSavepoint(String name)");
        return this.originalConnection.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        logger.debug("called - setTransactionIsolation(int level): " + level);
        this.originalConnection.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        logger.debug("called - setTypeMap(Map<String, Class<?>> map)");
        this.originalConnection.setTypeMap(map);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.debug("called - unwrap(Class<T> iface)");
        return this.originalConnection.unwrap(iface);
    }

    @Override
    public void abort(Executor arg0) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void setNetworkTimeout(Executor arg0, int arg1) throws SQLException {
    }

    @Override
    public void setSchema(String arg0) throws SQLException {
    }
}

