/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.utils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.logging.Logger;

public class RequestUtils {
    private static final Logger logger = Logger.getLogger(RequestUtils.class);

    public static String getUser(HttpServletRequest request) {
        String user = "guest";
        try {
            if (request != null) {
                String fromCookie;
                if (request.getUserPrincipal() != null) {
                    user = request.getUserPrincipal().getName();
                } else if (!RequestUtils.isRolesEnabled(request).booleanValue() && (fromCookie = RequestUtils.getCookieValue(request, "dirigible_anonymous_user")) != null) {
                    user = fromCookie;
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return user;
    }

    public static String getCookieValue(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        int i = 0;
        while (i < cookies.length) {
            Cookie cookie = cookies[i];
            if (cookieName.equals(cookie.getName())) {
                return cookie.getValue();
            }
            ++i;
        }
        return null;
    }

    public static String get(HttpServletRequest request, String name) {
        String parameter = (String)request.getSession().getAttribute(name);
        return parameter;
    }

    public static Boolean isRolesEnabled(HttpServletRequest request) {
        Boolean rolesEnabled = Boolean.parseBoolean(RequestUtils.get(request, "enableRoles"));
        return rolesEnabled;
    }
}

