/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.scopes;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.impl.scopes.RootedModelScope;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class FilteredModelScope
extends RootedModelScope {
    private final Set<EObject> _inScope;

    public FilteredModelScope(List<? extends EObject> elements_p) {
        super(ModelsUtil.getRoots(elements_p));
        this._inScope = new FHashSet(elements_p, null);
    }

    @Override
    public boolean add(EObject element_p) {
        return this.add(element_p, false);
    }

    public boolean add(EObject element_p, boolean includeChildren_p) {
        boolean result = true;
        if (!(element_p.eContainer() != null && this._inScope.contains(element_p.eContainer()) || this._roots.contains(element_p))) {
            result = super.add(element_p);
        }
        if (result) {
            this._inScope.add(element_p);
            this._roots.removeAll((Collection<?>)element_p.eContents());
            if (includeChildren_p) {
                this.addAllChildrenToScope(element_p, null);
            }
        }
        return result;
    }

    @Override
    public boolean add(EObject source_p, EReference reference_p, EObject value_p) {
        boolean result;
        List<EObject> values;
        EObject previouslyContainedValue = null;
        if (!FeatureMapUtil.isMany((EObject)source_p, (EStructuralFeature)reference_p) && this.isContainment(reference_p) && !(values = this.get(source_p, reference_p)).isEmpty()) {
            previouslyContainedValue = values.get(0);
        }
        if (result = super.add(source_p, reference_p, value_p)) {
            if (previouslyContainedValue != null) {
                this._inScope.remove(previouslyContainedValue);
            }
            this._inScope.add(value_p);
        }
        return result;
    }

    public void build(ModelsUtil.IElementFilter filter_p) {
        this._inScope.clear();
        for (EObject root : super.getContents()) {
            if (filter_p != null && !filter_p.accepts(root)) continue;
            this._inScope.add(root);
            this.addAllChildrenToScope(root, filter_p);
        }
    }

    protected void addAllChildrenToScope(EObject element_p, ModelsUtil.IElementFilter filter_p) {
        TreeIterator technicalIterator = element_p.eAllContents();
        while (technicalIterator.hasNext()) {
            EObject child = (EObject)technicalIterator.next();
            if (filter_p == null || filter_p.accepts(child)) {
                this._inScope.add(child);
                continue;
            }
            technicalIterator.prune();
        }
    }

    @Override
    public boolean covers(EObject element_p) {
        return this._inScope.contains(element_p);
    }

    @Override
    protected List<EObject> get(EObject source_p, EReference reference_p, boolean resolveProxies_p) {
        List<EObject> originalValues = super.get(source_p, reference_p, resolveProxies_p);
        FArrayList result = new FArrayList(originalValues, null);
        result.retainAll(this._inScope);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<EObject> getContents() {
        FArrayList result = new FArrayList();
        result.addAll(super.getContents());
        result.retainAll(this._inScope);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<EObject> getContents(EObject element_p) {
        FArrayList result = new FArrayList(super.getContents(element_p), IEqualityTester.BY_REFERENCE);
        result.retainAll(this._inScope);
        return Collections.unmodifiableList(result);
    }

    @Override
    public Set<EObject> getAllContentsAsSet() {
        return Collections.unmodifiableSet(this._inScope);
    }

    @Override
    public boolean remove(EObject element_p) {
        boolean result = super.remove(element_p);
        if (result) {
            this.removeFromScope(element_p, true);
        }
        return result;
    }

    public void removeFromScope(EObject element_p, boolean includeChildren_p) {
        this._inScope.remove(element_p);
        if (includeChildren_p) {
            TreeIterator technicalIterator = element_p.eAllContents();
            while (technicalIterator.hasNext()) {
                EObject child = (EObject)technicalIterator.next();
                this._inScope.remove(child);
            }
        } else {
            for (EObject child : this.getContents(element_p)) {
                this.add(child, false);
            }
        }
    }
}

