/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionBridge
implements ISelectionChangedListener,
ISelectionProvider {
    private ISelection _selection = StructuredSelection.EMPTY;
    private final Set<ISelectionChangedListener> _selectionListeners = new HashSet<ISelectionChangedListener>();

    public void addSelectionChangedListener(ISelectionChangedListener listener_p) {
        this._selectionListeners.add(listener_p);
    }

    public ISelection getSelection() {
        return this._selection;
    }

    protected void notifyListeners() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this._selection);
        for (ISelectionChangedListener listener : new ArrayList<ISelectionChangedListener>(this._selectionListeners)) {
            listener.selectionChanged(event);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener_p) {
        this._selectionListeners.remove(listener_p);
    }

    public void setSelection(ISelection selection_p) {
        this._selection = selection_p;
        this.notifyListeners();
    }

    public void selectionChanged(SelectionChangedEvent event_p) {
        this.setSelection(event_p.getSelection());
    }

    public static class SingleSource
    extends SelectionBridge {
        private ISelectionProvider _source = null;

        public ISelectionProvider getSource() {
            return this._source;
        }

        public void setSource(ISelectionProvider source_p) {
            if (this._source != source_p) {
                if (this._source != null) {
                    this._source.removeSelectionChangedListener((ISelectionChangedListener)this);
                }
                this._source = source_p;
                if (source_p != null) {
                    source_p.addSelectionChangedListener((ISelectionChangedListener)this);
                    ISelection newSelection = source_p.getSelection();
                    if (newSelection != null) {
                        this.setSelection(newSelection);
                    }
                }
            }
        }
    }
}

