/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.viewers;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IBijectiveTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IMultiRoleSelection;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IRoleSelection;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.ITemplatePatternBasedSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.TemplatePatternApplicationSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.ModelSubsetViewer;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;

public class RoleBindingViewer
extends ModelSubsetViewer {
    private ITemplatePatternBasedSpecification _data;

    public RoleBindingViewer(Composite parent_p, boolean multipleSelection_p, boolean showParents_p) {
        super(parent_p, multipleSelection_p, showParents_p);
        this.addFilter(UIUtil.INSTANCE_VIEWER_FILTER);
    }

    @Override
    protected Font getFont(EObject element_p, Font defaultFont_p) {
        Font result = null;
        Collection roles = this._data.getRolesOf(element_p);
        if (!roles.isEmpty()) {
            boolean useBoundElementRepresentation;
            boolean bl = useBoundElementRepresentation = this._data instanceof IRoleSelection && roles.contains(((IRoleSelection)this._data).getRole());
            if (!useBoundElementRepresentation && this._data instanceof IMultiRoleSelection) {
                FOrderedSet intersection = new FOrderedSet(this._data.getRolesOf(element_p));
                intersection.retainAll(((IMultiRoleSelection)this._data).getRoles());
                useBoundElementRepresentation = !intersection.isEmpty();
            }
            result = useBoundElementRepresentation ? UIUtil.getBoundElementFont(defaultFont_p) : UIUtil.getBold(defaultFont_p);
        }
        return result;
    }

    @Override
    protected String getText(EObject element_p, String defaultText_p) {
        String result = super.getText(element_p, defaultText_p);
        if (result != null) {
            Collection roles = this._data.getRolesOf(element_p);
            List additionRoles = this._data instanceof TemplatePatternApplicationSpecification ? ((TemplatePatternApplicationSpecification)this._data).getAdditionRolesOf(element_p) : Collections.emptyList();
            if (this.isMultiple(element_p)) {
                result = UIUtil.markAsMultipleElement(result);
            }
            result = UIUtil.markAsBoundElement(result, roles, additionRoles);
        }
        return result;
    }

    private boolean isMultiple(EObject element_p) {
        boolean result = false;
        if (this._data.getPattern() != null) {
            IBijectiveTemplatePatternSpecification bijection;
            EObject attempt;
            EObject templateElement = element_p;
            if (this._data instanceof IBijectiveTemplatePatternSpecification && (attempt = (bijection = (IBijectiveTemplatePatternSpecification)this._data).getCounterpart(element_p, false)) != null) {
                templateElement = attempt;
            }
            result = this._data.getPattern().getMultiElements().contains((Object)templateElement);
        }
        return result;
    }

    @Override
    public void setInput(Object input_p) {
        if (input_p instanceof ITemplatePatternBasedSpecification) {
            this._data = (ITemplatePatternBasedSpecification)input_p;
            if (this._data instanceof IRoleSelection) {
                ((IRoleSelection)this._data).addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

                    public void roleChanged(TemplatePatternRole newRole_p) {
                        RoleBindingViewer.this.refresh();
                    }
                });
            }
            if (this._data instanceof IMultiRoleSelection) {
                ((IMultiRoleSelection)this._data).addSelectedRolesListener(new IMultiRoleSelection.IRolesChangedListener(){

                    public void rolesChanged(Collection<? extends TemplatePatternRole> newRoles_p) {
                        RoleBindingViewer.this.refresh();
                    }
                });
            }
            super.setInput(this._data.getAllElements());
        } else {
            super.setInput(input_p);
        }
    }
}

