/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.sirius;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.ui.sirius.Messages;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.categories.AbstractDifferenceCategory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;

public class SiriusTechnicalDifferenceCategory
extends AbstractDifferenceCategory {
    public static final String ID = "Sirius.Technical";
    protected static final String SIRIUS_ICON_PATH = "icons/obj16/SiriusFile.gif";
    protected static final Collection<EStructuralFeature> SIRIUS_TECHNICAL_FEATURES = Arrays.asList(ViewpointPackage.eINSTANCE.getDAnalysis_Version(), ViewpointPackage.eINSTANCE.getDAnalysis_SemanticResources(), ViewpointPackage.eINSTANCE.getDRepresentationDescriptor_RepPath(), ViewpointPackage.eINSTANCE.getDRepresentationDescriptor_ChangeId());

    public SiriusTechnicalDifferenceCategory() {
        this.setActive(true);
        this.setInFocusMode(false);
        this.setVisible(true);
        this.setModifiable(true);
    }

    public boolean covers(IDifference difference_p, EMFDiffNode node_p) {
        boolean result = false;
        if (difference_p instanceof IValuePresence) {
            IValuePresence vp = (IValuePresence)difference_p;
            result = this.isSiriusTechnicalFeature(vp.getFeature());
        }
        return result;
    }

    public String getDescription(EMFDiffNode node_p) {
        return Messages.SiriusTechnicalDifferenceCategory_Description;
    }

    public String getID() {
        return ID;
    }

    public Image getImage(EMFDiffNode node_p) {
        return SiriusEditPlugin.getPlugin().getBundledImage(SIRIUS_ICON_PATH);
    }

    public String getText(EMFDiffNode node_p) {
        return Messages.SiriusTechnicalDifferenceCategory_Text;
    }

    protected boolean isSiriusTechnicalFeature(EStructuralFeature feature_p) {
        return SIRIUS_TECHNICAL_FEATURES.contains(feature_p);
    }
}

