/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ide;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.eclipse.amp.escape.ide.ExpectedValue;
import org.eclipse.amp.escape.ide.ParamValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterReader {
    String projectName;
    IProject project;
    IPath paramPath;
    IFile eclipseFile;
    String rootPathString;
    private static final Set<String> keywords = new HashSet<String>();

    static {
        keywords.add("model");
        keywords.add("experiment");
        keywords.add("comments");
    }

    public ParameterReader(IResource resource) {
        this(resource.getProject(), resource.getProjectRelativePath());
        this.eclipseFile = (IFile)resource;
    }

    public ParameterReader(IProject project, IPath paramPath) {
        this.paramPath = paramPath;
        this.project = project;
        paramPath = ParameterReader.makeRelativeTo(paramPath, project.getLocation());
        this.eclipseFile = project.getFile(paramPath);
        if (!this.eclipseFile.exists()) {
            throw new RuntimeException("No file exists at path: " + paramPath + " in " + project);
        }
        this.rootPathString = project.getLocation().addTrailingSeparator().toOSString();
    }

    public ParameterReader(String projectName, String path) {
        this.paramPath = new Path(path);
        this.projectName = projectName;
        File file = new File(this.paramPath.toOSString());
        if (!file.exists()) {
            throw new RuntimeException("No file exists at system path: " + file);
        }
        int projectSegment = 0;
        String[] stringArray = this.paramPath.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment.equals(projectName)) break;
            ++projectSegment;
            ++n2;
        }
        this.rootPathString = String.valueOf(this.paramPath.uptoSegment(projectSegment + 1).toOSString()) + File.separator;
    }

    public static int matchingFirstSegments(IPath target, IPath anotherPath) {
        Assert.isNotNull((Object)anotherPath);
        int anotherPathLen = anotherPath.segmentCount();
        int max = Math.min(target.segments().length, anotherPathLen);
        int count = 0;
        int i = 0;
        while (i < max) {
            if (!target.segments()[i].equals(anotherPath.segment(i))) {
                return count;
            }
            ++count;
            ++i;
        }
        return count;
    }

    public static IPath makeRelativeTo(IPath target, IPath base) {
        int commonLength = ParameterReader.matchingFirstSegments(target, base);
        Path newPath = new Path("");
        int i = 0;
        while (i < base.segmentCount() - commonLength) {
            newPath = newPath.append("../");
            ++i;
        }
        i = commonLength;
        while (i < target.segmentCount()) {
            newPath = newPath.append(target.segments()[i]);
            ++i;
        }
        return newPath;
    }

    private BufferedReader createReader() {
        InputStream is;
        block5: {
            is = null;
            try {
                if (this.eclipseFile != null) {
                    is = this.eclipseFile.getContents();
                    break block5;
                }
                String directFilePath = this.paramPath.toPortableString();
                try {
                    File inputFile = new File(directFilePath);
                    is = new FileInputStream(inputFile);
                }
                catch (IOException e) {
                    throw new RuntimeException("Couldn't read model file: " + directFilePath, e);
                }
            }
            catch (CoreException e) {
                throw new RuntimeException("Couldn't read model file: " + this.eclipseFile.getFullPath(), e);
            }
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    public ParameterReader getRelative(IPath newPath) {
        if (this.project != null) {
            return new ParameterReader(this.project, newPath);
        }
        return new ParameterReader(this.projectName, newPath.toOSString());
    }

    public IPath getIncorporated(IPath filePath) {
        if (!filePath.isAbsolute()) {
            IPath curentPath = this.paramPath.removeLastSegments(1);
            filePath = curentPath.append(filePath);
        }
        filePath = filePath.addFileExtension("apar");
        return filePath;
    }

    public ParameterReader getTested() {
        IPath testPath = null;
        try {
            BufferedReader reader = this.createReader();
            String next = reader.readLine();
            while (next != null) {
                if (next.startsWith("tests")) {
                    testPath = new Path(next.substring(6, next.length()));
                    testPath = this.getIncorporated(testPath);
                    break;
                }
                next = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read model file: " + e);
        }
        if (testPath == null) {
            testPath = this.paramPath.removeFileExtension().addFileExtension("apar");
        }
        return this.getRelative(testPath);
    }

    public List<ParamValue> pvsFromFile() {
        List<ParamValue> pvs = new ArrayList<ParamValue>();
        BufferedReader reader = this.createReader();
        try {
            String next = reader.readLine();
            while (next != null) {
                StringTokenizer t = new StringTokenizer(next, "\t");
                try {
                    String param = t.nextToken();
                    String value = t.nextToken();
                    value = StringUtils.replace((String)value, (String)"|", (String)this.rootPathString);
                    if (param.equals("incorporates")) {
                        Path incorporatePath = new Path(value);
                        incorporatePath = this.getIncorporated((IPath)incorporatePath);
                        pvs = ParameterReader.mergePV(pvs, this.getRelative((IPath)incorporatePath).pvsFromFile());
                    } else {
                        ParamValue pv = new ParamValue(param, value);
                        pvs.add(pv);
                    }
                }
                catch (NoSuchElementException e) {
                    System.out.println("Ignoring line: " + next);
                }
                next = reader.readLine();
            }
            return pvs;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Problem reading file.", ioe);
        }
    }

    public List<ExpectedValue> getConstraints() {
        ArrayList<ExpectedValue> args = new ArrayList<ExpectedValue>();
        BufferedReader reader = this.createReader();
        try {
            String next = reader.readLine();
            while (next != null) {
                try {
                    StringTokenizer t = new StringTokenizer(next, "\t");
                    ExpectedValue ev = new ExpectedValue(t.nextToken(), t.nextToken(), t.nextToken());
                    args.add(ev);
                }
                catch (NoSuchElementException e) {
                    System.out.println("Ignoring line: " + next);
                }
                next = reader.readLine();
            }
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        return args;
    }

    static String argFromPV(ParamValue pv) {
        return String.valueOf(pv.param.replaceAll(" ", "")) + "=" + pv.value;
    }

    public static String[] argsFromPV(List<ParamValue> pvArgs) {
        ArrayList<String> args = new ArrayList<String>();
        for (ParamValue pv : pvArgs) {
            if (keywords.contains(pv.param)) continue;
            args.add(ParameterReader.argFromPV(pv));
        }
        return args.toArray(new String[0]);
    }

    public static List<ParamValue> mergePV(List<ParamValue> pv1, List<ParamValue> pv2) {
        ArrayList<ParamValue> args = new ArrayList<ParamValue>();
        HashSet<String> overrides = new HashSet<String>();
        for (ParamValue pv : pv2) {
            overrides.add(pv.param);
        }
        for (ParamValue pv : pv1) {
            if (overrides.contains(pv.param)) continue;
            args.add(pv);
        }
        for (ParamValue pv : pv2) {
            args.add(pv);
        }
        return args;
    }

    public String modelClassNameFromFile() {
        List<ParamValue> pvs = this.pvsFromFile();
        return this.valueForParam(pvs, "model");
    }

    public String titleFromFile() {
        List<ParamValue> pvs = this.pvsFromFile();
        String name = this.valueForParam(pvs, "title");
        if (name == null) {
            name = this.paramPath.removeFileExtension().lastSegment();
        }
        if (name == null) {
            throw new RuntimeException("Couldn't determine run title.");
        }
        return name;
    }

    public String valueForParam(List<ParamValue> pvs, String paramName) {
        for (ParamValue pv : pvs) {
            if (!pv.param.equalsIgnoreCase(paramName)) continue;
            return pv.value;
        }
        return null;
    }

    public String getName() {
        return this.getParamPath().removeFileExtension().lastSegment();
    }

    public IProject getProject() {
        return this.project;
    }

    public IPath getParamPath() {
        return this.paramPath;
    }

    public IFile getFile() {
        return this.eclipseFile;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

