/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.variables.BuildInfoType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class BuildInfoTypeNode
extends BaseDataVariableTypeNode
implements BuildInfoType {
    public BuildInfoTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public String getProductUri() throws UaException {
        BaseDataVariableTypeNode node = this.getProductUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setProductUri(String productUri) throws UaException {
        BaseDataVariableTypeNode node = this.getProductUriNode();
        node.setValue(new Variant((Object)productUri));
    }

    @Override
    public String readProductUri() throws UaException {
        try {
            return this.readProductUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeProductUri(String productUri) throws UaException {
        try {
            this.writeProductUriAsync(productUri).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readProductUriAsync() {
        return ((CompletableFuture)this.getProductUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeProductUriAsync(String productUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)productUri));
        return this.getProductUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getProductUriNode() throws UaException {
        try {
            return this.getProductUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getProductUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ProductUri", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getManufacturerName() throws UaException {
        BaseDataVariableTypeNode node = this.getManufacturerNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setManufacturerName(String manufacturerName) throws UaException {
        BaseDataVariableTypeNode node = this.getManufacturerNameNode();
        node.setValue(new Variant((Object)manufacturerName));
    }

    @Override
    public String readManufacturerName() throws UaException {
        try {
            return this.readManufacturerNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeManufacturerName(String manufacturerName) throws UaException {
        try {
            this.writeManufacturerNameAsync(manufacturerName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readManufacturerNameAsync() {
        return ((CompletableFuture)this.getManufacturerNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeManufacturerNameAsync(String manufacturerName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)manufacturerName));
        return this.getManufacturerNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getManufacturerNameNode() throws UaException {
        try {
            return this.getManufacturerNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getManufacturerNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ManufacturerName", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getProductName() throws UaException {
        BaseDataVariableTypeNode node = this.getProductNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setProductName(String productName) throws UaException {
        BaseDataVariableTypeNode node = this.getProductNameNode();
        node.setValue(new Variant((Object)productName));
    }

    @Override
    public String readProductName() throws UaException {
        try {
            return this.readProductNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeProductName(String productName) throws UaException {
        try {
            this.writeProductNameAsync(productName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readProductNameAsync() {
        return ((CompletableFuture)this.getProductNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeProductNameAsync(String productName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)productName));
        return this.getProductNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getProductNameNode() throws UaException {
        try {
            return this.getProductNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getProductNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ProductName", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getSoftwareVersion() throws UaException {
        BaseDataVariableTypeNode node = this.getSoftwareVersionNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSoftwareVersion(String softwareVersion) throws UaException {
        BaseDataVariableTypeNode node = this.getSoftwareVersionNode();
        node.setValue(new Variant((Object)softwareVersion));
    }

    @Override
    public String readSoftwareVersion() throws UaException {
        try {
            return this.readSoftwareVersionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSoftwareVersion(String softwareVersion) throws UaException {
        try {
            this.writeSoftwareVersionAsync(softwareVersion).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readSoftwareVersionAsync() {
        return ((CompletableFuture)this.getSoftwareVersionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSoftwareVersionAsync(String softwareVersion) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)softwareVersion));
        return this.getSoftwareVersionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSoftwareVersionNode() throws UaException {
        try {
            return this.getSoftwareVersionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSoftwareVersionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SoftwareVersion", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getBuildNumber() throws UaException {
        BaseDataVariableTypeNode node = this.getBuildNumberNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setBuildNumber(String buildNumber) throws UaException {
        BaseDataVariableTypeNode node = this.getBuildNumberNode();
        node.setValue(new Variant((Object)buildNumber));
    }

    @Override
    public String readBuildNumber() throws UaException {
        try {
            return this.readBuildNumberAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeBuildNumber(String buildNumber) throws UaException {
        try {
            this.writeBuildNumberAsync(buildNumber).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readBuildNumberAsync() {
        return ((CompletableFuture)this.getBuildNumberNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeBuildNumberAsync(String buildNumber) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)buildNumber));
        return this.getBuildNumberNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getBuildNumberNode() throws UaException {
        try {
            return this.getBuildNumberNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getBuildNumberNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BuildNumber", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public DateTime getBuildDate() throws UaException {
        BaseDataVariableTypeNode node = this.getBuildDateNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setBuildDate(DateTime buildDate) throws UaException {
        BaseDataVariableTypeNode node = this.getBuildDateNode();
        node.setValue(new Variant((Object)buildDate));
    }

    @Override
    public DateTime readBuildDate() throws UaException {
        try {
            return this.readBuildDateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeBuildDate(DateTime buildDate) throws UaException {
        try {
            this.writeBuildDateAsync(buildDate).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readBuildDateAsync() {
        return ((CompletableFuture)this.getBuildDateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeBuildDateAsync(DateTime buildDate) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)buildDate));
        return this.getBuildDateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getBuildDateNode() throws UaException {
        try {
            return this.getBuildDateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getBuildDateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BuildDate", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

