/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public final class FordiacLogHelper {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

    public static void logError(String msg, Throwable t) {
        FordiacLogHelper.getLogger(STACK_WALKER.getCallerClass()).error(msg, t);
    }

    public static void logError(String msg) {
        FordiacLogHelper.getLogger(STACK_WALKER.getCallerClass()).error(msg);
    }

    public static void logWarning(String msg, Exception e) {
        FordiacLogHelper.getLogger(STACK_WALKER.getCallerClass()).warn(msg, (Throwable)e);
    }

    public static void logWarning(String msg) {
        FordiacLogHelper.getLogger(STACK_WALKER.getCallerClass()).warn(msg);
    }

    public static void logInfo(String msg) {
        FordiacLogHelper.getLogger(STACK_WALKER.getCallerClass()).info(msg);
    }

    private static ILog getLogger(Class<?> classFromBundle) {
        return Platform.getLog((Bundle)FordiacLogHelper.getBundle(classFromBundle));
    }

    private static Bundle getBundle(Class<?> classFromBundle) {
        return FrameworkUtil.getBundle(classFromBundle);
    }

    private FordiacLogHelper() {
        throw new UnsupportedOperationException("Helper class should not be instatiated");
    }
}

