/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.configuration;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;

public abstract class ForwardingCompareConfiguration
extends CompareConfiguration {
    private final ListenerList fListeners = new ListenerList();
    private final IPropertyChangeListener delegateProperyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ForwardingCompareConfiguration.this.fireChange(event.getProperty(), event.getOldValue(), event.getNewValue());
        }
    };

    protected abstract CompareConfiguration delegate();

    public IPreferenceStore getPreferenceStore() {
        return this.delegate().getPreferenceStore();
    }

    public Image getImage(int kind) {
        return this.delegate().getImage(kind);
    }

    public Image getImage(Image base, int kind) {
        return this.delegate().getImage(base, kind);
    }

    public void dispose() {
        this.delegate().removePropertyChangeListener(this.delegateProperyChangeListener);
        this.delegate().dispose();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    protected final void fireChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = null;
        Object[] listeners = this.fListeners.getListeners();
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                IPropertyChangeListener l = (IPropertyChangeListener)listeners[i];
                if (event == null) {
                    event = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
                }
                l.propertyChange(event);
                ++i;
            }
        }
    }

    public void setProperty(String key, Object newValue) {
        if (this.delegate() != null) {
            this.delegate().setProperty(key, newValue);
        }
    }

    public Object getProperty(String key) {
        return this.delegate().getProperty(key);
    }

    public void setAncestorLabel(String label) {
        this.delegate().setAncestorLabel(label);
    }

    public String getAncestorLabel(Object element) {
        return this.delegate().getAncestorLabel(element);
    }

    public void setAncestorImage(Image image) {
        this.delegate().setAncestorImage(image);
    }

    public Image getAncestorImage(Object element) {
        return this.delegate().getAncestorImage(element);
    }

    public void setLeftEditable(boolean editable) {
        this.delegate().setLeftEditable(editable);
    }

    public boolean isLeftEditable() {
        return this.delegate().isLeftEditable();
    }

    public void setLeftLabel(String label) {
        this.delegate().setLeftLabel(label);
    }

    public String getLeftLabel(Object element) {
        return this.delegate().getLeftLabel(element);
    }

    public void setLeftImage(Image image) {
        this.delegate().setLeftImage(image);
    }

    public Image getLeftImage(Object element) {
        return this.delegate().getLeftImage(element);
    }

    public void setRightEditable(boolean editable) {
        this.delegate().setRightEditable(editable);
    }

    public boolean isRightEditable() {
        return this.delegate().isRightEditable();
    }

    public void setRightLabel(String label) {
        this.delegate().setRightLabel(label);
    }

    public String getRightLabel(Object element) {
        return this.delegate().getRightLabel(element);
    }

    public void setRightImage(Image image) {
        this.delegate().setRightImage(image);
    }

    public Image getRightImage(Object element) {
        return this.delegate().getRightImage(element);
    }

    public ICompareContainer getContainer() {
        return this.delegate().getContainer();
    }

    public void setContainer(ICompareContainer container) {
        this.delegate().setContainer(container);
    }

    public ICompareInputLabelProvider getLabelProvider() {
        return this.delegate().getLabelProvider();
    }

    public void setLabelProvider(ICompareInput input, ICompareInputLabelProvider labelProvider) {
        this.delegate().setLabelProvider(input, labelProvider);
    }

    public void setDefaultLabelProvider(ICompareInputLabelProvider labelProvider) {
        this.delegate().setDefaultLabelProvider(labelProvider);
    }

    public void setChangeIgnored(int kind, boolean ignored) {
        this.delegate().setChangeIgnored(kind, ignored);
    }

    public boolean isChangeIgnored(int kind) {
        return this.delegate().isChangeIgnored(kind);
    }

    public boolean isEditable(boolean left) {
        if (left) {
            return this.isLeftEditable();
        }
        return this.isRightEditable();
    }

    public boolean isMirrored() {
        Object property = this.getProperty("MIRRORED");
        return property instanceof Boolean && (Boolean)property != false;
    }

    public static abstract class MirroredPropertyChangeListener
    implements IPropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            if ("MIRRORED".equals(event.getProperty())) {
                Object newValue = event.getNewValue();
                this.mirroredPropertyChanged(Boolean.TRUE.equals(newValue));
            }
        }

        protected abstract void mirroredPropertyChanged(boolean var1);
    }
}

