/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.performance.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class GroupMultiColumnReorderCommandHandler
extends AbstractLayerCommandHandler<MultiColumnReorderCommand> {
    private final ColumnGroupHeaderLayer columnGroupHeaderLayer;

    public GroupMultiColumnReorderCommandHandler(ColumnGroupHeaderLayer columnGroupHeaderLayer) {
        this.columnGroupHeaderLayer = columnGroupHeaderLayer;
    }

    @Override
    protected boolean doCommand(MultiColumnReorderCommand command) {
        SelectionLayer.MoveDirectionEnum moveDirection;
        boolean reorderToLeftEdge;
        List<Integer> fromColumnPositions = command.getFromColumnPositions();
        int toColumnPosition = command.getToColumnPosition();
        if (!ColumnGroupUtils.isBetweenTwoGroups(this.columnGroupHeaderLayer, toColumnPosition, reorderToLeftEdge = command.isReorderToLeftEdge(), moveDirection = PositionUtil.getHorizontalMoveDirection(fromColumnPositions.get(0), toColumnPosition))) {
            for (int fromColumnPosition : fromColumnPositions) {
                if (ColumnGroupUtils.isReorderValid(this.columnGroupHeaderLayer, fromColumnPosition, toColumnPosition, reorderToLeftEdge)) continue;
                return true;
            }
        }
        int toPositionToCheck = toColumnPosition;
        if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection && reorderToLeftEdge) {
            --toPositionToCheck;
        }
        HashMap<GroupModel, Set> collapsed = new HashMap<GroupModel, Set>();
        int level = 0;
        while (level < this.columnGroupHeaderLayer.getLevelCount()) {
            GroupModel model2 = this.columnGroupHeaderLayer.getGroupModel(level);
            for (int fromColumnPosition : fromColumnPositions) {
                GroupModel.Group fromGroup = this.columnGroupHeaderLayer.getGroupByPosition(level, fromColumnPosition);
                if (fromGroup == null || !fromGroup.isCollapsed()) continue;
                HashSet<GroupModel.Group> collapsedGroups2 = (HashSet<GroupModel.Group>)collapsed.get(model2);
                if (collapsedGroups2 == null) {
                    collapsedGroups2 = new HashSet<GroupModel.Group>();
                    collapsed.put(model2, collapsedGroups2);
                }
                collapsedGroups2.add(fromGroup);
            }
            ++level;
        }
        if (!collapsed.isEmpty()) {
            int[] fromIndexes = fromColumnPositions.stream().mapToInt(this.columnGroupHeaderLayer.getPositionLayer()::getColumnIndexByPosition).toArray();
            int toIndex = this.columnGroupHeaderLayer.getPositionLayer().getColumnIndexByPosition(toColumnPosition);
            collapsed.forEach((model, collapsedGroups) -> collapsedGroups.forEach(group -> this.columnGroupHeaderLayer.expandGroup((GroupModel)model, (GroupModel.Group)group)));
            int[] fromPositions = Arrays.stream(fromIndexes).map(this.columnGroupHeaderLayer.getPositionLayer()::getColumnPositionByIndex).toArray();
            command.updateFromColumnPositions(fromPositions);
            toPositionToCheck = this.columnGroupHeaderLayer.getPositionLayer().getColumnPositionByIndex(toIndex);
            command.updateToColumnPosition(toPositionToCheck);
            if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection && reorderToLeftEdge) {
                --toPositionToCheck;
            }
        }
        boolean toggleCoordinateByEdge = false;
        GroupModel.Group groupToEnd = null;
        GroupModel.Group groupToStart = null;
        int level2 = 0;
        while (level2 < this.columnGroupHeaderLayer.getLevelCount()) {
            GroupModel.Group toGroup = this.columnGroupHeaderLayer.getGroupByPosition(level2, toPositionToCheck);
            if (toGroup != null && SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection && toGroup.isGroupEnd(toPositionToCheck)) {
                toggleCoordinateByEdge = true;
                if (toGroup.isUnbreakable() && toGroup.getVisibleSpan() < toGroup.getOriginalSpan()) {
                    groupToEnd = toGroup;
                }
            } else if (toGroup != null && SelectionLayer.MoveDirectionEnum.LEFT == moveDirection && toGroup.isGroupStart(toPositionToCheck) && toGroup.isUnbreakable() && toGroup.getVisibleSpan() < toGroup.getOriginalSpan()) {
                groupToStart = toGroup;
            }
            ++level2;
        }
        if (toggleCoordinateByEdge) {
            command.toggleCoordinateByEdge();
        }
        if (groupToEnd != null) {
            return this.columnGroupHeaderLayer.getPositionLayer().getUnderlyingLayerByPosition(0, 0).doCommand(new MultiColumnReorderToGroupEndCommand(command, groupToEnd));
        }
        if (groupToStart != null) {
            return this.columnGroupHeaderLayer.getPositionLayer().getUnderlyingLayerByPosition(0, 0).doCommand(new MultiColumnReorderToGroupStartCommand(command, groupToStart));
        }
        return false;
    }

    @Override
    public Class<MultiColumnReorderCommand> getCommandClass() {
        return MultiColumnReorderCommand.class;
    }

    class MultiColumnReorderToGroupEndCommand
    extends MultiColumnReorderCommand {
        private final GroupModel.Group group;

        public MultiColumnReorderToGroupEndCommand(MultiColumnReorderCommand command, GroupModel.Group group) {
            super(command);
            this.group = group;
        }

        protected MultiColumnReorderToGroupEndCommand(MultiColumnReorderToGroupEndCommand command) {
            super(command);
            this.group = command.group;
        }

        @Override
        public boolean convertToTargetLayer(ILayer targetLayer) {
            int groupEndPosition;
            boolean convert = super.convertToTargetLayer(targetLayer);
            if (convert && !this.isReorderToLeftEdge() && targetLayer instanceof IUniqueIndexLayer && (groupEndPosition = this.group.getGroupEndPosition((IUniqueIndexLayer)targetLayer)) >= 0 && groupEndPosition > this.getToColumnPosition()) {
                this.toColumnPositionCoordinate.columnPosition = groupEndPosition;
            }
            return convert;
        }

        @Override
        public MultiColumnReorderToGroupEndCommand cloneCommand() {
            return new MultiColumnReorderToGroupEndCommand(this);
        }
    }

    class MultiColumnReorderToGroupStartCommand
    extends MultiColumnReorderCommand {
        private final GroupModel.Group group;

        public MultiColumnReorderToGroupStartCommand(MultiColumnReorderCommand command, GroupModel.Group group) {
            super(command);
            this.group = group;
        }

        protected MultiColumnReorderToGroupStartCommand(MultiColumnReorderToGroupStartCommand command) {
            super(command);
            this.group = command.group;
        }

        @Override
        public boolean convertToTargetLayer(ILayer targetLayer) {
            int groupStartPosition;
            boolean convert = super.convertToTargetLayer(targetLayer);
            if (convert && this.isReorderToLeftEdge() && targetLayer instanceof IUniqueIndexLayer && (groupStartPosition = ((IUniqueIndexLayer)targetLayer).getColumnPositionByIndex(this.group.getStartIndex())) >= 0 && groupStartPosition < this.getToColumnPosition()) {
                this.toColumnPositionCoordinate.columnPosition = groupStartPosition;
            }
            return convert;
        }

        @Override
        public MultiColumnReorderToGroupStartCommand cloneCommand() {
            return new MultiColumnReorderToGroupStartCommand(this);
        }
    }
}

