/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.quickfix;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.STVarGlobalDeclarationBlock;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.fordiac.ide.structuredtextcore.scoping.STStandardFunctionProvider;
import org.eclipse.fordiac.ide.structuredtextcore.scoping.STStandardFunctionScope;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAssignment;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCoreFactory;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCorePackage;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STImport;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.VarDeclarationKind;
import org.eclipse.fordiac.ide.structuredtextcore.ui.Messages;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreImportValidator;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreTypeUsageCollector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionDiffBuilder;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.Fixes;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;

public class STCoreQuickfixProvider
extends DefaultQuickfixProvider {
    @Inject
    private STStandardFunctionProvider standardFunctionProvider;
    @Inject
    protected EObjectAtOffsetHelper offsetHelper;
    @Inject
    private IQualifiedNameConverter nameConverter;
    @Inject
    private IQualifiedNameProvider nameProvider;
    @Inject
    private Provider<STCoreTypeUsageCollector> typeUsageCollectorProvider;
    @Inject
    private IScopeProvider scopeProvider;

    @Fix(value="org.eclipse.fordiac.ide.structuredtextcore.exitNotInLoop")
    public static void fixExitNotInLoop(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.acceptMulti(issue, Messages.STCoreQuickfixProvider_RemoveInvalidExitStatementLabel, Messages.STCoreQuickfixProvider_RemoveInvalidExitStatementDescription, null, (element, context) -> {
            context.setUpdateCrossReferences(false);
            context.setUpdateRelatedFiles(false);
            context.addModification((Notifier)element, EcoreUtil::remove);
        });
    }

    @Fix(value="org.eclipse.fordiac.ide.structuredtextcore.continueNotInLoop")
    public static void fixContinueNotInLoop(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.acceptMulti(issue, Messages.STCoreQuickfixProvider_RemoveInvalidContinueStatementLabel, Messages.STCoreQuickfixProvider_RemoveInvalidContinueStatementDescription, null, (element, context) -> {
            context.setUpdateCrossReferences(false);
            context.setUpdateRelatedFiles(false);
            context.addModification((Notifier)element, EcoreUtil::remove);
        });
    }

    @Fix(value="org.eclipse.fordiac.ide.structuredtextcore.identiferEndsInUnderscoreError")
    public static void fixTrailingUnderscore(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.acceptMulti(issue, Messages.STCoreQuickfixProvider_RemoveTrailingUnderscoreLabel, Messages.STCoreQuickfixProvider_RemoveTrailingUnderscoreDescription, null, (element, context) -> {
            context.setUpdateCrossReferences(true);
            context.setUpdateRelatedFiles(true);
            context.addModification((Notifier)element, namedElement -> namedElement.setName(namedElement.getName().replaceAll("_+$", "")));
        });
    }

    @Fix(value="org.eclipse.fordiac.ide.structuredtextcore.consecutiveUnderscoreInIdentifierError")
    public static void fixConsecutiveUnderscore(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.acceptMulti(issue, Messages.STCoreQuickfixProvider_RemoveConsecutiveUnderscoresLabel, Messages.STCoreQuickfixProvider_RemoveConsecutiveUnderscoresDescription, null, (element, context) -> {
            context.setUpdateCrossReferences(true);
            context.setUpdateRelatedFiles(true);
            context.addModification((Notifier)element, namedElement -> namedElement.setName(namedElement.getName().replaceAll("_{2,}", "_")));
        });
    }

    @Fix(value="org.eclipse.fordiac.ide.structuredtextcore.nonCompatibleTypes")
    public void fixNonCompatibleTypes(Issue issue, IssueResolutionAcceptor acceptor) {
        String castName = issue.getData()[0] + "_TO_" + issue.getData()[1];
        boolean castPossible = StreamSupport.stream(this.standardFunctionProvider.get().spliterator(), true).anyMatch(func -> func.getName().equals(castName));
        if (castPossible) {
            acceptor.accept(issue, Messages.STCoreQuickfixProvider_AddExplicitTypecastLabel, MessageFormat.format(Messages.STCoreQuickfixProvider_AddExplicitTypecastDescription, issue.getData()), null, context -> {
                IXtextDocument xtextDocument = context.getXtextDocument();
                if (xtextDocument != null) {
                    String original = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
                    String replacement = issue.getData()[0] + "_TO_" + issue.getData()[1] + "(" + original + ")";
                    xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), replacement);
                }
            });
        }
    }

    @Fix(value="org.eclipse.fordiac.ide.structuredtextcore.wrongNameCase")
    public static void fixVariableNameCasing(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.acceptMulti(issue, Messages.STCoreQuickfixProvider_ChangeVariableCaseAsDeclaredLabel, Messages.STCoreQuickfixProvider_ChangeVariableCaseAsDeclaredDescription, null, (element, context) -> {
            context.setUpdateCrossReferences(false);
            context.setUpdateRelatedFiles(false);
            context.addModification((Notifier)element, expression -> {
                ISemanticRegion featureRegion;
                IEObjectRegion expressionRegion;
                ITextRegionDiffBuilder textRegionDiffBuilder = context.getModifiableDocument((XtextResource)expression.eResource());
                if (textRegionDiffBuilder != null && (expressionRegion = textRegionDiffBuilder.getOriginalTextRegionAccess().regionForEObject((EObject)expression)) != null && (featureRegion = expressionRegion.getRegionFor().feature((EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE)) != null) {
                    textRegionDiffBuilder.replace(featureRegion, issue.getData()[1]);
                }
            });
        });
    }

    @Fix(value="org.eclipse.fordiac.ide.structuredtextcore.unnecessaryConversion")
    public static void fixUnnecessaryConversion(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.acceptMulti(issue, Messages.STCoreQuickfixProvider_RemoveUnnecessaryConversionLabel, Messages.STCoreQuickfixProvider_RemoveUnnecessaryConversionDescription, null, (element, context) -> {
            context.setUpdateCrossReferences(false);
            context.setUpdateRelatedFiles(false);
            context.addModification((Notifier)element, expression -> {
                IEObjectRegion expressionRegion;
                ITextRegionDiffBuilder textRegionDiffBuilder = context.getModifiableDocument((XtextResource)expression.eResource());
                if (textRegionDiffBuilder != null && (expressionRegion = textRegionDiffBuilder.getOriginalTextRegionAccess().regionForEObject((EObject)expression)) != null) {
                    ISemanticRegion parametersRegionBegin = expressionRegion.getRegionFor().keyword("(");
                    ISemanticRegion parametersRegionEnd = expressionRegion.getRegionFor().keyword(")");
                    if (parametersRegionBegin != null && parametersRegionEnd != null) {
                        textRegionDiffBuilder.remove(expressionRegion.getPreviousHiddenRegion(), parametersRegionBegin.getNextHiddenRegion());
                        textRegionDiffBuilder.remove(parametersRegionEnd.getPreviousHiddenRegion(), expressionRegion.getNextHiddenRegion());
                    }
                }
            });
        });
    }

    @Fixes(value={@Fix(value="org.eclipse.fordiac.ide.structuredtextcore.unnecessaryNarrowConversion"), @Fix(value="org.eclipse.fordiac.ide.structuredtextcore.unnecessaryWideConversion")})
    public static void fixUnnecessaryNarrowOrWideConversion(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.acceptMulti(issue, Messages.STCoreQuickfixProvider_ChangeConversionLabel, Messages.STCoreQuickfixProvider_ChangeConversionDescription, null, (element, context) -> {
            context.setUpdateCrossReferences(false);
            context.setUpdateRelatedFiles(false);
            context.addModification((Notifier)element, expression -> {
                ISemanticRegion featureRegion;
                IEObjectRegion expressionRegion;
                ITextRegionDiffBuilder textRegionDiffBuilder = context.getModifiableDocument((XtextResource)expression.eResource());
                if (textRegionDiffBuilder != null && (expressionRegion = textRegionDiffBuilder.getOriginalTextRegionAccess().regionForEObject((EObject)expression)) != null && (featureRegion = expressionRegion.getRegionFor().feature((EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE)) != null) {
                    textRegionDiffBuilder.replace(featureRegion, issue.getData()[1] + "_TO_" + issue.getData()[2]);
                }
            });
        });
    }

    @Fixes(value={@Fix(value="org.eclipse.fordiac.ide.structuredtextcore.unnecessaryLiteralConversion"), @Fix(value="org.eclipse.fordiac.ide.structuredtextcore.truncatingLiteralConversion")})
    public static void fixRemoveLiteralConversion(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData()[2] != null) {
            acceptor.accept(issue, Messages.STCoreQuickfixProvider_RemoveLiteralConversionLabel, MessageFormat.format(Messages.STCoreQuickfixProvider_RemoveLiteralConversionDescription, issue.getData()[2]), null, context -> {
                IXtextDocument xtextDocument = context.getXtextDocument();
                if (xtextDocument != null) {
                    xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), issue.getData()[2]);
                }
            });
        }
    }

    @Fix(value="org.eclipse.fordiac.ide.structuredtextcore.packageNameMismatch")
    public static void fixPackageNameMismatch(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.acceptMulti(issue, Messages.STCoreQuickfixProvider_ChangePackage, Messages.STCoreQuickfixProvider_ChangePackage, null, (element, context) -> {
            context.setUpdateCrossReferences(true);
            context.setUpdateRelatedFiles(true);
            context.addModification((Notifier)element, source -> STCoreQuickfixProvider.setPackageName(source, issue.getData()[0]));
        });
    }

    @Fix(value="org.eclipse.fordiac.ide.structuredtextcore.invalidImport")
    public static void fixRemoveImport(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.acceptMulti(issue, Messages.STCoreQuickfixProvider_RemoveImportLabel, Messages.STCoreQuickfixProvider_RemoveImportDescription, null, (element, context) -> {
            context.setUpdateCrossReferences(false);
            context.setUpdateRelatedFiles(false);
            context.addModification((Notifier)element, imp -> {
                IEObjectRegion importRegion;
                ITextRegionDiffBuilder textRegionDiffBuilder = context.getModifiableDocument((XtextResource)imp.eResource());
                if (textRegionDiffBuilder != null && (importRegion = textRegionDiffBuilder.getOriginalTextRegionAccess().regionForEObject((EObject)imp)) != null) {
                    textRegionDiffBuilder.remove(importRegion.getPreviousHiddenRegion(), importRegion.getNextHiddenRegion());
                }
            });
        });
    }

    @Fixes(value={@Fix(value="org.eclipse.fordiac.ide.structuredtextcore.unusedImport"), @Fix(value="org.eclipse.fordiac.ide.structuredtextcore.wildcardImport")})
    public void organizeImports(Issue issue, IssueResolutionAcceptor acceptor) {
        if (!this.hasSyntaxErrors(issue)) {
            acceptor.acceptMulti(issue, Messages.STCoreQuickfixProvider_OrganizeImports, Messages.STCoreQuickfixProvider_OrganizeImports, null, (element, context) -> {
                context.setUpdateCrossReferences(false);
                context.setUpdateRelatedFiles(false);
                context.addModification((Notifier)element, imp -> this.organizeImports((STSource)EcoreUtil2.getContainerOfType((EObject)imp, STSource.class)));
            });
        }
    }

    protected void organizeImports(STSource source) {
        QualifiedName packageName = this.getPackageName(source);
        EList<STImport> imports = STCoreQuickfixProvider.getImports(source);
        if (imports == null) {
            return;
        }
        Set usedTypes = ((STCoreTypeUsageCollector)this.typeUsageCollectorProvider.get()).collectUsedTypes((EObject)source);
        HashSet imported = new HashSet(usedTypes.stream().filter(imp -> !STCoreImportValidator.isImplicitImport((QualifiedName)imp, (QualifiedName)packageName)).collect(Collectors.toMap(QualifiedName::getLastSegment, Function.identity(), (a, b) -> this.mergeImportedTypes((QualifiedName)a, (QualifiedName)b, (List<STImport>)imports))).values());
        imports.removeIf(imp -> !imported.remove(this.getQualifiedName((STImport)imp)));
        imported.stream().map(arg_0 -> ((IQualifiedNameConverter)this.nameConverter).toString(arg_0)).map(STCoreQuickfixProvider::createImport).forEachOrdered(arg_0 -> imports.add(arg_0));
        ECollections.sort(imports, Comparator.comparing(Import::getImportedNamespace));
    }

    protected QualifiedName mergeImportedTypes(QualifiedName first, QualifiedName second, List<STImport> imports) {
        if (this.matchesImports(first, imports)) {
            return first;
        }
        if (this.matchesImports(second, imports)) {
            return second;
        }
        return null;
    }

    protected boolean matchesImports(QualifiedName name, List<STImport> imports) {
        return imports.stream().anyMatch(imp -> this.matchesImport(name, (STImport)imp));
    }

    protected boolean matchesImport(QualifiedName name, STImport imp) {
        QualifiedName importedNamespace = this.getQualifiedName(imp);
        return importedNamespace.equals((Object)name) || importedNamespace.getLastSegment().equals("*") && importedNamespace.skipLast(1).equals((Object)name.skipLast(1));
    }

    protected QualifiedName getPackageName(STSource source) {
        String name;
        EStructuralFeature nameFeature;
        if (source != null && (nameFeature = STCoreQuickfixProvider.getPackageNameFeature(source)) != null && !Strings.isEmpty((String)(name = (String)source.eGet(nameFeature)))) {
            return this.nameConverter.toQualifiedName(name);
        }
        return QualifiedName.EMPTY;
    }

    protected static void setPackageName(STSource source, String newPackageName) {
        Resource resource;
        EStructuralFeature nameFeature = STCoreQuickfixProvider.getPackageNameFeature(source);
        if (nameFeature != null) {
            if (newPackageName == null || newPackageName.isEmpty()) {
                source.eUnset(nameFeature);
            } else {
                source.eSet(nameFeature, (Object)newPackageName);
            }
        }
        if ((resource = source.eResource()) instanceof LibraryElementXtextResource) {
            LibraryElementXtextResource libResource = (LibraryElementXtextResource)resource;
            PackageNameHelper.setPackageName((LibraryElement)libResource.getInternalLibraryElement(), (String)newPackageName);
        }
    }

    protected static EStructuralFeature getPackageNameFeature(STSource source) {
        EStructuralFeature nameFeature;
        if (source != null && (nameFeature = source.eClass().getEStructuralFeature("name")).getEType() == EcorePackage.eINSTANCE.getEString() && !nameFeature.isMany()) {
            return nameFeature;
        }
        return null;
    }

    protected static EList<STImport> getImports(STSource source) {
        EStructuralFeature importsFeature;
        if (source != null && (importsFeature = source.eClass().getEStructuralFeature("imports")) != null && importsFeature.getEType() == STCorePackage.eINSTANCE.getSTImport() && importsFeature.isMany()) {
            return (EList)source.eGet(importsFeature);
        }
        return null;
    }

    protected QualifiedName getQualifiedName(STImport imp) {
        String importedNamespace = imp.getImportedNamespace();
        if (Strings.isEmpty((String)importedNamespace)) {
            return QualifiedName.EMPTY;
        }
        return this.nameConverter.toQualifiedName(importedNamespace);
    }

    protected static STImport createImport(String importedNamespace) {
        STImport result = STCoreFactory.eINSTANCE.createSTImport();
        result.setImportedNamespace(importedNamespace);
        return result;
    }

    protected Iterable<IEObjectDescription> queryScope(IScope scope) {
        if (scope instanceof STStandardFunctionScope) {
            STStandardFunctionScope standardFunctionScope = (STStandardFunctionScope)scope;
            return Iterables.concat((Iterable)super.queryScope(standardFunctionScope.getParent()), (Iterable)standardFunctionScope.getAllLocalElements());
        }
        return super.queryScope(scope);
    }

    public void createLinkingIssueResolutions(final Issue issue, final IssueResolutionAcceptor acceptor) {
        IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        final IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        if (xtextDocument != null) {
            xtextDocument.tryReadOnly((IUnitOfWork)new CancelableUnitOfWork<Void, XtextResource>(){

                public Void exec(XtextResource state, CancelIndicator cancelIndicator) throws Exception {
                    try {
                        EObject target = state.getEObject(issue.getUriToProblem().fragment());
                        EReference reference = STCoreQuickfixProvider.this.getUnresolvedEReference(issue, target);
                        if (reference != null && reference.getEReferenceType() != null) {
                            STCoreQuickfixProvider.this.createLinkingIssueQuickfixes(issue, STCoreQuickfixProvider.this.getCancelableAcceptor(acceptor, cancelIndicator), xtextDocument, state, target, reference);
                        }
                    }
                    catch (WrappedException wrappedException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        super.createLinkingIssueResolutions(issue, acceptor);
    }

    protected void createLinkingIssueQuickfixes(Issue issue, IssueResolutionAcceptor acceptor, IXtextDocument xtextDocument, XtextResource state, EObject target, EReference reference) throws BadLocationException {
        String issueString = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
        IScope scope = this.scopeProvider.getScope(target, reference);
        QualifiedName packageName = this.nameProvider.getFullyQualifiedName((EObject)state.getContents().get(0));
        for (IEObjectDescription description : scope.getAllElements()) {
            if (STCoreQuickfixProvider.isAliased(description) || !Objects.equals(issueString, description.getQualifiedName().getLastSegment()) || STCoreImportValidator.isImplicitImport((QualifiedName)description.getQualifiedName(), (QualifiedName)packageName) || !this.isVisible(description, target)) continue;
            this.createImportProposal(issue, description.getQualifiedName(), acceptor);
        }
    }

    protected static boolean isAliased(IEObjectDescription description) {
        return description instanceof AliasedEObjectDescription;
    }

    protected boolean isVisible(IEObjectDescription description, EObject context) {
        return description.getName().getSegmentCount() == 1 || STCorePackage.eINSTANCE.getSTVarDeclaration().equals(description.getEClass()) && EcoreUtil.resolve((EObject)description.getEObjectOrProxy(), (EObject)context).eContainer() instanceof STVarGlobalDeclarationBlock || LibraryElementPackage.eINSTANCE.getLibraryElement().isSuperTypeOf(description.getEClass());
    }

    protected void createImportProposal(Issue issue, QualifiedName qualifiedName, IssueResolutionAcceptor acceptor) {
        String label = MessageFormat.format(Messages.STCoreQuickfixProvider_CreateImport, qualifiedName.getLastSegment(), this.nameConverter.toString(qualifiedName.skipLast(1)));
        String importedNamespace = this.nameConverter.toString(qualifiedName);
        this.createImportProposal(issue, label, importedNamespace, acceptor);
    }

    protected void createImportProposal(Issue issue, String label, String importedNamespace, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, label, label, null, (element, context) -> {
            EList<STImport> imports = STCoreQuickfixProvider.getImports((STSource)EcoreUtil2.getContainerOfType((EObject)element, STSource.class));
            if (imports != null) {
                imports.add((Object)STCoreQuickfixProvider.createImport(importedNamespace));
            }
        }, 100);
    }

    public void createMissingVariable(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, Messages.STCoreQuickfixProvider_CreateMissingInputVariable, Messages.STCoreQuickfixProvider_CreateMissingInputVariable, null, (element, context) -> this.createMissingVariable(element, VarDeclarationKind.INPUT));
        acceptor.accept(issue, Messages.STCoreQuickfixProvider_CreateMissingInOutVariable, Messages.STCoreQuickfixProvider_CreateMissingInOutVariable, null, (element, context) -> this.createMissingVariable(element, VarDeclarationKind.INOUT));
        acceptor.accept(issue, Messages.STCoreQuickfixProvider_CreateMissingOutputVariable, Messages.STCoreQuickfixProvider_CreateMissingOutputVariable, null, (element, context) -> this.createMissingVariable(element, VarDeclarationKind.OUTPUT));
        acceptor.accept(issue, Messages.STCoreQuickfixProvider_CreateMissingTempVariable, Messages.STCoreQuickfixProvider_CreateMissingTempVariable, null, (element, context) -> this.createMissingVariable(element, VarDeclarationKind.TEMP));
    }

    protected void createMissingVariable(EObject element, VarDeclarationKind kind) {
        if (element instanceof STFeatureExpression) {
            STFeatureExpression expression = (STFeatureExpression)element;
            ICallable callable = (ICallable)EcoreUtil2.getContainerOfType((EObject)expression, ICallable.class);
            String name = STCoreQuickfixProvider.getFeatureText(expression);
            INamedElement type = STCoreQuickfixProvider.getExpectedFeatureType(expression);
            if (callable != null && IdentifierVerifier.verifyIdentifier((String)name).isEmpty() && type != null) {
                this.createMissingVariable(callable, name, type, kind);
            }
        }
    }

    protected void createMissingVariable(ICallable callable, String name, INamedElement type, VarDeclarationKind kind) {
        throw new UnsupportedOperationException();
    }

    protected static void createSTVarDeclaration(EList<STVarDeclarationBlock> blocks, String name, INamedElement type, VarDeclarationKind kind) {
        STVarDeclarationBlock block = STCoreQuickfixProvider.getOrCreateSTVarDeclarationBlock(blocks, kind.getBlockClass());
        STVarDeclaration varDeclaration = STCoreQuickfixProvider.createSTVarDeclaration(name, type);
        block.getVarDeclarations().add((Object)varDeclaration);
    }

    protected static STVarDeclaration createSTVarDeclaration(String name, INamedElement type) {
        STVarDeclaration varDeclaration = STCoreFactory.eINSTANCE.createSTVarDeclaration();
        varDeclaration.setName(name);
        varDeclaration.setType(type);
        return varDeclaration;
    }

    protected static STVarDeclarationBlock getOrCreateSTVarDeclarationBlock(EList<STVarDeclarationBlock> blocks, EClass eClass) {
        return blocks.stream().filter(arg_0 -> ((EClass)eClass).isInstance(arg_0)).filter(Predicate.not(STVarDeclarationBlock::isConstant)).findFirst().orElseGet(() -> {
            STVarDeclarationBlock block = (STVarDeclarationBlock)STCoreFactory.eINSTANCE.create(eClass);
            blocks.add((Object)block);
            return block;
        });
    }

    protected static String getFeatureText(STFeatureExpression element) {
        return NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE).stream().map(INode::getText).map(String::trim).collect(Collectors.joining());
    }

    protected static INamedElement getExpectedFeatureType(STFeatureExpression element) {
        INamedElement resultType;
        STAssignment assignment;
        INamedElement expectedType = STCoreUtil.getExpectedType((STExpression)element);
        if (expectedType != null) {
            return expectedType;
        }
        EObject eObject = element.eContainer();
        if (eObject instanceof STAssignment && (assignment = (STAssignment)eObject).getLeft() == element && assignment.getRight() != null && (resultType = assignment.getRight().getResultType()) != null) {
            return resultType;
        }
        return IecTypes.ElementaryTypes.SINT;
    }

    protected boolean hasSyntaxErrors(Issue issue) {
        IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        return xtextDocument == null || (Boolean)xtextDocument.tryReadOnly(resource -> resource.getParseResult() == null || resource.getParseResult().hasSyntaxErrors()) != false;
    }
}

