/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.TypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class AttributeTypeImporter
extends TypeImporter {
    public AttributeTypeImporter(IFile typeFile) {
        super(typeFile);
    }

    public AttributeTypeImporter(InputStream inputStream, TypeLibrary typeLibrary) {
        super(inputStream, typeLibrary);
    }

    @Override
    public AttributeDeclaration getElement() {
        return (AttributeDeclaration)super.getElement();
    }

    @Override
    public LibraryElement createRootModelElement() {
        return LibraryElementFactory.eINSTANCE.createAttributeDeclaration();
    }

    @Override
    protected String getStartElementName() {
        return "AttributeDeclaration";
    }

    @Override
    protected CommonElementImporter.IChildHandler getBaseChildrenHandler() {
        return name -> {
            switch (name) {
                case "Identification": {
                    this.parseIdentification(this.getElement());
                    break;
                }
                case "VersionInfo": {
                    this.parseVersionInfo(this.getElement());
                    break;
                }
                case "CompilerInfo": {
                    this.getElement().setCompilerInfo(this.parseCompilerInfo());
                    break;
                }
                case "StructuredType": {
                    this.parseStructuredType(this.getElement());
                    break;
                }
                case "DirectlyDerivedType": {
                    this.parseDirectlyDerivedType(this.getElement());
                    this.proceedToEndElementNamed("DirectlyDerivedType");
                    break;
                }
                case "Attribute": {
                    this.parseGenericAttributeNode(this.getElement());
                    this.proceedToEndElementNamed("Attribute");
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        };
    }

    private void parseDirectlyDerivedType(AttributeDeclaration attribute) {
        DirectlyDerivedType directlyDerivedType = DataFactory.eINSTANCE.createDirectlyDerivedType();
        directlyDerivedType.setName(attribute.getName());
        String baseTypeName = this.getAttributeValue("BaseType");
        DataType baseType = this.getDataTypeLibrary().getType(baseTypeName);
        directlyDerivedType.setBaseType(baseType);
        String initalValue = this.getAttributeValue("InitialValue");
        directlyDerivedType.setInitialValue(initalValue);
        String comment = this.getAttributeValue("Comment");
        directlyDerivedType.setComment(comment);
        attribute.setType(directlyDerivedType);
    }

    private void parseStructuredType(AttributeDeclaration attribute) throws XMLStreamException, TypeImportException {
        StructuredType struct = DataFactory.eINSTANCE.createStructuredType();
        struct.setName(attribute.getName());
        this.processChildren("StructuredType", name -> {
            if ("VarDeclaration".equals(name)) {
                struct.getMemberVariables().add((Object)this.parseVarDeclaration());
                return true;
            }
            return false;
        });
        attribute.setType(struct);
    }
}

