/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.dataexport.FBNetworkExporter;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Link;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class SystemExporter
extends AbstractTypeExporter {
    public SystemExporter(AutomationSystem system) {
        super(system);
    }

    @Override
    public AutomationSystem getType() {
        return (AutomationSystem)super.getType();
    }

    @Override
    protected void createTypeSpecificXMLEntries() throws XMLStreamException {
        this.addCompilerInfo(this.getType().getCompilerInfo());
        this.addAttributes((EList<Attribute>)this.getType().getAttributes());
        this.addApplications();
        SystemConfiguration systemConfiguration = this.getType().getSystemConfiguration();
        if (systemConfiguration != null) {
            this.addDevices(systemConfiguration.getDevices());
            this.addSegment(systemConfiguration.getSegments());
            this.addMapping();
            this.addLink(systemConfiguration.getLinks());
        }
    }

    private void addApplications() throws XMLStreamException {
        for (Application app : this.getType().getApplication()) {
            this.addStartElement("Application");
            this.addNameAndCommentAttribute(app);
            this.addAttributes((EList<Attribute>)app.getAttributes());
            new FBNetworkExporter(this).createFBNetworkElement(app.getFBNetwork());
            this.addEndElement();
        }
    }

    private void addLink(EList<Link> linkList) throws XMLStreamException {
        for (Link link : linkList) {
            this.addStartElement("Link");
            this.getWriter().writeAttribute("SegmentName", link.getSegment().getName());
            this.getWriter().writeAttribute("CommResource", link.getDevice().getName());
            this.getWriter().writeAttribute("Comment", link.getComment());
            this.addAttributes((EList<Attribute>)link.getAttributes());
            this.addEndElement();
        }
    }

    private void addSegment(EList<Segment> segementList) throws XMLStreamException {
        for (Segment segment : segementList) {
            this.addStartElement("Segment");
            this.addNameTypeCommentAttribute(segment, segment.getType());
            this.addXYAttributes(segment);
            this.getWriter().writeAttribute("dx1", positionFormater.format(segment.getWidth()));
            this.addColorAttributeElement(segment);
            this.addAttributes((EList<Attribute>)segment.getAttributes());
            this.addParamsConfig(segment.getCommunication().getParameters());
            this.addEndElement();
        }
    }

    private void addMapping() throws XMLStreamException {
        for (Mapping mappingEntry : this.getType().getMapping()) {
            Resource resource = mappingEntry.getTo().getResource();
            if (resource == null) continue;
            this.addEmptyStartElement("Mapping");
            this.getWriter().writeAttribute("From", mappingEntry.getFrom().getQualifiedName());
            this.getWriter().writeAttribute("To", resource.getQualifiedName());
        }
    }

    private void addDevices(EList<Device> deviceList) throws XMLStreamException {
        for (Device device : deviceList) {
            this.addStartElement("Device");
            this.addNameTypeCommentAttribute(device, device.getType());
            this.addXYAttributes(device);
            this.addParamsConfig((EList<VarDeclaration>)device.getVarDeclarations());
            this.addDeviceAttributes(device);
            this.addResources(device.getResource());
            this.addEndElement();
        }
    }

    private void addDeviceAttributes(Device device) throws XMLStreamException {
        this.addDeviceProfile(device);
        this.addColorAttributeElement(device);
        this.addAttributes((EList<Attribute>)device.getAttributes());
    }

    private void addDeviceProfile(Device device) throws XMLStreamException {
        String profileName = device.getProfile();
        if (profileName != null && !"".equals(profileName)) {
            this.addAttributeElement("Profile", IecTypes.ElementaryTypes.STRING, profileName, null);
        }
    }

    private void addResources(EList<Resource> resourceList) throws XMLStreamException {
        for (Resource resource : resourceList) {
            if (resource.isDeviceTypeResource()) continue;
            this.addStartElement("Resource");
            this.addNameTypeCommentAttribute(resource, resource.getType());
            this.addXYAttributes(0.0, 0.0);
            this.addParamsConfig((EList<VarDeclaration>)resource.getVarDeclarations());
            ResourceInSystemFBNetworkExporter resNetworkExporter = new ResourceInSystemFBNetworkExporter(this);
            resNetworkExporter.createFBNetworkElement(resource.getFBNetwork());
            this.addAttributes((EList<Attribute>)resource.getAttributes());
            this.addEndElement();
        }
    }

    @Override
    protected String getRootTag() {
        return "System";
    }

    private static final class ResourceInSystemFBNetworkExporter
    extends FBNetworkExporter {
        private ResourceInSystemFBNetworkExporter(CommonElementExporter parent) {
            super(parent);
        }

        @Override
        protected void addFBNetworkElement(FBNetworkElement fbnElement) throws XMLStreamException {
            if (!fbnElement.isMapped()) {
                super.addFBNetworkElement(fbnElement);
            }
        }

        @Override
        protected void addConnections(List<? extends Connection> connections, String connectionElementName, FBNetwork fbNetwork) throws XMLStreamException {
            List<Connection> resourceConns = connections.stream().filter(ResourceInSystemFBNetworkExporter::isResCon).toList();
            super.addConnections(resourceConns, connectionElementName, fbNetwork);
        }

        @Override
        protected String getFBNElementName(FBNetworkElement fbnElement) {
            if (fbnElement.isMapped()) {
                return fbnElement.getOpposite().getQualifiedName();
            }
            return super.getFBNElementName(fbnElement);
        }

        private static boolean isResCon(Connection con) {
            FBNetworkElement sourceElement = con.getSourceElement();
            if (sourceElement == null) {
                return false;
            }
            return !sourceElement.isMapped() || !con.getDestinationElement().isMapped();
        }
    }
}

