/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.fb;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.fordiac.ide.debug.EvaluatorProcess;
import org.eclipse.fordiac.ide.debug.fb.FBDebugClockMode;
import org.eclipse.fordiac.ide.model.eval.AbstractEvaluator;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorCountingEventQueue;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorExternalEventQueue;
import org.eclipse.fordiac.ide.model.libraryElement.Event;

public class FBLaunchEventQueue
implements FBEvaluatorCountingEventQueue,
FBEvaluatorExternalEventQueue {
    private final AtomicBoolean repeat;
    private final AtomicBoolean blocking;
    private final AtomicReference<FBDebugClockMode> clockMode = new AtomicReference<FBDebugClockMode>(FBDebugClockMode.SYSTEM);
    private final AtomicReference<Duration> incrementDebugTime = new AtomicReference<Duration>(Duration.ZERO);
    private final AtomicReference<Duration> currentDebugTime = new AtomicReference<Duration>(Duration.ZERO);
    private final AtomicReference<Clock> currentClock = new AtomicReference<AbstractEvaluator.MonotonicClock>(AbstractEvaluator.MonotonicClock.UTC);
    private EvaluatorProcess evaluator;
    private boolean initialized = false;
    private final BlockingQueue<Event> queue = new LinkedBlockingQueue<Event>();
    private final ConcurrentMap<Event, AtomicInteger> eventCounts = new ConcurrentHashMap<Event, AtomicInteger>();

    public FBLaunchEventQueue(Event event, boolean repeat, boolean blocking) {
        this.repeat = new AtomicBoolean(repeat);
        this.blocking = new AtomicBoolean(blocking);
        if (event != null) {
            this.queue.add(event);
        }
    }

    public Event receiveInputEvent() throws InterruptedException {
        Event result;
        Event event = result = this.blocking.get() ? this.queue.take() : (Event)this.queue.poll();
        if (result != null) {
            this.incrementEventCount(result);
            this.setDebugTime();
            if (this.repeat.get()) {
                this.queue.add(result);
            }
        }
        return result;
    }

    public boolean sendOutputEvent(Event event) {
        this.incrementEventCount(event);
        return true;
    }

    public boolean triggerInputEvent(Event event) {
        return this.queue.offer(event);
    }

    protected void incrementEventCount(Event ev) {
        AtomicInteger count = this.getCount(ev);
        count.incrementAndGet();
    }

    public AtomicInteger getCount(Event ev) {
        return this.eventCounts.computeIfAbsent(ev, e -> new AtomicInteger());
    }

    public boolean isRepeat() {
        return this.repeat.get();
    }

    public void setRepeat(boolean repeat) {
        this.repeat.set(repeat);
    }

    public boolean isBlocking() {
        return this.blocking.get();
    }

    public void setBlocking(boolean blocking) {
        this.blocking.set(blocking);
    }

    public boolean isDebugTimeIncremental() {
        return this.clockMode.get() == FBDebugClockMode.INCREMENT;
    }

    public boolean isDebugTimeManual() {
        return this.clockMode.get() == FBDebugClockMode.MANUAL;
    }

    public boolean isDebugTimeSystem() {
        return this.clockMode.get() == FBDebugClockMode.SYSTEM;
    }

    public void setDebugTimeValue(FBDebugClockMode clockMode, Duration sleepTime) {
        this.clockMode.set(clockMode);
        if (this.isDebugTimeIncremental()) {
            this.incrementDebugTime.set(sleepTime);
        } else if (this.isDebugTimeManual()) {
            this.currentDebugTime.set(sleepTime);
        }
    }

    public Duration getDebugTimeValue() {
        return this.incrementDebugTime.get();
    }

    public void setEvaluatorProcess(EvaluatorProcess evaluatorProcess) {
        this.evaluator = evaluatorProcess;
        this.updateEvaluatorClock();
    }

    void setDebugTime() {
        Duration debugTime = this.currentDebugTime.get();
        if (this.isDebugTimeIncremental() && this.initialized) {
            debugTime = debugTime.plus(this.incrementDebugTime.get());
        }
        this.currentDebugTime.set(debugTime);
        Instant instant = Instant.ofEpochSecond(debugTime.getSeconds(), debugTime.getNano());
        this.currentClock.set((Clock)(this.isDebugTimeSystem() ? AbstractEvaluator.MonotonicClock.UTC : Clock.fixed(instant, ZoneId.systemDefault())));
        this.updateEvaluatorClock();
        this.initialized = true;
    }

    private void updateEvaluatorClock() {
        if (this.evaluator != null) {
            this.evaluator.getExecutor().setClock(this.currentClock.get());
        }
    }
}

