/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;

public interface LaunchConfigurationAttributes {
    public static final String RESOURCE = "org.eclipse.fordiac.ide.debug.resource";
    public static final String ARGUMENTS = "org.eclipse.fordiac.ide.debug.arguments";
    public static final String STOP_ON_FIRST_LINE = "org.eclipse.fordiac.ide.debug.stopOnFirstLine";

    public static IResource getResource(ILaunchConfiguration configuration) throws CoreException {
        String resourceAttribute = configuration.getAttribute(RESOURCE, "");
        if (resourceAttribute != null && !resourceAttribute.isEmpty()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resourceAttribute));
        }
        return null;
    }

    public static List<Variable<?>> getArguments(ILaunchConfiguration configuration, List<Variable<?>> defaultArguments) throws CoreException {
        Map argumentsAttribute = configuration.getAttribute(ARGUMENTS, Collections.emptyMap());
        if (argumentsAttribute != null && defaultArguments != null) {
            defaultArguments.forEach(arg -> {
                String argumentValue = (String)argumentsAttribute.get(arg.getName());
                try {
                    if (argumentValue != null) {
                        arg.setValue(argumentValue);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        return defaultArguments;
    }

    public static boolean isStopOnFirstLine(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(STOP_ON_FIRST_LINE, true);
    }
}

