/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.fordiac.ide.application.actions.CopyEditPartsAction;
import org.eclipse.fordiac.ide.application.actions.CutEditPartsAction;
import org.eclipse.fordiac.ide.application.actions.DeleteFBNetworkAction;
import org.eclipse.fordiac.ide.application.actions.FBNetworkSelectAllAction;
import org.eclipse.fordiac.ide.application.actions.PasteEditPartsAction;
import org.eclipse.fordiac.ide.application.actions.UpdateFBTypeAction;
import org.eclipse.fordiac.ide.application.dnd.CustomDragSourceListener;
import org.eclipse.fordiac.ide.application.dnd.CustomDragTargetListener;
import org.eclipse.fordiac.ide.application.editors.FBNetworkContextMenuProvider;
import org.eclipse.fordiac.ide.application.editors.FBTypePaletteViewerProvider;
import org.eclipse.fordiac.ide.application.editparts.ElementEditPartFactory;
import org.eclipse.fordiac.ide.application.editparts.FBNetworkRootEditPart;
import org.eclipse.fordiac.ide.application.figures.FBNetworkConnectionLayerClippingStrategy;
import org.eclipse.fordiac.ide.application.tools.FBNetworkPanningSelectionTool;
import org.eclipse.fordiac.ide.application.utilities.FbTypeTemplateTransferDropTargetListener;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.preferences.PaletteFlyoutPreferences;
import org.eclipse.fordiac.ide.gef.tools.AdvancedPanningSelectionTool;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.ui.actions.Open4DIACElementAction;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class FBNetworkEditor
extends DiagramEditorWithFlyoutPalette {
    private static final PaletteFlyoutPreferences PALETTE_PREFERENCES = new PaletteFlyoutPreferences("FBNetworkPalette.Location", "FBNetworkPalette.Size", "FBNetworkPalette.State");
    private FBNetwork model;

    protected void setModel(FBNetwork model) {
        this.model = model;
    }

    public CommandStack getFBEditorCommandStack() {
        return this.getCommandStack();
    }

    protected ScalableFreeformRootEditPart createRootEditPart() {
        return new FBNetworkRootEditPart(this.getModel(), this.getSite(), this.getActionRegistry());
    }

    public FBNetwork getModel() {
        return this.model;
    }

    protected String getContextId() {
        return "org.eclipse.fordiac.ide.fbnetwork";
    }

    protected EditPartFactory getEditPartFactory() {
        return new ElementEditPartFactory((GraphicalEditor)this);
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new FBNetworkContextMenuProvider(this, this.getActionRegistry(), zoomManager, this.getTypeLibrary());
    }

    protected TypeLibrary getTypeLibrary() {
        return this.getSystem().getTypeLibrary();
    }

    protected org.eclipse.jface.util.TransferDropTargetListener createTransferDropTargetListener() {
        return new FbTypeTemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer(), this.getSystem().getTypeLibrary().getProject());
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalControl().addListener(26, this::handleActivationChanged);
        this.getGraphicalControl().addListener(27, this::handleActivationChanged);
        ActionRegistry registry = this.getActionRegistry();
        Open4DIACElementAction openAction = (Open4DIACElementAction)registry.getAction((Object)"org.eclipse.fordiac.ide.model.ui.OpenAction");
        this.getGraphicalViewer().addSelectionChangedListener((ISelectionChangedListener)openAction);
        this.getGraphicalViewer().addDragSourceListener((TransferDragSourceListener)new CustomDragSourceListener((EditPartViewer)this.getGraphicalViewer()));
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new CustomDragTargetListener((EditPartViewer)this.getGraphicalViewer()));
        ScalableFreeformRootEditPart rootEP = (ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart();
        IFigure connectionLayer = rootEP.getLayer((Object)"Connection Layer");
        connectionLayer.setClippingStrategy((IClippingStrategy)new FBNetworkConnectionLayerClippingStrategy((GraphicalViewer)this.getGraphicalViewer()));
        this.getGraphicalViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension((int)CoordinateConverter.INSTANCE.getLineHeight(), (int)CoordinateConverter.INSTANCE.getLineHeight()));
    }

    public AutomationSystem getSystem() {
        return this.getModel().getAutomationSystem();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        Object action = new CopyEditPartsAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CutEditPartsAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new PasteEditPartsAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new UpdateFBTypeAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        Open4DIACElementAction openAction = new Open4DIACElementAction((IWorkbenchPart)this);
        registry.registerAction((IAction)openAction);
        super.createActions();
        action = registry.getAction((Object)ActionFactory.SELECT_ALL.getId());
        registry.removeAction((IAction)action);
        this.getSelectionActions().remove(action.getId());
        action = new FBNetworkSelectAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = registry.getAction((Object)ActionFactory.DELETE.getId());
        registry.removeAction((IAction)action);
        this.getSelectionActions().remove(action.getId());
        action = new DeleteFBNetworkAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    public void dispose() {
        super.dispose();
        this.getEditDomain().setPaletteViewer(null);
    }

    protected PaletteRoot getPaletteRoot() {
        return null;
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new FBTypePaletteViewerProvider(this.getSystem().getTypeLibrary().getProject(), (EditDomain)this.getEditDomain(), this.getPaletteNavigatorID());
    }

    protected String getPaletteNavigatorID() {
        return "org.eclipse.fordiac.ide.fbpaletteviewer";
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return PALETTE_PREFERENCES;
    }

    public void selectElement(Object element) {
        EditPart editPart = this.getGraphicalViewer().getEditPartForModel(element);
        if (editPart != null) {
            this.getGraphicalViewer().flush();
            this.getGraphicalViewer().selectAndRevealEditPart(editPart);
        }
    }

    public void doSaveAs() {
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == FBNetwork.class) {
            return adapter.cast(this.getModel());
        }
        if (adapter == FBNetworkEditor.class) {
            return adapter.cast((Object)this);
        }
        return (T)super.getAdapter(adapter);
    }

    private void handleActivationChanged(Event event) {
        boolean activated = event.type == 26;
        this.setAction(ActionFactory.COPY.getId(), activated);
        this.setAction(ActionFactory.CUT.getId(), activated);
        this.setAction(ActionFactory.PASTE.getId(), activated);
        this.getEditorSite().getActionBars().updateActionBars();
    }

    private void setAction(String actionId, boolean activated) {
        IAction action = this.getActionRegistry().getAction((Object)actionId);
        if (activated && this.getEditorSite().getActionBars().getGlobalActionHandler(actionId) != action) {
            this.getEditorSite().getActionBars().setGlobalActionHandler(actionId, action);
        } else if (!activated && this.getEditorSite().getActionBars().getGlobalActionHandler(actionId) == action) {
            this.getEditorSite().getActionBars().setGlobalActionHandler(actionId, null);
        }
    }

    protected AdvancedPanningSelectionTool createDefaultTool() {
        return new FBNetworkPanningSelectionTool();
    }
}

