---
stage: Govern
group: Threat Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Vulnerabilities in a pipeline

DETAILS:
**Tier:** Ultimate
**Offering:** GitLab.com, Self-managed, GitLab Dedicated

All enabled security analyzers run in the pipeline and output their results as artifacts. These
artifacts are processed, including [deduplication](#deduplication-process), and the results are
listed on the pipeline **Security** tab. By identifying vulnerability
[findings](../terminology/index.md#finding) in a pipeline, you can address the risks
proactively.

The following criteria apply to the pipeline security tab:

- The results of only successful security scan jobs are shown. For example, if a pipeline contains
  SAST and DAST jobs, but the DAST job fails, only the SAST results are shown.
- If the pipeline has a [blocking manual job](../../../ci/jobs/job_control.md#types-of-manual-jobs),
  the pipeline waits for the manual job, and the vulnerabilities cannot be displayed if the blocking
  manual job did not run.
- Findings have an expiry period. Expired findings are not shown on the pipeline security tab. For
  details, see [Retention period for findings](#retention-period-for-findings).

## View vulnerabilities in a pipeline

To view vulnerabilities in a pipeline:

1. On the left sidebar, select **Search or go to** and find your project.
1. Select **Build > Pipelines**.
1. Select the pipeline.
1. Select the **Security** tab.

## Scan details

The **Scan details** section shows a summary of vulnerability findings in the pipeline and the
source reports.

GitLab displays one row of information for each [scan type](../terminology/index.md#scan-type-report-type)
artifact present in the pipeline.

## Downloading security scan results

Depending on the type of security scanner, you can download:

- A JSON artifact that contains the security scanner [report](../../../development/integrations/secure.md#report).
- A CSV file that contains URLs and endpoints scanned by the security scanner.

To download a security scan output:

1. On the left sidebar, select **Search or go to** and find your project.
1. Select **Build > Pipelines**.
1. Select the pipeline.
1. Select the **Security** tab.
1. In **Scan details**, select **Download results**:
   - To download a JSON file, select the JSON artifact.
   - To download a CSV file, select **Download scanned resources**.

## Scan results

Findings present in the source branch are listed in descending order of severity. You can filter the
list of findings by severity and tool. You can also download the results of the security scans, for
analysis outside GitLab.

Findings that are dismissed are hidden by default. To see these findings, turn off the
**Hide dismissed** toggle.

For each finding you can:

- Get more information about the finding.
- Create an issue for the finding.
- Dismiss the finding.

When you merge the merge request's branch into the target branch, all reported findings from the next pipeline to run on the default branch are shown in the [vulnerability report](index.md). Scan results in pipelines executed on the
default branch are incorporated after the pipeline finishes, according to the following table:

| Existing vulnerability status | Dismissed from pipeline security tab? | New vulnerability status |
|:------------------------------|:-----------------------|:-------------------------|
| any                           | Yes                    | Dismissed                |
| Dismissed                     | any                    | Dismissed                |
| Confirmed                     | No                     | Confirmed                |
| Needs triage (Detected)       | No                     | Needs triage (Detected)  |
| Resolved                      | No                     | Needs triage (Detected)  |
| N/A (New vulnerability)       | No                     | Needs triage (Detected)  |

## Security reports from pipelines in a blocked or incomplete state

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/439691) in GitLab 16.10 [with a flag](../../../administration/feature_flags.md) named `include_manual_to_pipeline_completion`. Enabled by default.

| Pipeline status      | Pipeline completion | What vulnerabilities are displayed? <sup>1</sup> |
|:---------------------|:--------------------|:-------------------------------------------------|
| Success              | Complete            | ✅ Displays all vulnerability findings for the pipeline. |
| Failed               | Complete            | ✅ Displays the vulnerability findings for any jobs that did not fail, ❌ does not display vulnerability findings for any job that fails. |
| Blocked <sup>2</sup> | Complete            | ✅ Displays all vulnerability findings even when the pipeline is blocked by the manual job. |

**Footnotes:**

1. These results display in the merge request security widget, on the pipeline security tab, and on
   the vulnerability report and dependency list if the MR is merged into the default branch.
1. Before 16.10 GitLab supported ingesting scan results only after all pipeline jobs were complete.
   As of 16.10, the platform extends support to ingest scan results even when the pipeline is
   [blocked by manual jobs](../../../ci/jobs/job_control.md#types-of-manual-jobs).

## Retention period for findings

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/351524) in GitLab 15.5.

Findings are no longer available:

- When the related CI job artifact expires.
- 90 days after the pipeline is created, even if the related CI job artifacts are locked.

To view findings, either:

- Run a new pipeline.
- Download the related CI job artifacts if they are available.

NOTE:
This does not apply for the vulnerabilities existing on the default branch.

## Change status of findings

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/331408) in GitLab 16.7 [with a flag](../../../administration/feature_flags.md) named `pipeline_security_dashboard_graphql`. Disabled by default.

FLAG:
On self-managed GitLab, by default this feature is not available. To make it available, an administrator can [enable the feature flag](../../../administration/feature_flags.md) named `pipeline_security_dashboard_graphql`.
On GitLab.com and GitLab Dedicated, this feature is not available.

To change the status of findings to **Dismiss** or **Needs triage**:

1. On the left sidebar, select **Search or go to** and find your project.
1. Select **Build > Pipelines**.
1. Select a pipeline and select the **Security** tab.
1. To select:
   - One or more findings, select the checkbox beside each finding.
   - All findings on the page, select the checkbox in the table header.
1. In the **Set status** dropdown list, select the desired status.
1. If the **Dismiss** status is chosen, select the desired reason in the **Set dismissal reason** dropdown list.
1. In the **Add a comment** input, you can provide a comment. For the **Dismiss** status, a comment is required.
1. Select **Change status**.

The status of the selected findings is updated and the content of the security tab is refreshed.

## Deduplication process

When a pipeline contains jobs that produce multiple security reports of the same type, it is possible that the same
vulnerability finding is present in multiple reports. This duplication is common when different scanners are used to
increase coverage, but can also exist in a single report. The deduplication process allows you to maximize the vulnerability scanning coverage while reducing
the number of findings you need to manage.

A finding is considered a duplicate of another finding when their [scan type](../terminology/index.md#scan-type-report-type),
[location](../terminology/index.md#location-fingerprint), and one or more of its
[identifiers](../../../development/integrations/secure.md#identifiers) are the same.

The scan type must match because each can have its own definition for the location of a vulnerability. For example,
static analyzers are able to locate a file path and line number, whereas a container scanning analyzer uses the image
name instead.

When comparing identifiers, GitLab does not compare `CWE` and `WASC` during deduplication because they are
"type identifiers" and are used to classify groups of vulnerabilities. Including these identifiers would result in
many findings being incorrectly considered duplicates. Two findings are considered unique if none of their
identifiers match.

In a set of duplicated findings, the first occurrence of a finding is kept and the remaining are skipped. Security
reports are processed in alphabetical file path order, and findings are processed sequentially in the order they
appear in a report.

### Deduplication examples

- Example 1: matching identifiers and location, mismatching scan type.
  - Finding
    - Scan type: `sast`
    - Location fingerprint: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - Identifiers: CVE-2022-25510
  - Other Finding
    - Scan type: `secret_detection`
    - Location fingerprint: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - Identifiers: CVE-2022-25510
  - Deduplication result: not duplicates because the scan type is different.
- Example 2: matching location and scan type, mismatching type identifiers.
  - Finding
    - Scan type: `sast`
    - Location fingerprint: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - Identifiers: CWE-259
  - Other Finding
    - Scan type: `sast`
    - Location fingerprint: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - Identifiers: CWE-798
  - Deduplication result: duplicates because `CWE` identifiers are ignored.
- Example 3: matching scan type, location and an identifier.
  - Finding
    - Scan type: `container_scanning`
    - Location fingerprint: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - Identifiers: CVE-2019-12345, CVE-2022-25510, CWE-259
  - Other Finding
    - Scan type: `container_scanning`
    - Location fingerprint: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - Identifiers: CVE-2022-25510, CWE-798
  - Deduplication result: duplicates because all criteria match, and type identifiers are ignored.
    Only one identifier needs to match, in this case CVE-2022-25510.

You can find definitions for each scan type [`gitlab/lib/gitlab/ci/reports/security/locations`](https://gitlab.com/gitlab-org/gitlab/-/tree/master/lib/gitlab/ci/reports/security/locations)
and [`gitlab/ee/lib/gitlab/ci/reports/security/locations`](https://gitlab.com/gitlab-org/gitlab/-/tree/master/ee/lib/gitlab/ci/reports/security/locations).

For instance, for `container_scanning` type the location is defined by Docker image name without tag. However if the image tag contains at least one letter and/or is longer than 8 characters, it isn't considered a duplicate. So, locations `registry.gitlab.com/group-name/project-name/image1:12345019:libcrypto3` and `registry.gitlab.com/group-name/project-name/image1:libcrypto3` are treated as identical while `registry.gitlab.com/group-name/project-name/image1:v19202021:libcrypto3` and `registry.gitlab.com/group-name/project-name/image1:libcrypto3` are considered different.

## Troubleshooting

### Dismissed vulnerabilities are sometimes still visible

In some instances of GitLab 16.8 and earlier [dismissed vulnerabilities are sometimes still visible](https://gitlab.com/gitlab-org/gitlab/-/issues/367298).
This can be resolved by upgrading to GitLab 16.9 and later.

### Report parsing and scan ingestion errors

NOTE:
These steps are to be used by GitLab Support to reproduce such errors.

Some security scans may result in errors in the **Security** tab of the pipeline related to report parsing or scan ingestion. If it is not possible to get a copy of the project from the user, you can reproduce the error using the report generated from the scan.

To recreate the error:

1. Obtain a copy of the report from the user. In this example, `gl-sast-report.json`.
1. Create a project.
1. Commit the report to the repository.
1. Add your `.gitlab-ci.yml` file and have the report as an artifact in a job.

   For example, to reproduce an error caused by a SAST job:

   ```yaml
   sample-job:
     script:
       - echo "Testing report"
     artifacts:
       reports:
         sast: gl-sast-report.json
   ```

1. After the pipeline completes, check the content of the pipeline's **Security** tab for errors.

You can replace `sast: gl-sast-report.json` with the respective [`artifacts:reports`](../../../ci/yaml/index.md#artifactsreports) type and the correct JSON report filename depending on the scan that generated the report.
