---
stage: Solutions Architecture
group: Solutions Architecture
info: This page is owned by the Solutions Architecture team.
description: GitLab partnership certifications and designations from AWS.
---

# GitLab partnership certifications and designations from AWS

The certifications and designations outlined here can be validated on [GitLabs partner page at AWS](https://partners.amazonaws.com/partners/001E0000018YWFfIAO/GitLab,%20Inc.).

All AWS partner qualifications require submission and validation of extensive checklists and submission of backing evidence that AWS utilizes to determine whether to grant the qualification.

## DevOps Software / ISV Competency

This competency validates that GitLab delivers DevOps solutions that work with and on AWS. [AWS Program Information](https://aws.amazon.com/devops/partner-solutions/)

## DevSecOps Specialty Category

The DevSecOps qualification is a category of the DevOps Software Competency that demonstrates that GitLab is a substantial solution in helping organizations meet their DevSecOps maturity goals. GitLab was reviewed for meeting these additional qualifications before being granted this designation. [AWS Program Information](https://aws.amazon.com/blogs/apn/aws-devops-competency-expands-to-include-devsecops-category/) [GitLab Announcement](https://about.gitlab.com/blog/2023/09/25/aws-devsecops-competency-partner/)

## Public Sector Partner

This designation indicates that GitLab has been deemed qualified to work with AWS Public Sector customers. GitLab has a dedicated organization to address public sector specific needs. [AWS Program Information](https://aws.amazon.com/partners/programs/public-sector/)

## AWS Graviton

GitLab Instances and Runners have been tested and work on AWS Graviton. For Amazon Linux we maintain YUM packages for ARM architecture. [AWS Program Information](https://aws.amazon.com/ec2/graviton/partners/)

## Amazon Linux Ready

GitLab Instances and Runner have been validated on Amazon Linux 2 and 2023 - this includes YUM packages and package repositories for both and over 2300 CI tests for both before packaging. [AWS Program Information](https://aws.amazon.com/amazon-linux/partners/)

## AWS Marketplace Seller

GitLab is a marketplace seller and you can purchase and deploy it through AWS marketplace [AWS Program Information](https://aws.amazon.com/marketplace/partners/management-tour)

![AWS Partner Designations Logo](img/all-aws-partner-designations.png){: .right}
