---
stage: none
group: Tutorials
info: For assistance with this tutorial, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
---

# Tutorial: Use the left sidebar to navigate GitLab

DETAILS:
**Tier:** Free, Premium, Ultimate
**Offering:** GitLab.com, Self-managed, GitLab Dedicated

> - [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/9044) in GitLab 16.0.

Follow this tutorial to learn how to use the new left sidebar to navigate the UI.

## Enable the new left sidebar

From 16.0 through 16.5, you can turn the new sidebar on and off:

1. On the left sidebar, select your avatar.
1. Change the **New navigation** toggle.

Return to your avatar to change the setting.

## Layout of the left sidebar

At the top of the left sidebar are several shortcuts. Use these shortcuts to
show and hide the left sidebar, create new items, search, and view your profile. You can also view your list of issues,
merge requests, and to-do items.

![Top of sidebar](img/sidebar_top_v16_4.png)

NOTE:
If you have hidden the left sidebar, you can display it temporarily by hovering your cursor over the left edge of the GitLab window.

The next area of the left sidebar changes based on the information you're viewing. For example,
you might be viewing a project, exploring projects or groups, or viewing your profile.
To switch to other areas of the left sidebar, use **Search or go to**.

![Context switching](img/sidebar_middle_v16_4.png)

The rest of the left sidebar is populated based on the option you choose. For example,
if you're in a project, the sidebar is project-specific.

## Find your project

Now let's go over a few common tasks you'll use the left sidebar for.

To start, we will find the project we want to work on.

1. To explore all available projects, on the left sidebar, select **Search or go to**.
1. Choose from the list of frequently visited projects, or
   type a colon `:` followed by the project name:

   ![Search projects](img/search_projects_v16_4.png)

The left sidebar now shows project-specific options.

![Project-specific options](img/project_selected_v16_4.png)

## Pin frequently used items

You can pin menu items if you tend to use them frequently.

1. Expand the sections until you are viewing the item you want to pin.
1. Hover over and select the pin (**{thumbtack}**).

   ![pin](img/pin_v16_0.png)

The item is displayed in the **Pinned** section:

![pinned item](img/pinned_v16_0.png)

NOTE:
The items you pin while you're viewing a project are different than the items you pin while viewing a group.

## Use a more focused view

On the left sidebar, you can also choose a more focused view into the areas you have access to.
Select **Search or go to** and then select **Your work**:

![Your work](img/your_work_v16_4.png)

Then, on the left sidebar, **Your work** is displayed.

## Go to the Admin Area

The Admin Area is also available on the left sidebar at the bottom:

![Admin Area](img/admin_area_v16_7.png)
