---
stage: none
group: Tutorials
description: GitOps, Kubernetes deployments.
info: For assistance with this tutorials page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
---

# Tutorials: Manage your infrastructure

Use GitLab configuration features to reduce the effort needed to
configure the infrastructure for your application.

| Topic | Description | Good for beginners |
|-------|-------------|--------------------|
| [Use GitOps with GitLab](https://about.gitlab.com/blog/2022/04/07/the-ultimate-guide-to-gitops-with-gitlab/)  |  Learn how to provision and manage a base infrastructure, connect to a Kubernetes cluster, deploy third-party applications, and carry out other infrastructure automation tasks. | |
| [Set up Flux for GitOps](../user/clusters/agent/gitops/flux_tutorial.md) | Learn how to set up Flux for GitOps in a sample project. | |
| [Deploy a Git repository using Flux](../user/clusters/agent/gitops/example_repository_structure.md) | Learn how to organize a GitLab project for GitOps. | |
| [Deploy an OCI artifact using Flux](../user/clusters/agent/gitops/flux_oci_tutorial.md) | Learn how to package and deploy your Kubernetes manifests as an OCI artifact. | |
