/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.util.Cloner;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.metadata.MetadataVisitor;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.iso.identification.DefaultRepresentativeFraction;
import org.apache.sis.util.collection.CodeListSet;

final class StateChanger
extends MetadataVisitor<Boolean> {
    private static final ThreadLocal<StateChanger> VISITORS = ThreadLocal.withInitial(StateChanger::new);
    private ModifiableMetadata.State target;
    private Cloner cloner;

    private StateChanger() {
    }

    static void applyTo(ModifiableMetadata.State state, ModifiableMetadata modifiableMetadata) {
        StateChanger stateChanger = VISITORS.get();
        ModifiableMetadata.State state2 = stateChanger.target;
        stateChanger.target = state;
        stateChanger.walk(modifiableMetadata.getStandard(), null, modifiableMetadata, true);
        stateChanger.target = state2;
    }

    @Override
    final ThreadLocal<StateChanger> creator() {
        return VISITORS;
    }

    @Override
    MetadataVisitor.Filter preVisit(PropertyAccessor propertyAccessor) {
        return MetadataVisitor.Filter.WRITABLE;
    }

    @Override
    final Object visit(Class<?> clazz, Object object) throws CloneNotSupportedException {
        return this.applyTo(object);
    }

    private void applyToAll(Object[] objectArray) throws CloneNotSupportedException {
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.applyTo(objectArray[i]);
        }
    }

    private Object applyTo(Object object) throws CloneNotSupportedException {
        if (object instanceof ModifiableMetadata) {
            ((ModifiableMetadata)object).transitionTo(this.target);
            return object;
        }
        if (object instanceof DefaultRepresentativeFraction && this.target.isUnmodifiable()) {
            ((DefaultRepresentativeFraction)object).freeze();
            return object;
        }
        if (object instanceof Collection) {
            Collection<Object> collection = (UnmodifiableArrayList<Object>)object;
            boolean bl = collection instanceof Set;
            Object[] objectArray = collection.toArray();
            switch (objectArray.length) {
                case 0: {
                    collection = bl ? Collections.EMPTY_SET : Collections.EMPTY_LIST;
                    break;
                }
                case 1: {
                    Object object2 = this.applyTo(objectArray[0]);
                    collection = bl ? Collections.singleton(object2) : Collections.singletonList(object2);
                    break;
                }
                default: {
                    if (bl) {
                        if (collection instanceof EnumSet) {
                            collection = Collections.unmodifiableSet(((EnumSet)collection).clone());
                            break;
                        }
                        if (collection instanceof CodeListSet) {
                            collection = Collections.unmodifiableSet(((CodeListSet)collection).clone());
                            break;
                        }
                        this.applyToAll(objectArray);
                        collection = CollectionsExt.immutableSet(false, objectArray);
                        break;
                    }
                    this.applyToAll(objectArray);
                    collection = UnmodifiableArrayList.wrap(objectArray);
                }
            }
            return collection;
        }
        if (object instanceof Map) {
            LinkedHashMap linkedHashMap = new LinkedHashMap((Map)object);
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                entry.setValue(this.applyTo(entry.getValue()));
            }
            return CollectionsExt.unmodifiableOrCopy(linkedHashMap);
        }
        if (object instanceof Cloneable) {
            if (this.cloner == null) {
                this.cloner = new Cloner(false);
            }
            return this.cloner.clone(object);
        }
        return object;
    }
}

