/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;

public class DelegatingCollector
extends SimpleCollector {
    public static int setLastDelegateCount;
    protected Collector delegate;
    protected LeafCollector leafDelegate;
    protected Scorable scorer;
    protected LeafReaderContext context;
    protected int docBase;

    public Collector getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Collector delegate) {
        this.delegate = delegate;
    }

    public void setLastDelegate(Collector delegate) {
        DelegatingCollector ptr = this;
        while (ptr.getDelegate() instanceof DelegatingCollector) {
            ptr = (DelegatingCollector)ptr.getDelegate();
        }
        ptr.setDelegate(delegate);
        ++setLastDelegateCount;
    }

    public void setScorer(Scorable scorer) throws IOException {
        this.scorer = scorer;
        if (this.leafDelegate != null) {
            this.leafDelegate.setScorer(scorer);
        }
    }

    public ScoreMode scoreMode() {
        return this.delegate.scoreMode();
    }

    public void collect(int doc) throws IOException {
        this.leafDelegate.collect(doc);
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.context = context;
        this.docBase = context.docBase;
        this.leafDelegate = this.delegate.getLeafCollector(context);
    }

    public final void finish() throws IOException {
        if (this.leafDelegate != null) {
            this.leafDelegate.finish();
        }
        super.finish();
    }

    public void complete() throws IOException {
        if (this.delegate instanceof DelegatingCollector) {
            ((DelegatingCollector)this.delegate).complete();
        }
    }
}

