/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey.container;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyBridgeResponseWriter
implements ContainerResponseWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final HttpServletResponse httpServletResponse;

    public JettyBridgeResponseWriter(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }

    public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse context) throws ContainerException {
        Response.StatusType statusInfo = context.getStatusInfo();
        this.httpServletResponse.setStatus(statusInfo.getStatusCode());
        if (contentLength != -1L && contentLength < Integer.MAX_VALUE) {
            this.httpServletResponse.setContentLength((int)contentLength);
        }
        for (Map.Entry e : context.getStringHeaders().entrySet()) {
            for (String value : (List)e.getValue()) {
                this.httpServletResponse.addHeader((String)e.getKey(), value);
            }
        }
        try {
            return this.httpServletResponse.getOutputStream();
        }
        catch (IOException ioe) {
            throw new ContainerException("Error during writing out the response headers.", (Throwable)ioe);
        }
    }

    public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
        return true;
    }

    public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
    }

    public void commit() {
    }

    public void failure(Throwable error) {
    }

    public boolean enableResponseBuffering() {
        return false;
    }
}

