/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.generator;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.bytecode.BytecodeFrameInfo;
import com.oracle.graal.python.nodes.bytecode.FrameInfo;
import com.oracle.graal.python.nodes.bytecode.GeneratorYieldResult;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.BytecodeDSLFrameInfo;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.bytecode.ContinuationResult;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

public class PGenerator
extends PythonBuiltinObject {
    private TruffleString name;
    private TruffleString qualname;
    private final FrameInfo frameInfo;
    private boolean finished;
    private boolean running;
    private final boolean isCoroutine;
    private final boolean isAsyncGen;
    private PCode code;
    protected final Object[] arguments;
    private final Object state;

    private BytecodeState getBytecodeState() {
        return (BytecodeState)this.state;
    }

    private BytecodeDSLState getBytecodeDSLState() {
        return (BytecodeDSLState)this.state;
    }

    public static PGenerator create(PythonLanguage lang, TruffleString name, TruffleString qualname, PBytecodeRootNode rootNode, RootCallTarget[] callTargets, Object[] arguments, PythonBuiltinClassType cls, boolean isIterableCoroutine) {
        rootNode.createGeneratorFrame(arguments);
        return new PGenerator(lang, name, qualname, arguments, cls, isIterableCoroutine, new BytecodeState(rootNode, callTargets));
    }

    public static PGenerator create(PythonLanguage lang, TruffleString name, TruffleString qualname, PBytecodeDSLRootNode rootNode, Object[] arguments, PythonBuiltinClassType cls, boolean isIterableCoroutine) {
        return new PGenerator(lang, name, qualname, arguments, cls, isIterableCoroutine, new BytecodeDSLState(rootNode));
    }

    public static PGenerator create(PythonLanguage lang, TruffleString name, TruffleString qualname, PBytecodeRootNode rootNode, RootCallTarget[] callTargets, Object[] arguments, PythonBuiltinClassType cls) {
        return PGenerator.create(lang, name, qualname, rootNode, callTargets, arguments, cls, false);
    }

    public static PGenerator create(PythonLanguage lang, TruffleString name, TruffleString qualname, PBytecodeDSLRootNode rootNode, Object[] arguments, PythonBuiltinClassType cls) {
        return PGenerator.create(lang, name, qualname, rootNode, arguments, cls, false);
    }

    protected PGenerator(PythonLanguage lang, TruffleString name, TruffleString qualname, Object[] arguments, PythonBuiltinClassType cls, boolean isIterableCoroutine, Object state) {
        super((Object)cls, cls.getInstanceShape(lang));
        this.name = name;
        this.qualname = qualname;
        this.arguments = arguments;
        this.finished = false;
        this.isCoroutine = isIterableCoroutine || cls == PythonBuiltinClassType.PCoroutine;
        boolean bl = this.isAsyncGen = cls == PythonBuiltinClassType.PAsyncGenerator;
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
            BytecodeDSLState bytecodeDSLState = (BytecodeDSLState)state;
            this.state = state;
            this.frameInfo = (BytecodeDSLFrameInfo)bytecodeDSLState.rootNode.getFrameDescriptor().getInfo();
        } else {
            BytecodeState bytecodeState = (BytecodeState)state;
            this.state = state;
            this.frameInfo = (BytecodeFrameInfo)bytecodeState.rootNode.getFrameDescriptor().getInfo();
        }
    }

    public RootNode getRootNode() {
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
            return this.getBytecodeDSLState().rootNode;
        }
        return this.getBytecodeState().rootNode;
    }

    public RootCallTarget getCurrentCallTarget() {
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
            BytecodeDSLState bytecodeDSLState = this.getBytecodeDSLState();
            if (bytecodeDSLState.yieldResult == null) {
                return bytecodeDSLState.rootNode.getCallTarget();
            }
            return bytecodeDSLState.yieldResult.getContinuationCallTarget();
        }
        return this.getBytecodeState().getCurrentCallTarget();
    }

    public Object getYieldFrom() {
        if (this.isRunning() || this.isFinished()) {
            return null;
        }
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
            throw new UnsupportedOperationException("not implemented");
        }
        return this.frameInfo.getYieldFrom((Frame)PArguments.getGeneratorFrame(this.arguments), this.getBci(), this.getBytecodeState().getCurrentRootNode().getResumeStackTop());
    }

    public boolean isStarted() {
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
            return this.getBytecodeDSLState().yieldResult != null && !this.isRunning();
        }
        return this.getBytecodeState().currentCallTarget != 0 && !this.isRunning();
    }

    public Object handleResult(PythonLanguage language, Object result) {
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
            return this.getBytecodeDSLState().handleResult((ContinuationResult)result);
        }
        return this.getBytecodeState().handleResult(language, (GeneratorYieldResult)result);
    }

    public final Object[] getArguments() {
        return this.arguments;
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public final void markAsFinished() {
        this.finished = true;
    }

    @Override
    public final String toString() {
        return "<generator object " + String.valueOf(this.name) + " at " + this.hashCode() + ">";
    }

    public final PCode getOrCreateCode(Node inliningTarget, InlinedConditionProfile hasCodeProfile) {
        if (hasCodeProfile.profile(inliningTarget, this.code == null)) {
            RootCallTarget callTarget = this.getRootNode().getCallTarget();
            this.code = PFactory.createCode(PythonLanguage.get(inliningTarget), callTarget);
        }
        return this.code;
    }

    public final boolean isRunning() {
        return this.running;
    }

    public final void setRunning(boolean running) {
        assert (!running || !this.running) : "Attempted to set an already running generator as running";
        this.running = running;
    }

    public final TruffleString getName() {
        return this.name;
    }

    public final void setName(TruffleString name) {
        this.name = name;
    }

    public final TruffleString getQualname() {
        return this.qualname;
    }

    public final void setQualname(TruffleString qualname) {
        this.qualname = qualname;
    }

    public final boolean isCoroutine() {
        return this.isCoroutine;
    }

    public final boolean isAsyncGen() {
        return this.isAsyncGen;
    }

    public int getBci() {
        assert (!PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER);
        if (!this.isStarted()) {
            return -1;
        }
        if (this.isFinished()) {
            return this.getBytecodeState().rootNode.getCodeUnit().code.length;
        }
        return this.getBytecodeState().getCurrentRootNode().getResumeBci();
    }

    public ContinuationResult getContinuation() {
        assert (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER);
        return this.getBytecodeDSLState().yieldResult;
    }

    protected static class BytecodeState {
        private final PBytecodeRootNode rootNode;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final RootCallTarget[] callTargets;
        private int currentCallTarget;

        public BytecodeState(PBytecodeRootNode rootNode, RootCallTarget[] callTargets) {
            this.rootNode = rootNode;
            this.callTargets = callTargets;
            this.currentCallTarget = 0;
        }

        public RootCallTarget getCurrentCallTarget() {
            return this.callTargets[this.currentCallTarget];
        }

        public PBytecodeGeneratorRootNode getCurrentRootNode() {
            return (PBytecodeGeneratorRootNode)this.getCurrentCallTarget().getRootNode();
        }

        public Object handleResult(PythonLanguage language, GeneratorYieldResult result) {
            this.currentCallTarget = result.resumeBci;
            if (this.callTargets[this.currentCallTarget] == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                PBytecodeGeneratorRootNode generatorRootNode = new PBytecodeGeneratorRootNode(language, this.rootNode, result.resumeBci, result.resumeStackTop);
                this.callTargets[this.currentCallTarget] = generatorRootNode.getCallTarget();
            }
            return result.yieldValue;
        }
    }

    private static class BytecodeDSLState {
        private final PBytecodeDSLRootNode rootNode;
        private ContinuationResult yieldResult;

        public BytecodeDSLState(PBytecodeDSLRootNode rootNode) {
            this.rootNode = rootNode;
            this.yieldResult = null;
        }

        public Object handleResult(ContinuationResult result) {
            this.yieldResult = result;
            return result.getResult();
        }
    }
}

