/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.proxy.db2;

import com.ibm.db2.cmx.ClientInfo;
import com.ibm.db2.cmx.PushDownError;
import com.ibm.db2.cmx.internal.metadata.ClientProfileUtil;
import com.ibm.db2.cmx.internal.metadata.DataBeanTransactionExecution;
import com.ibm.db2.cmx.internal.monitor.MonitorAgent;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcConnectionInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcDataSource;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcStatementInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.proxy.db2.ProxiedDB2StatementInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.wrappers.ExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2ConnectionExecutionHandler;
import com.ibm.db2.jcc.DB2Connection;
import com.ibm.db2.jcc.PDQConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;

public class ProxiedDB2ConnectionInvocationHandler
extends ProxiedJdbcConnectionInvocationHandler {
    DB2Connection target_;
    PDQConnection pdqConnection_;

    public ProxiedDB2ConnectionInvocationHandler(Connection connection, DB2ConnectionExecutionHandler dB2ConnectionExecutionHandler, MonitorAgent monitorAgent, String string, ProxiedJdbcDataSource proxiedJdbcDataSource, String string2, String string3) {
        super(connection, dB2ConnectionExecutionHandler, monitorAgent, string, proxiedJdbcDataSource, string2, string3);
        this.target_ = (DB2Connection)connection;
        this.pdqConnection_ = (PDQConnection)((Object)connection);
        ((PDQConnection)((Object)this.target_)).setIsMonitoring(this.isMonitoringEnabled_);
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logMonitorMessage(logger__, this, "<init>", "connection proxy created for: " + connection);
        }
    }

    @Override
    protected void updateMonitorSettingsOnDriver_() {
        block3: {
            try {
                if (!this.target_.isClosed()) {
                    this.pdqConnection_.setIsMonitoring(this.isMonitoringEnabled_);
                }
            }
            catch (SQLException sQLException) {
                if (!logger__.isLoggable(Level.FINER)) break block3;
                DataLogger.logTrappedMonitoringException(logger__, this.target_, "isClosed", sQLException, sQLException.getMessage());
            }
        }
    }

    @Override
    protected void reportTransaction_() {
        this.transactionBean_.completeTransaction(true);
        this.extractDB2SpecificConnectionPropertiesAndEUOW();
        if (this.monitorAgent_ != null) {
            this.monitorAgent_.reportPostTransaction(this.transactionBean_);
        }
        this.transactionBean_ = new DataBeanTransactionExecution();
        this.initializeTransactionBeanIdentifierFields_();
    }

    @Override
    protected void resetTransaction_() {
        if (this.transactionBean_ != null) {
            this.transactionBean_.transactionStart_ = 0L;
        }
    }

    private void extractDB2SpecificConnectionPropertiesAndEUOW() {
        try {
            this.transactionBean_.connectionCorrelator_ = this.target_.getDB2Correlator();
            this.transactionBean_.setDb2PackagePath(this.target_.getDB2CurrentPackagePath());
            if (Configuration.isJCCAtEI3ProtocolLevel__) {
                this.getVersion3EUOWAttibutesFromDriver();
            }
        }
        catch (SQLException sQLException) {
            DataLogger.logTrappedMonitoringException(logger__, this, "setCorrelatorOnTransactionBean", sQLException, "unable to get the DB2 Correlator");
        }
    }

    private void getVersion3EUOWAttibutesFromDriver() {
        Object[] objectArray = this.pdqConnection_.pullData(3002);
        if (objectArray != null) {
            this.transactionBean_.endUOWclientInfoFields_ = new String[]{(String)objectArray[3], (String)objectArray[4], (String)objectArray[5], (String)objectArray[6]};
            if (this.monitorAgent_ != null) {
                this.monitorAgent_.maskClientInfo(this.transactionBean_.endUOWclientInfoFields_);
            }
            this.transactionBean_.endUOWSettings_ = new String[]{null, null, null};
        }
    }

    @Override
    protected ProxiedJdbcStatementInvocationHandler createProxiedJdbcStatementInvocationHandler_(ExecutionHandler executionHandler, boolean bl2) {
        return new ProxiedDB2StatementInvocationHandler(this, executionHandler, this.isMonitoringEnabled_, bl2);
    }

    @Override
    protected void initializeTransactionBeanIdentifierFields_() {
        this.transactionBean_.authid_ = this.userName_;
        try {
            this.transactionBean_.clientInfoFields[0] = this.target_.getDB2ClientUser();
            this.transactionBean_.clientInfoFields[1] = this.target_.getDB2ClientWorkstation();
            this.transactionBean_.clientInfoFields[2] = this.target_.getDB2ClientApplicationInformation();
            this.transactionBean_.clientInfoFields[3] = this.target_.getDB2ClientAccountingInformation();
            this.monitorAgent_.maskClientInfo(this.transactionBean_.clientInfoFields);
        }
        catch (SQLException sQLException) {
            DataLogger.logTrappedMonitoringException(logger__, this, "reportTransaction", sQLException, "error retrieving client info fields from connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void applyDynamicPushDownProperties() {
        int n2 = 0;
        ArrayList arrayList = new ArrayList();
        ArrayList<PushDownError> arrayList2 = new ArrayList<PushDownError>();
        if (!this.isOCMEnabled_ || this.proxiedDataSource_.isOCMDyanmicControlDisabled()) {
            return;
        }
        ProxiedDB2ConnectionInvocationHandler proxiedDB2ConnectionInvocationHandler = this;
        synchronized (proxiedDB2ConnectionInvocationHandler) {
            block18: {
                if (!this.isInsideTransaction()) {
                    try {
                        block19: {
                            Object[] objectArray;
                            ClientInfo clientInfo = this.getClientInfo();
                            if (logger__.isLoggable(Level.FINEST)) {
                                logger__.log(Level.FINEST, "Client info at transaction start : " + clientInfo);
                            }
                            if ((objectArray = ClientProfileUtil.getTransactionProperties(this.proxiedDataSource_.getControlDataSource().getDataSourceProfile(), clientInfo, this.lastDatabaseVersion_, this.lastPhysicalLocationChangeVersion_, this.lastDataSrcProfileVersion_))[4] != null) {
                                this.lastDatabaseVersion_ = (Long)objectArray[4];
                            }
                            if (objectArray[5] != null) {
                                this.lastPhysicalLocationChangeVersion_ = (Long)objectArray[5];
                            }
                            if (objectArray[6] != null) {
                                this.lastDataSrcProfileVersion_ = (Long)objectArray[6];
                            }
                            this.proxiedDataSource_.addClientInfo(clientInfo);
                            String string = (String)objectArray[0];
                            if (objectArray[1] != null) {
                                n2 = (Integer)objectArray[1];
                            }
                            String string2 = (String)objectArray[2];
                            if (!Configuration.isJCCAtCMX5ProtocolLevel__) break block18;
                            if (logger__.isLoggable(Level.FINEST)) {
                                logger__.log(Level.FINEST, "Penalty box detail: " + string + ", " + n2 + ", " + string2);
                                logger__.log(Level.FINEST, "Remapped client Info: " + objectArray[3]);
                            }
                            try {
                                this.pdqConnection_.pushDown(string, n2, string2, (HashMap)objectArray[3], arrayList);
                            }
                            catch (SQLException sQLException) {
                                if (!logger__.isLoggable(Level.FINEST)) break block19;
                                DataLogger.logTrappedException(logger__, this, "applyDynamicPushDownProperties", sQLException, null);
                            }
                        }
                        if (arrayList.size() > 0) {
                            for (int i10 = 0; i10 < arrayList.size(); ++i10) {
                                Object[] objectArray = (Object[])arrayList.get(i10);
                                arrayList2.add(ClientProfileUtil.getPushDownError(objectArray, PushDownError.PushDownLevel.datasource));
                            }
                            this.proxiedDataSource_.addDynamicPushDownErrors(arrayList2);
                        }
                        this.lastDataSrcProfileVersion_ = this.proxiedDataSource_.getDataSourceProfileVersion();
                    }
                    finally {
                        this.markBeginTransaction();
                    }
                }
            }
        }
    }

    @Override
    protected ClientInfo getClientInfo() {
        ClientInfo clientInfo = null;
        try {
            clientInfo = Configuration.doesJccVersionSupportFeature(3) ? new ClientInfo(this.target_.getDB2ClientUser(), this.target_.getDB2ClientWorkstation(), this.target_.getDB2ClientApplicationInformation(), this.target_.getDB2ClientAccountingInformation(), this.target_.getDB2ClientCorrelationToken()) : new ClientInfo(this.target_.getDB2ClientUser(), this.target_.getDB2ClientWorkstation(), this.target_.getDB2ClientApplicationInformation(), this.target_.getDB2ClientAccountingInformation());
        }
        catch (SQLException sQLException) {
            DataLogger.logTrappedMonitoringException(logger__, this, "getClientInfo", sQLException, "Error retrieving client info fields from connection.");
        }
        return clientInfo;
    }

    @Override
    public Object[] pullData(int n2) {
        return null;
    }

    @Override
    protected boolean isInsideTransaction() {
        Object[] objectArray = null;
        objectArray = this.pdqConnection_.pullData(3004);
        if (objectArray != null) {
            return (Boolean)objectArray[0];
        }
        return this.isInUOW_;
    }
}

