/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import mediathek.daten.DatenDownload;
import mediathek.gui.dialog.MVPanelDownloadZiel;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.MVMessageDialog;

public class DialogContinueDownload
extends JDialog {
    private DownloadResult result;
    private boolean isNewName = false;
    private final MVPanelDownloadZiel mVPanelDownloadZiel;
    private final Timer countdownTimer;
    private final boolean direkterDownload;
    private final JFrame parent;
    private JButton jButtonAbbrechen;
    private JButton jButtonNeuerName;
    private JButton jButtonWeiter;
    private JLabel jLabel1;
    private JPanel jPanelNewName;
    private JPanel jPanelPath;

    public DialogContinueDownload(JFrame pparent, DatenDownload datenDownload, boolean ddirekterDownload) {
        super((Frame)pparent, true);
        this.initComponents();
        this.parent = pparent;
        this.direkterDownload = ddirekterDownload;
        if (!this.direkterDownload) {
            this.jButtonWeiter.setText("\u00dcberschreiben");
            if (!datenDownload.checkAufrufBauen()) {
                this.jPanelNewName.setVisible(false);
            }
        }
        this.mVPanelDownloadZiel = new MVPanelDownloadZiel(null, datenDownload, false);
        this.jPanelPath.setLayout(new BorderLayout(0, 0));
        this.jPanelPath.add((Component)this.mVPanelDownloadZiel, "Center");
        if (this.parent != null) {
            this.setLocationRelativeTo(this.parent);
        }
        String dialogText = "<html>Der Film \"" + datenDownload.arr[5] + "\" existiert bereits.<br>Wie m\u00f6chten Sie fortfahren?</html>";
        this.jLabel1.setText(dialogText);
        this.jButtonNeuerName.addActionListener(e -> {
            this.isNewName = this.mVPanelDownloadZiel.setPfadName_geaendert();
            if (!this.direkterDownload && !this.isNewName) {
                MVMessageDialog.showMessageDialog(this.parent, "Der Dateiname wurde nicht ge\u00e4ndert!", "Datei existiert bereits!", 0);
            } else {
                this.result = DownloadResult.RESTART_WITH_NEW_NAME;
                this.beenden();
            }
        });
        this.jButtonAbbrechen.addActionListener(e -> this.abbrechen());
        EscapeKeyHandler.installHandler(this, this::abbrechen);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DialogContinueDownload.this.abbrechen();
            }
        });
        this.jButtonWeiter.addActionListener(e -> {
            this.result = DownloadResult.CONTINUE;
            this.beenden();
        });
        this.countdownTimer = new Timer(0, new CountdownAction());
        this.countdownTimer.setRepeats(true);
        this.countdownTimer.start();
        this.pack();
        this.getRootPane().setDefaultButton(this.jButtonWeiter);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Point loc = DialogContinueDownload.this.getLocationOnScreen();
                DialogContinueDownload.this.setLocation(loc.x, loc.y + 70);
            }
        });
    }

    public DownloadResult getResult() {
        return this.result;
    }

    public boolean isNewName() {
        return this.isNewName;
    }

    private void abbrechen() {
        this.result = DownloadResult.CANCELLED;
        this.beenden();
    }

    private void beenden() {
        if (this.countdownTimer != null) {
            this.countdownTimer.stop();
        }
        this.dispose();
    }

    private void initComponents() {
        this.jButtonWeiter = new JButton();
        this.jButtonAbbrechen = new JButton();
        this.jPanelNewName = new JPanel();
        this.jButtonNeuerName = new JButton();
        this.jPanelPath = new JPanel();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("Download weiterf\u00fchren");
        this.jButtonWeiter.setText("Weiterf\u00fchren in XXX");
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jPanelNewName.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 255), 2));
        this.jButtonNeuerName.setText("Mit diesem Namen neu Starten");
        GroupLayout jPanelPathLayout = new GroupLayout(this.jPanelPath);
        this.jPanelPath.setLayout(jPanelPathLayout);
        jPanelPathLayout.setHorizontalGroup(jPanelPathLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 527, Short.MAX_VALUE));
        jPanelPathLayout.setVerticalGroup(jPanelPathLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 124, Short.MAX_VALUE));
        GroupLayout jPanelNewNameLayout = new GroupLayout(this.jPanelNewName);
        this.jPanelNewName.setLayout(jPanelNewNameLayout);
        jPanelNewNameLayout.setHorizontalGroup(jPanelNewNameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNewNameLayout.createSequentialGroup().addContainerGap(285, Short.MAX_VALUE).addComponent(this.jButtonNeuerName).addContainerGap()).addComponent(this.jPanelPath, -1, -1, Short.MAX_VALUE));
        jPanelNewNameLayout.setVerticalGroup(jPanelNewNameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNewNameLayout.createSequentialGroup().addComponent(this.jPanelPath, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonNeuerName).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel1.setText("<html>Die Filmdatei existiert bereits.<br>Wie m\u00f6chten Sie forfahren?</html>");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jPanelNewName, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonAbbrechen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonWeiter))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonWeiter).addComponent(this.jButtonAbbrechen)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanelNewName, -2, -1, -2).addGap(16, 16, 16)));
        this.pack();
    }

    private class CountdownAction
    implements ActionListener {
        private int countdown = ApplicationConfiguration.getConfiguration().getInt("download.continuation.time", 60);

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.countdown > 0) {
                String msg = !DialogContinueDownload.this.direkterDownload ? String.format("\u00dcberschreiben in %ds", this.countdown) : String.format("Weiterf\u00fchren in %ds", this.countdown);
                DialogContinueDownload.this.jButtonWeiter.setText(msg);
                if (DialogContinueDownload.this.countdownTimer != null) {
                    DialogContinueDownload.this.countdownTimer.setDelay((int)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS));
                }
            } else {
                DialogContinueDownload.this.result = DownloadResult.CONTINUE;
                DialogContinueDownload.this.beenden();
            }
            --this.countdown;
        }
    }

    public static enum DownloadResult {
        CANCELLED,
        CONTINUE,
        RESTART_WITH_NEW_NAME;

    }
}

