/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.replica;

import java.util.Optional;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;

public record ReplicaState(long logStartOffset, LogOffsetMetadata logEndOffsetMetadata, long lastFetchLeaderLogEndOffset, long lastFetchTimeMs, long lastCaughtUpTimeMs, Optional<Long> brokerEpoch) {
    public static final ReplicaState EMPTY = new ReplicaState(-1L, LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, 0L, 0L, 0L, Optional.empty());

    public long logEndOffset() {
        return this.logEndOffsetMetadata.messageOffset;
    }

    public boolean isCaughtUp(long leaderEndOffset, long currentTimeMs, long replicaMaxLagMs) {
        return leaderEndOffset == this.logEndOffset() || currentTimeMs - this.lastCaughtUpTimeMs <= replicaMaxLagMs;
    }
}

