/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import org.apache.kafka.common.record.DefaultRecordBatch;

public class BatchMetadata {
    public final int lastSeq;
    public final long lastOffset;
    public final int offsetDelta;
    public final long timestamp;

    public BatchMetadata(int lastSeq, long lastOffset, int offsetDelta, long timestamp) {
        this.lastSeq = lastSeq;
        this.lastOffset = lastOffset;
        this.offsetDelta = offsetDelta;
        this.timestamp = timestamp;
    }

    public int firstSeq() {
        return DefaultRecordBatch.decrementSequence((int)this.lastSeq, (int)this.offsetDelta);
    }

    public long firstOffset() {
        return this.lastOffset - (long)this.offsetDelta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchMetadata that = (BatchMetadata)o;
        return this.lastSeq == that.lastSeq && this.lastOffset == that.lastOffset && this.offsetDelta == that.offsetDelta && this.timestamp == that.timestamp;
    }

    public int hashCode() {
        int result = this.lastSeq;
        result = 31 * result + Long.hashCode(this.lastOffset);
        result = 31 * result + this.offsetDelta;
        result = 31 * result + Long.hashCode(this.timestamp);
        return result;
    }

    public String toString() {
        return "BatchMetadata(firstSeq=" + this.firstSeq() + ", lastSeq=" + this.lastSeq + ", firstOffset=" + this.firstOffset() + ", lastOffset=" + this.lastOffset + ", timestamp=" + this.timestamp + ")";
    }
}

