/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.juife.ComponentListModel;
import net.sf.juife.DefaultComponentListModel;
import net.sf.juife.plaf.ComponentListUI;

public class ComponentList
extends JPanel {
    private static final String uiClassID = "ComponentListUI";
    private ComponentListModel dataModel;
    private ListSelectionModel selectionModel;
    private final ListSelectionListener selectionHandler;
    private boolean autoUpdate = true;

    public ComponentList() {
        this(new DefaultComponentListModel());
    }

    public ComponentList(ComponentListModel model) {
        super(new BorderLayout());
        this.dataModel = model;
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionHandler = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ComponentList.this.fireSelectionChanged(e);
            }
        };
        this.getSelectionModel().addListSelectionListener(this.selectionHandler);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String name = e.getPropertyName();
                if (e.getPropertyName() == "selectionModel") {
                    ListSelectionModel old1 = (ListSelectionModel)e.getOldValue();
                    ListSelectionModel new1 = (ListSelectionModel)e.getNewValue();
                    if (old1 != null) {
                        old1.removeListSelectionListener(ComponentList.this.selectionHandler);
                    }
                    if (new1 != null) {
                        new1.addListSelectionListener(ComponentList.this.selectionHandler);
                    }
                }
            }
        });
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public ComponentListUI getUI() {
        return (ComponentListUI)this.ui;
    }

    public void setUI(ComponentListUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((ComponentListUI)UIManager.getUI(this));
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listenerList.add(ListSelectionListener.class, listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listenerList.remove(ListSelectionListener.class, listener);
    }

    protected void fireSelectionChanged(ListSelectionEvent e) {
        ListSelectionEvent e2 = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListSelectionListener.class) continue;
            if (e2 == null) {
                e2 = new ListSelectionEvent(this, e.getFirstIndex(), e.getLastIndex(), e.getValueIsAdjusting());
            }
            ((ListSelectionListener)listeners[i + 1]).valueChanged(e2);
        }
    }

    public ComponentListModel getModel() {
        return this.dataModel;
    }

    public void setModel(ComponentListModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model can't be null");
        }
        ComponentListModel oldModel = this.dataModel;
        this.dataModel = model;
        this.firePropertyChange("model", oldModel, this.dataModel);
        this.clearSelection();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ListSelectionModel model) {
        if (model == null) {
            throw new IllegalArgumentException("selectionModel can't be null");
        }
        ListSelectionModel oldModel = this.selectionModel;
        this.selectionModel = model;
        this.firePropertyChange("selectionModel", oldModel, this.selectionModel);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public void setSelectionMode(int selectionMode) {
        this.getSelectionModel().setSelectionMode(selectionMode);
    }

    public void setSelectionInterval(int index0, int index1) {
        this.getSelectionModel().setSelectionInterval(index0, index1);
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public boolean isSelectedIndex(int index) {
        return this.getSelectionModel().isSelectedIndex(index);
    }

    public void setSelectedIndex(int index) {
        if (index < 0 || index > this.getModel().getSize()) {
            return;
        }
        this.getSelectionModel().setSelectionInterval(index, index);
    }

    public int[] getSelectedIndices() {
        ListSelectionModel m = this.getSelectionModel();
        int i = m.getMinSelectionIndex();
        int j = m.getMaxSelectionIndex();
        if (i < 0 || j < 0) {
            return new int[0];
        }
        Vector<Integer> v = new Vector<Integer>(j - i + 1);
        for (int a = i; a <= j; ++a) {
            if (!m.isSelectedIndex(a)) continue;
            v.add(a);
        }
        int[] res = new int[v.size()];
        for (int a = 0; a < v.size(); ++a) {
            res[a] = (Integer)v.get(a);
        }
        return res;
    }

    public void setSelectedIndices(int[] indices) {
        ListSelectionModel m = this.getSelectionModel();
        m.clearSelection();
        for (int i : indices) {
            if (i >= this.getModel().getSize()) continue;
            m.addSelectionInterval(i, i);
        }
    }

    public Component[] getSelectedComponents() {
        ListSelectionModel m = this.getSelectionModel();
        int i = m.getMinSelectionIndex();
        int j = m.getMaxSelectionIndex();
        if (i < 0 || j < 0) {
            return new Component[0];
        }
        Vector v = new Vector(j - i + 1);
        for (int a = i; a <= j; ++a) {
            if (!m.isSelectedIndex(a)) continue;
            v.add(this.getModel().get(a));
        }
        return v.toArray(new Component[v.size()]);
    }

    public void setSelectedComponent(Component c, boolean shouldScroll) {
        ComponentListModel clm = this.getModel();
        if (c == null) {
            this.clearSelection();
            return;
        }
        for (int i = 0; i < clm.getSize(); ++i) {
            if (!c.equals(clm.get(i))) continue;
            this.setSelectedIndex(i);
            if (shouldScroll) {
                this.ensureIndexIsVisible(i);
            }
            return;
        }
        this.clearSelection();
    }

    public void selectAll() {
        if (this.getSelectionModel().getSelectionMode() == 0) {
            return;
        }
        if (this.getModel().getSize() == 0) {
            return;
        }
        this.getSelectionModel().setSelectionInterval(0, this.getModel().getSize() - 1);
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public void ensureIndexIsVisible(int index) {
        this.getUI().ensureIndexIsVisible(index);
    }

    public boolean getAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean b) {
        this.autoUpdate = b;
    }

    public void updateList() {
        this.getUI().updateList();
    }

    public void fireSelectionProbablyChanged(int index) {
        if (index >= this.getModel().getSize()) {
            return;
        }
        Object c = this.getModel().get(index);
        PropertyChangeListener[] listeners = ((Component)c).getPropertyChangeListeners("selectionProbablyChanged");
        PropertyChangeEvent e = new PropertyChangeEvent(this, "selectionProbablyChanged", null, this.getSelectionModel().isSelectedIndex(index) ? "true" : "false");
        for (PropertyChangeListener l : listeners) {
            l.propertyChange(e);
        }
    }

    static {
        UIManager.put(uiClassID, "net.sf.juife.plaf.basic.BasicComponentListUI");
    }
}

