/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.runtime;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import org.jcodings.Encoding;
import org.jruby.EvalType;
import org.jruby.MetaClass;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyMatchData;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyProc;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.ext.coverage.CoverageData;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.CompiledIRNoProtocolMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InterpretedIRBodyMethod;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.Interp;
import org.jruby.ir.JIT;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.persistence.IRReader;
import org.jruby.ir.persistence.IRReaderStream;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRReturnJump;
import org.jruby.ir.runtime.IRWrappedLambdaReturnValue;
import org.jruby.java.invokers.InstanceMethodInvoker;
import org.jruby.java.invokers.RubyToJavaInvoker;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.TraceEventManager;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.callsite.MonomorphicCallSite;
import org.jruby.runtime.callsite.ProfilingCachingCallSite;
import org.jruby.runtime.callsite.RefinedCachingCallSite;
import org.jruby.runtime.callsite.VariableCachingCallSite;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class IRRuntimeHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(IRRuntimeHelpers.class);
    private static final InvalidKeyException INVALID_KEY_EXCEPTION = new InvalidKeyException();
    private static final RubyHash.VisitorWithState<StaticScope> CheckUnwantedKeywordsVisitor = new RubyHash.VisitorWithState<StaticScope>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, StaticScope scope) {
            if (!IRRuntimeHelpers.isValidKeyword(scope, key2)) {
                throw INVALID_KEY_EXCEPTION;
            }
        }
    };

    public static boolean inProfileMode() {
        return RubyInstanceConfig.IR_PROFILE;
    }

    public static boolean isDebug() {
        return RubyInstanceConfig.IR_DEBUG;
    }

    public static boolean inNonMethodBodyLambda(StaticScope scope, Block.Type blockType) {
        return blockType == Block.Type.LAMBDA && !scope.isArgumentScope();
    }

    public static boolean inMethod(Block.Type blockType) {
        return blockType == null;
    }

    public static boolean inLambda(Block.Type blockType) {
        return blockType == Block.Type.LAMBDA;
    }

    public static boolean inProc(Block.Type blockType) {
        return blockType == Block.Type.PROC;
    }

    @Interp
    @JIT
    public static void checkForLJE(ThreadContext context, DynamicScope currentScope, boolean definedWithinMethod, Block block) {
        if (IRRuntimeHelpers.inLambda(block.type)) {
            return;
        }
        DynamicScope returnToScope = IRRuntimeHelpers.getContainingReturnToScope(currentScope);
        if (returnToScope == null || !context.scopeExistsOnCallStack(returnToScope)) {
            throw IRException.RETURN_LocalJumpError.getException(context.runtime);
        }
    }

    private static DynamicScope getContainingLambda(DynamicScope dynamicScope) {
        for (DynamicScope scope = dynamicScope; scope != null && scope.getStaticScope().isBlockScope(); scope = scope.getParentScope()) {
            if (!scope.isLambda() || scope.getStaticScope().isArgumentScope()) continue;
            return scope;
        }
        return null;
    }

    @JIT
    @Interp
    public static IRubyObject initiateNonLocalReturn(DynamicScope currentScope, Block block, IRubyObject returnValue) {
        if (block != null && IRRuntimeHelpers.inLambda(block.type)) {
            throw new IRWrappedLambdaReturnValue(returnValue);
        }
        DynamicScope returnToScope = IRRuntimeHelpers.getContainingLambda(currentScope);
        if (returnToScope == null) {
            returnToScope = IRRuntimeHelpers.getContainingReturnToScope(currentScope);
        }
        assert (returnToScope != null) : "accidental return scope";
        throw IRReturnJump.create(currentScope.getStaticScope(), returnToScope, returnValue);
    }

    private static DynamicScope getContainingReturnToScope(DynamicScope returnLocationScope) {
        for (DynamicScope current2 = returnLocationScope; current2 != null; current2 = current2.getParentScope()) {
            if (!current2.isReturnTarget()) continue;
            return current2;
        }
        return null;
    }

    @JIT
    public static IRubyObject handleNonlocalReturn(DynamicScope currentScope, Object rjExc) throws RuntimeException {
        if (!(rjExc instanceof IRReturnJump)) {
            Helpers.throwException((Throwable)rjExc);
            return null;
        }
        IRReturnJump rj = (IRReturnJump)rjExc;
        if (rj.isReturnToScope(currentScope)) {
            if (IRRuntimeHelpers.isDebug()) {
                System.out.println("---> Non-local Return reached target in scope: " + String.valueOf(currentScope));
            }
            return (IRubyObject)rj.returnValue;
        }
        throw rj;
    }

    private static IRScopeType ensureScopeIsClosure(ThreadContext context, DynamicScope dynamicScope) {
        IRScopeType scopeType = dynamicScope.getStaticScope().getScopeType();
        if (!scopeType.isClosureType()) {
            throw IRException.BREAK_LocalJumpError.getException(context.runtime);
        }
        return scopeType;
    }

    @JIT
    public static IRubyObject initiateBreak(ThreadContext context, DynamicScope dynScope, IRubyObject breakValue, Block block) throws RuntimeException {
        if (IRRuntimeHelpers.inLambda(block.type)) {
            throw new IRWrappedLambdaReturnValue(breakValue, true);
        }
        IRScopeType scopeType = IRRuntimeHelpers.ensureScopeIsClosure(context, dynScope);
        DynamicScope parentScope = dynScope.getParentScope();
        if (block.isEscaped()) {
            throw Helpers.newLocalJumpErrorForBreak(context.runtime, breakValue);
        }
        throw IRBreakJump.create(parentScope, breakValue, scopeType.isEval());
    }

    private static boolean inReturnToScope(Block.Type blockType, IRReturnJump exception2, DynamicScope currentScope) {
        return (IRRuntimeHelpers.inMethod(blockType) || IRRuntimeHelpers.inLambda(blockType)) && exception2.isReturnToScope(currentScope);
    }

    @JIT
    public static IRubyObject handleBreakAndReturnsInLambdas(ThreadContext context, DynamicScope dynScope, Object exc, Block block) throws RuntimeException {
        if (exc instanceof IRWrappedLambdaReturnValue) {
            return ((IRWrappedLambdaReturnValue)exc).returnValue;
        }
        if (exc instanceof IRReturnJump && dynScope != null && IRRuntimeHelpers.inReturnToScope(block.type, (IRReturnJump)exc, dynScope)) {
            if (IRRuntimeHelpers.isDebug()) {
                System.out.println("---> Non-local Return reached target in scope: " + String.valueOf(dynScope));
            }
            return (IRubyObject)((IRReturnJump)exc).returnValue;
        }
        context.setSavedExceptionInLambda((Throwable)exc);
        return null;
    }

    @JIT
    public static IRubyObject returnOrRethrowSavedException(ThreadContext context, IRubyObject value2) {
        Throwable exc = context.getSavedExceptionInLambda();
        if (exc != null) {
            context.setSavedExceptionInLambda(null);
            Helpers.throwException(exc);
        }
        return value2;
    }

    @JIT
    public static IRubyObject handlePropagatedBreak(ThreadContext context, DynamicScope dynScope, Object bjExc) {
        if (!(bjExc instanceof IRBreakJump)) {
            Helpers.throwException((Throwable)bjExc);
            return null;
        }
        IRBreakJump bj = (IRBreakJump)bjExc;
        if (bj.breakInEval) {
            IRRuntimeHelpers.ensureScopeIsClosure(context, dynScope);
            bj.breakInEval = false;
            throw bj;
        }
        if (bj.scopeToReturnTo == dynScope) {
            if (IRRuntimeHelpers.isDebug()) {
                System.out.println("---> Break reached target in scope: " + String.valueOf(dynScope));
            }
            return bj.breakValue;
        }
        throw bj;
    }

    public static IRubyObject undefMethod(ThreadContext context, Object nameArg, DynamicScope currDynScope, IRubyObject self2) {
        String str;
        String name2;
        RubyModule module = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        String string2 = name2 = nameArg instanceof String ? (str = (String)nameArg) : nameArg.toString();
        if (module == null) {
            throw Error.typeError(context, RubyStringBuilder.str(context.runtime, "No class to undef method '", Convert.asSymbol(context, name2), "'."));
        }
        module.undef(context, name2);
        return context.nil;
    }

    @JIT
    public static double unboxFloat(IRubyObject val) {
        double d;
        if (val instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)val;
            d = flote.getValue();
        } else {
            d = ((RubyFixnum)val).getValue();
        }
        return d;
    }

    @JIT
    public static long unboxFixnum(IRubyObject val) {
        long l;
        if (val instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)val;
            l = (long)flote.getValue();
        } else {
            l = ((RubyFixnum)val).getValue();
        }
        return l;
    }

    public static boolean flt(double v1, double v2) {
        return v1 < v2;
    }

    public static boolean fgt(double v1, double v2) {
        return v1 > v2;
    }

    public static boolean feq(double v1, double v2) {
        return v1 == v2;
    }

    public static boolean ilt(long v1, long v2) {
        return v1 < v2;
    }

    public static boolean igt(long v1, long v2) {
        return v1 > v2;
    }

    public static boolean ieq(long v1, long v2) {
        return v1 == v2;
    }

    public static Object unwrapRubyException(Object excObj) {
        if (excObj instanceof Unrescuable) {
            Helpers.throwException((Throwable)excObj);
        }
        return excObj instanceof RaiseException ? ((RaiseException)excObj).getException() : excObj;
    }

    private static boolean isJavaExceptionHandled(ThreadContext context, IRubyObject excType, Object excObj, boolean arrayCheck) {
        if (!(excObj instanceof Throwable)) {
            return false;
        }
        Ruby runtime2 = context.runtime;
        Throwable ex = (Throwable)excObj;
        if (excType instanceof RubyArray) {
            RubyArray testTypes = (RubyArray)excType;
            int n = testTypes.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                Object testType = testTypes.eltInternal(i2);
                if (!IRRuntimeHelpers.isJavaExceptionHandled(context, testType, ex, true)) continue;
                IRubyObject exception2 = n == 1 ? IRRuntimeHelpers.wrapJavaException(context, testType, ex) : Helpers.wrapJavaException(runtime2, ex);
                context.setErrorInfo(exception2);
                return true;
            }
        } else {
            IRubyObject exception3 = IRRuntimeHelpers.wrapJavaException(context, excType, ex);
            if (Helpers.checkJavaException(exception3, ex, excType, context)) {
                context.setErrorInfo(exception3);
                return true;
            }
        }
        return false;
    }

    private static IRubyObject wrapJavaException(ThreadContext context, IRubyObject excType, Throwable throwable) {
        Ruby runtime2 = context.runtime;
        if (excType == runtime2.getNativeException()) {
            return IRRuntimeHelpers.wrapWithNativeException(context, throwable, runtime2);
        }
        return Helpers.wrapJavaException(runtime2, throwable);
    }

    private static IRubyObject wrapWithNativeException(ThreadContext context, Throwable throwable, Ruby runtime2) {
        NativeException exception2 = new NativeException(runtime2, runtime2.getNativeException(), throwable);
        exception2.prepareIntegratedBacktrace(context, throwable.getStackTrace());
        return exception2;
    }

    private static boolean isRubyExceptionHandled(ThreadContext context, IRubyObject excType, Object excObj) {
        if (excType instanceof RubyArray) {
            RubyArray testTypes = (RubyArray)excType;
            int n = testTypes.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                Object testType = testTypes.eltInternal(i2);
                if (!IRRuntimeHelpers.isRubyExceptionHandled(context, testType, excObj)) continue;
                context.setErrorInfo((IRubyObject)excObj);
                return true;
            }
        } else if (excObj instanceof IRubyObject) {
            if (!(excType instanceof RubyModule)) {
                throw Error.typeError(context, RubyStringBuilder.str(context.runtime, "class or module required for rescue clause. Found: ", excType));
            }
            if (excType.callMethod(context, "===", (IRubyObject)excObj).isTrue()) {
                context.setErrorInfo((IRubyObject)excObj);
                return true;
            }
        }
        return false;
    }

    public static IRubyObject isExceptionHandled(ThreadContext context, IRubyObject excType, Object excObj) {
        boolean ret = IRRuntimeHelpers.isRubyExceptionHandled(context, excType, excObj = IRRuntimeHelpers.unwrapRubyException(excObj)) || IRRuntimeHelpers.isJavaExceptionHandled(context, excType, excObj, false);
        return Convert.asBoolean(context, ret);
    }

    public static IRubyObject isEQQ(ThreadContext context, IRubyObject receiver2, IRubyObject value2, CallSite callSite, boolean splattedValue) {
        boolean isUndefValue;
        boolean bl = isUndefValue = value2 == UndefinedValue.UNDEFINED;
        if (splattedValue && receiver2 instanceof RubyArray) {
            RubyArray testVals = (RubyArray)receiver2;
            int n = testVals.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                Object eqqVal;
                Object v = testVals.eltInternal(i2);
                Object object = eqqVal = isUndefValue ? v : callSite.call(context, (IRubyObject)v, (IRubyObject)v, value2);
                if (!eqqVal.isTrue()) continue;
                return eqqVal;
            }
            return context.fals;
        }
        if (isUndefValue) {
            return receiver2;
        }
        return callSite.call(context, receiver2, receiver2, value2);
    }

    public static IRubyObject newProc(Ruby runtime2, Block block) {
        return block == Block.NULL_BLOCK ? runtime2.getNil() : runtime2.newProc(Block.Type.PROC, block);
    }

    @JIT
    public static IRubyObject newProc(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        return block == Block.NULL_BLOCK ? runtime2.getNil() : runtime2.newProc(Block.Type.PROC, block);
    }

    @JIT
    public static RubyProc newLambdaProc(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        return runtime2.newProc(Block.Type.LAMBDA, block);
    }

    @JIT
    public static IRubyObject yield(ThreadContext context, Block b2, IRubyObject yieldVal, boolean unwrapArray) {
        return unwrapArray && yieldVal instanceof RubyArray ? b2.yieldArray(context, yieldVal, null) : b2.yield(context, yieldVal);
    }

    @JIT
    public static IRubyObject yieldSpecific(ThreadContext context, Block b2) {
        return b2.yieldSpecific(context);
    }

    @JIT
    public static IRubyObject yieldValues(ThreadContext context, Block blk, IRubyObject[] args2) {
        return blk.yieldValues(context, args2);
    }

    public static IRubyObject[] convertValueIntoArgArray(ThreadContext context, IRubyObject value2, Signature signature) {
        switch (signature.arityValue()) {
            case -1: {
                IRubyObject[] iRubyObjectArray;
                if (signature.opt() > 1 && value2 instanceof RubyArray) {
                    iRubyObjectArray = ((RubyArray)value2).toJavaArray(context);
                } else {
                    IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                    iRubyObjectArray = iRubyObjectArray2;
                    iRubyObjectArray2[0] = value2;
                }
                return iRubyObjectArray;
            }
            case 0: 
            case 1: {
                IRubyObject[] iRubyObjectArray;
                if (signature.rest() == Signature.Rest.ANON) {
                    iRubyObjectArray = IRBlockBody.toAry(context, value2);
                } else {
                    IRubyObject[] iRubyObjectArray3 = new IRubyObject[1];
                    iRubyObjectArray = iRubyObjectArray3;
                    iRubyObjectArray3[0] = value2;
                }
                return iRubyObjectArray;
            }
        }
        return IRBlockBody.toAry(context, value2);
    }

    public static IRubyObject[] convertValueIntoArgArray(ThreadContext context, RubyArray array2, Signature signature) {
        switch (signature.arityValue()) {
            case -1: {
                return array2.toJavaArray(context);
            }
            case 0: 
            case 1: {
                IRubyObject[] iRubyObjectArray;
                if (signature.rest() == Signature.Rest.ANON) {
                    iRubyObjectArray = IRBlockBody.toAry(context, array2);
                } else {
                    IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                    iRubyObjectArray = iRubyObjectArray2;
                    iRubyObjectArray2[0] = array2;
                }
                return iRubyObjectArray;
            }
        }
        return IRRuntimeHelpers.singleBlockArgToArray(Helpers.aryToAry(context, (IRubyObject)(array2.size() == 1 ? array2.eltInternal(0) : array2)));
    }

    @JIT
    public static Block getBlockFromObject(ThreadContext context, Object value2) {
        Block block;
        if (value2 instanceof Block) {
            block = (Block)value2;
        } else if (value2 instanceof RubyProc) {
            block = ((RubyProc)value2).getBlock();
        } else if (value2 instanceof RubyMethod) {
            block = ((RubyProc)((RubyMethod)value2).to_proc(context)).getBlock();
        } else if (value2 instanceof RubySymbol) {
            block = ((RubyProc)((RubySymbol)value2).to_proc(context)).getBlock();
        } else if (value2 instanceof IRubyObject && ((IRubyObject)value2).isNil()) {
            block = Block.NULL_BLOCK;
        } else if (value2 instanceof IRubyObject) {
            block = ((RubyProc)TypeConverter.convertToType((IRubyObject)value2, context.runtime.getProc(), "to_proc", true)).getBlock();
        } else {
            throw new RuntimeException("Unhandled case in CallInstr:prepareBlock.  Got block arg: " + String.valueOf(value2));
        }
        return block;
    }

    @JIT
    public static Block getRefinedBlockFromObject(ThreadContext context, StaticScope scope, Object value2) {
        Block block;
        if (value2 instanceof Block) {
            block = (Block)value2;
        } else if (value2 instanceof RubyProc) {
            block = ((RubyProc)value2).getBlock();
        } else if (value2 instanceof RubyMethod) {
            block = ((RubyProc)((RubyMethod)value2).to_proc(context)).getBlock();
        } else if (value2 instanceof RubySymbol) {
            block = ((RubyProc)((RubySymbol)value2).toRefinedProc(context, scope)).getBlock();
        } else if (value2 instanceof IRubyObject && ((IRubyObject)value2).isNil()) {
            block = Block.NULL_BLOCK;
        } else if (value2 instanceof IRubyObject) {
            block = ((RubyProc)TypeConverter.convertToType((IRubyObject)value2, context.runtime.getProc(), "to_proc", true)).getBlock();
        } else {
            throw new RuntimeException("Unhandled case in CallInstr:prepareBlock.  Got block arg: " + String.valueOf(value2));
        }
        return block;
    }

    public static void checkAritySpecificArgs(ThreadContext context, StaticScope scope, Object[] args2, int required, int opt, boolean rest, int restKey, Block block) {
        int argsLength = args2.length;
        if ((block == null || block.type.checkArity) && (argsLength < required || !rest && argsLength > required + opt)) {
            RubyHash last2;
            if (argsLength > required + opt && args2[argsLength - 1] instanceof RubyHash && (last2 = (RubyHash)args2[argsLength - 1]).isRuby2KeywordHash() && last2.isEmpty()) {
                return;
            }
            Arity.raiseArgumentError(context, argsLength, required, rest ? -1 : required + opt);
        }
    }

    public static void checkArity(ThreadContext context, StaticScope scope, Object[] args2, Object keywords, int required, int opt, boolean rest, int restKey, Block block) {
        int argsLength = args2.length - (keywords != UndefinedValue.UNDEFINED ? 1 : 0);
        if ((block == null || block.type.checkArity) && (argsLength < required || !rest && argsLength > required + opt)) {
            Arity.raiseArgumentError(context, argsLength, required, rest ? -1 : required + opt);
        }
        if (restKey == -1 && keywords != UndefinedValue.UNDEFINED) {
            IRRuntimeHelpers.checkForExtraUnwantedKeywordArgs(context, scope, (RubyHash)keywords);
        }
    }

    public static boolean shouldPrintIR(Ruby runtime2) {
        boolean booting = runtime2.isBooting();
        boolean print2 = Options.IR_PRINT.load();
        boolean printAll = Options.IR_PRINT_ALL.load();
        return !booting && print2 || booting && printAll;
    }

    public static boolean shouldPrintScope(IRScope scope) {
        String pattern = Options.IR_PRINT_PATTERN.load();
        return pattern.equals("<NO_PATTERN>") || scope.getId().matches(pattern);
    }

    public static void updateCoverage(ThreadContext context, String filename2, int line) {
        Ruby runtime2 = context.runtime;
        if (!runtime2.isCoverageEnabled()) {
            return;
        }
        CoverageData data2 = runtime2.getCoverageData();
        if (data2.isRunning()) {
            data2.coverLine(filename2, line);
        }
    }

    @JIT
    @Interp
    public static IRubyObject hashCheck(ThreadContext context, IRubyObject hash2) {
        if (hash2 instanceof RubyNil) {
            return Create.newHash(context);
        }
        return TypeConverter.convertToType(hash2, Access.hashClass(context), "to_hash");
    }

    public static IRubyObject isHashEmpty(ThreadContext context, IRubyObject hash2) {
        boolean isEmpty;
        if ((context.callInfo & 8) != 0) {
            return context.fals;
        }
        if (hash2.isNil()) {
            isEmpty = true;
        } else {
            boolean bl = isEmpty = (hash2 = TypeConverter.checkHashType(context.runtime, hash2)) instanceof RubyHash && ((RubyHash)hash2).size() == 0;
        }
        if (isEmpty) {
            context.callInfo |= 8;
        }
        return isEmpty ? context.tru : context.fals;
    }

    public static IRubyObject undefined() {
        return UndefinedValue.UNDEFINED;
    }

    @JIT
    public static IRubyObject receiveSpecificArityKeywords(ThreadContext context, IRubyObject last2, boolean ruby2Keywords) {
        if (!(last2 instanceof RubyHash)) {
            ThreadContext.clearCallInfo(context);
            return last2;
        }
        return ruby2Keywords ? IRRuntimeHelpers.receiveSpecificArityRuby2HashKeywords(context, (RubyHash)last2) : IRRuntimeHelpers.receiveSpecificArityHashKeywords(context, (RubyHash)last2);
    }

    private static IRubyObject receiveSpecificArityHashKeywords(ThreadContext context, RubyHash last2) {
        int callInfo = ThreadContext.resetCallInfo(context);
        boolean isKwarg = (callInfo & 2) != 0;
        return IRRuntimeHelpers.receiverSpecificArityKwargsCommon(context, last2, isKwarg);
    }

    private static IRubyObject receiveSpecificArityRuby2HashKeywords(ThreadContext context, RubyHash last2) {
        boolean isKwarg;
        int callInfo = ThreadContext.resetCallInfo(context);
        boolean bl = isKwarg = (callInfo & 2) != 0;
        if (isKwarg) {
            RubyHash hash2 = last2.dupFast(context);
            hash2.setRuby2KeywordHash(true);
            return hash2;
        }
        return IRRuntimeHelpers.receiverSpecificArityKwargsCommon(context, last2, false);
    }

    private static IRubyObject receiverSpecificArityKwargsCommon(ThreadContext context, RubyHash last2, boolean isKwarg) {
        return isKwarg || last2.isRuby2KeywordHash() ? last2.dupFast(context) : last2;
    }

    @JIT
    public static IRubyObject receiveNormalKeywordsNoRestNoKeywords(ThreadContext context, IRubyObject[] args2) {
        int callInfo = ThreadContext.resetCallInfo(context);
        if (IRRuntimeHelpers.shouldHandleKwargs(args2, callInfo) && (callInfo & 1) != 0) {
            return IRRuntimeHelpers.receiveKeywordsWithSplatsNoRestNoKeywords(context, args2);
        }
        return UndefinedValue.UNDEFINED;
    }

    @Interp
    public static IRubyObject receiveKeywords(ThreadContext context, IRubyObject[] args2, boolean hasRestArgs, boolean acceptsKeywords, boolean ruby2_keywords_method) {
        int callInfo = ThreadContext.resetCallInfo(context);
        if (IRRuntimeHelpers.shouldHandleKwargs(args2, callInfo)) {
            return IRRuntimeHelpers.receiveKeywordsHash(context, args2, hasRestArgs, acceptsKeywords, ruby2_keywords_method, callInfo);
        }
        return UndefinedValue.UNDEFINED;
    }

    private static IRubyObject receiveKeywordsWithSplatsNoRestNoKeywords(ThreadContext context, IRubyObject[] args2) {
        RubyHash hash2 = (RubyHash)args2[args2.length - 1];
        if (hash2.isRuby2KeywordHash()) {
            if (hash2.isEmpty()) {
                return hash2;
            }
            IRRuntimeHelpers.clearTrailingHashRuby2Keywords(context, args2, hash2);
        }
        return UndefinedValue.UNDEFINED;
    }

    private static void clearTrailingHashRuby2Keywords(ThreadContext context, IRubyObject[] args2, RubyHash hash2) {
        RubyHash newHash = hash2.dupFast(context);
        newHash.setRuby2KeywordHash(false);
        args2[args2.length - 1] = newHash;
    }

    private static boolean shouldHandleKwargs(IRubyObject[] args2, int callInfo) {
        return (callInfo & 8) == 0 && args2.length >= 1 && args2[args2.length - 1] instanceof RubyHash;
    }

    private static IRubyObject receiveKeywordsHash(ThreadContext context, IRubyObject[] args2, boolean hasRestArgs, boolean acceptsKeywords, boolean ruby2_keywords_method, int callInfo) {
        RubyHash hash2 = (RubyHash)args2[args2.length - 1];
        if (ruby2_keywords_method) {
            return IRRuntimeHelpers.receiveKeywordsHashRuby2KeywordsMethod(context, args2, acceptsKeywords, hash2, callInfo);
        }
        if (hash2.isRuby2KeywordHash()) {
            return IRRuntimeHelpers.receiveKeywordsHashRubyKeywordsHash(context, args2, hasRestArgs, acceptsKeywords, callInfo, hash2);
        }
        if ((callInfo & 2) == 0) {
            return UndefinedValue.UNDEFINED;
        }
        if (acceptsKeywords && !hash2.isEmpty()) {
            return hash2.dupFast(context);
        }
        args2[args2.length - 1] = hash2.dup(context);
        return UndefinedValue.UNDEFINED;
    }

    private static IRubyObject receiveKeywordsHashRubyKeywordsHash(ThreadContext context, IRubyObject[] args2, boolean hasRestArgs, boolean acceptsKeywords, int callInfo, RubyHash hash2) {
        boolean explicitKeywords;
        if (acceptsKeywords) {
            if (!hash2.isEmpty()) {
                hash2 = hash2.dupFast(context);
            }
            hash2.setRuby2KeywordHash(false);
            return hash2;
        }
        if ((callInfo & 1) != 0) {
            if (hash2.isEmpty()) {
                return hash2;
            }
            args2[args2.length - 1] = hash2.dup(context);
            return UndefinedValue.UNDEFINED;
        }
        boolean bl = explicitKeywords = (callInfo & 2) != 0;
        if (explicitKeywords) {
            if (!hash2.isEmpty()) {
                return hash2.dupFast(context);
            }
            if (hasRestArgs) {
                args2[args2.length - 1] = hash2.dup(context);
            }
        }
        return UndefinedValue.UNDEFINED;
    }

    private static IRubyObject receiveKeywordsHashRuby2KeywordsMethod(ThreadContext context, IRubyObject[] args2, boolean acceptsKeywords, RubyHash hash2, int callInfo) {
        if ((callInfo & 2) != 0) {
            IRRuntimeHelpers.setTrailingHashRuby2Keywords(context, args2, hash2);
        } else {
            if (hash2.isRuby2KeywordHash() && (callInfo & 1) != 0 && hash2.isEmpty()) {
                return hash2;
            }
            if (acceptsKeywords && !hash2.isEmpty()) {
                return hash2.dupFast(context);
            }
        }
        return UndefinedValue.UNDEFINED;
    }

    private static void setTrailingHashRuby2Keywords(ThreadContext context, IRubyObject[] args2, RubyHash hash2) {
        hash2 = hash2.dupFast(context);
        hash2.setRuby2KeywordHash(true);
        args2[args2.length - 1] = hash2;
    }

    public static IRubyObject dupIfKeywordRestAtCallsite(ThreadContext context, IRubyObject arg2) {
        int callInfo = context.callInfo;
        if ((callInfo & 8) == 0 && (callInfo & 4) != 0) {
            arg2 = arg2.dup();
            context.callInfo = callInfo;
        }
        return arg2;
    }

    @JIT
    @Interp
    public static void setCallInfo(ThreadContext context, int flags2) {
        context.callInfo = context.callInfo & 8 | flags2;
    }

    public static void checkForExtraUnwantedKeywordArgs(ThreadContext context, StaticScope scope, RubyHash keywordArgs) {
        try {
            keywordArgs.visitAll(context, CheckUnwantedKeywordsVisitor, scope);
        }
        catch (InvalidKeyException ike) {
            GatherUnwantedKeywordsVisitor visitor = new GatherUnwantedKeywordsVisitor();
            keywordArgs.visitAll(context, visitor, scope);
            visitor.raiseIfError(context);
        }
    }

    @JIT
    public static DynamicScope prepareScriptScope(ThreadContext context, StaticScope scope) {
        DynamicScope tlbScope;
        IRScope irScope = scope.getIRScope();
        if (irScope != null && irScope.isScriptScope() && !irScope.hasFlipFlops() && (tlbScope = ((IRScriptBody)irScope).getScriptDynamicScope()) != null) {
            context.preScopedBody(tlbScope);
            return tlbScope;
        }
        DynamicScope dynScope = DynamicScope.newDynamicScope(scope);
        context.pushScope(dynScope);
        return dynScope;
    }

    public static IRubyObject blockGivenOrCall(ThreadContext context, IRubyObject self2, FunctionalCachingCallSite blockGivenSite, Object blk) {
        CacheEntry blockGivenEntry = blockGivenSite.retrieveCache(self2);
        if (!blockGivenEntry.method.getRealMethod().isBuiltin()) {
            return blockGivenSite.call(context, self2, self2);
        }
        return IRRuntimeHelpers.isBlockGiven(context, blk);
    }

    private static boolean isValidKeyword(StaticScope scope, IRubyObject key2) {
        return key2 instanceof RubySymbol && scope.keywordExists(((RubySymbol)key2).idString());
    }

    public static IRubyObject match3(ThreadContext context, RubyRegexp regexp2, IRubyObject argValue) {
        if (argValue instanceof RubyString) {
            return regexp2.op_match(context, argValue);
        }
        return argValue.callMethod(context, "=~", regexp2);
    }

    public static IRubyObject extractOptionalArgument(RubyArray rubyArray, int minArgsLength, int index2) {
        int n = rubyArray.getLength();
        return minArgsLength < n ? rubyArray.entry(index2) : UndefinedValue.UNDEFINED;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedBackref(ThreadContext context, IRubyObject definedMessage) {
        return RubyMatchData.class.isInstance(context.getBackRef()) ? definedMessage : context.nil;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedGlobal(ThreadContext context, String name2, IRubyObject definedMessage) {
        return Access.globalVariables(context).isDefined(name2) ? definedMessage : context.nil;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedNthRef(ThreadContext context, int matchNumber, IRubyObject definedMessage) {
        RubyMatchData match2;
        IRubyObject backref = context.getBackRef();
        return backref instanceof RubyMatchData && !(match2 = (RubyMatchData)backref).group(context, matchNumber).isNil() ? definedMessage : context.nil;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedClassVar(ThreadContext context, RubyModule receiver2, String name2, IRubyObject definedMessage) {
        RubyBasicObject attached;
        boolean defined = receiver2.isClassVarDefined(name2);
        if (!defined && receiver2.isSingleton() && (attached = ((MetaClass)receiver2).getAttached()) instanceof RubyModule) {
            defined = ((RubyModule)attached).isClassVarDefined(name2);
        }
        return defined ? definedMessage : context.nil;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedCall(ThreadContext context, IRubyObject self2, IRubyObject receiver2, String name2, IRubyObject definedMessage) {
        IRubyObject boundValue = Helpers.getDefinedCall(context, self2, receiver2, name2, definedMessage);
        return boundValue == null ? context.nil : boundValue;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedConstantOrMethod(ThreadContext context, IRubyObject receiver2, RubyString name2, IRubyObject definedConstantMessage, IRubyObject definedMethodMessage) {
        IRubyObject definedType = Helpers.getDefinedConstantOrBoundMethod(context, receiver2, name2.intern(context).idString(), definedConstantMessage, definedMethodMessage);
        return definedType == null ? context.nil : definedType;
    }

    @JIT
    @Interp
    public static IRubyObject isDefinedMethod(ThreadContext context, IRubyObject receiver2, String name2, boolean checkIfPublic, IRubyObject definedMessage) {
        boolean defined;
        DynamicMethod method2 = receiver2.getMetaClass().searchMethod(name2);
        boolean bl = defined = !method2.isUndefined();
        defined = defined ? !checkIfPublic || method2.getVisibility() == Visibility.PUBLIC : receiver2.respondsToMissing(name2, checkIfPublic);
        return defined ? definedMessage : context.nil;
    }

    @Interp
    public static IRubyObject isDefinedSuper(ThreadContext context, IRubyObject receiver2, IRubyObject definedMessage) {
        return IRRuntimeHelpers.isDefinedSuper(context, receiver2, context.getFrameName(), context.getFrameKlazz(), definedMessage);
    }

    @JIT
    public static IRubyObject isDefinedSuper(ThreadContext context, IRubyObject receiver2, String frameName, RubyModule frameClass, IRubyObject definedMessage) {
        boolean defined = frameName != null && frameClass != null && frameClass.getSuperClass() != null && frameClass.getSuperClass().isMethodBound(frameName, false);
        return defined ? definedMessage : context.nil;
    }

    public static IRubyObject nthMatch(ThreadContext context, int matchNumber) {
        return RubyRegexp.nth_match(context, matchNumber, context.getBackRef());
    }

    public static void defineAlias(ThreadContext context, IRubyObject self2, DynamicScope currDynScope, IRubyObject newName, IRubyObject oldName) {
        if (self2 == null || self2 instanceof RubyFixnum || self2 instanceof RubySymbol) {
            throw Error.typeError(context, "no class to make alias");
        }
        IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2).aliasMethod(context, newName, oldName);
    }

    public static RubyModule getCurrentClassBase(ThreadContext context, IRubyObject self2) {
        return IRRuntimeHelpers.getModuleFromScope(context, context.getCurrentStaticScope(), self2);
    }

    public static RubyModule getModuleFromScope(ThreadContext context, StaticScope scope, IRubyObject arg2) {
        RubyModule rubyClass = scope.getModule();
        while (scope != null && (rubyClass.isSingleton() || rubyClass == context.runtime.getDummy())) {
            scope = scope.getPreviousCRefScope();
            rubyClass = scope.getModule();
            if (scope.getPreviousCRefScope() != null) continue;
            Warn.warn(context, "class variable access from toplevel singleton method");
        }
        if (scope == null && arg2 != null) {
            rubyClass = arg2.getMetaClass();
        }
        if (rubyClass == null) {
            throw Error.typeError(context, "no class/module to define class variable");
        }
        return rubyClass;
    }

    @JIT
    @Interp
    public static IRubyObject mergeKeywordArguments(ThreadContext context, IRubyObject restKwarg, IRubyObject explicitKwarg, boolean checkForDuplicates) {
        RubyHash hash2;
        if (!(restKwarg instanceof RubyHash)) {
            hash2 = (RubyHash)TypeConverter.checkHashType(context.runtime, restKwarg);
        } else {
            RubyHash hsh = (RubyHash)restKwarg;
            hash2 = !hsh.isEmpty() ? (RubyHash)hsh.dup() : Create.newHash(context);
        }
        hash2.modify();
        RubyHash otherHash = explicitKwarg.convertToHash();
        if (otherHash.empty_p(context).isTrue()) {
            return hash2;
        }
        if (checkForDuplicates) {
            otherHash.visitAll(context, new KwargMergeVisitor(hash2), Block.NULL_BLOCK);
        } else {
            hash2.merge_bang(context, new IRubyObject[]{otherHash}, Block.NULL_BLOCK);
        }
        return hash2;
    }

    public static RubyModule findInstanceMethodContainer(ThreadContext context, DynamicScope currDynScope, IRubyObject self2) {
        boolean inBindingEval = currDynScope.inBindingEval();
        if (!inBindingEval && self2 == context.runtime.getTopSelf()) {
            return self2.getType();
        }
        DynamicScope ds = currDynScope;
        while (ds != null) {
            IRScopeType scopeType = ds.getStaticScope().getScopeType();
            switch (ds.getEvalType()) {
                case MODULE_EVAL: {
                    return self2 instanceof RubyModule ? (RubyModule)self2 : self2.getMetaClass();
                }
                case INSTANCE_EVAL: {
                    return self2.singletonClass(context);
                }
                case BINDING_EVAL: {
                    ds = ds.getParentScope();
                    break;
                }
                case NONE: {
                    if (scopeType == null || scopeType.isClosureType()) {
                        ds = ds.getParentScope();
                        break;
                    }
                    if (inBindingEval) {
                        return ds.getStaticScope().getModule();
                    }
                    switch (scopeType) {
                        case CLASS_METHOD: 
                        case MODULE_BODY: 
                        case CLASS_BODY: 
                        case METACLASS_BODY: {
                            if (!(self2 instanceof MetaClass) && self2.getMetaClass().isSingleton()) {
                                return ds.getStaticScope().getModule();
                            }
                            return self2 instanceof RubyModule ? (RubyModule)self2 : self2.getMetaClass();
                        }
                        case INSTANCE_METHOD: {
                            return self2.getMetaClass();
                        }
                        case SCRIPT_BODY: {
                            return currDynScope.getStaticScope().getModule();
                        }
                    }
                    throw new RuntimeException("Should not get here! scopeType is " + String.valueOf((Object)scopeType));
                }
            }
        }
        throw new RuntimeException("Should not get here!");
    }

    public static RubyBoolean isBlockGiven(ThreadContext context, Object blk) {
        if (blk instanceof RubyProc) {
            blk = ((RubyProc)blk).getBlock();
        }
        if (blk instanceof RubyNil) {
            blk = Block.NULL_BLOCK;
        }
        return Convert.asBoolean(context, ((Block)blk).isGiven());
    }

    @JIT
    @Interp
    public static IRubyObject receiveRestArg(ThreadContext context, IRubyObject[] args2, IRubyObject keywords, int required, int argIndex) {
        int argsLength = args2.length + (keywords != UndefinedValue.UNDEFINED ? -1 : 0);
        if (required == 0 && argsLength == args2.length) {
            return RubyArray.newArray(context.runtime, args2);
        }
        int remainingArguments = argsLength - required;
        if (remainingArguments <= 0) {
            return Create.newEmptyArray(context);
        }
        return RubyArray.newArrayMayCopy(context.runtime, args2, argIndex, remainingArguments);
    }

    @JIT
    @Interp
    public static IRubyObject receivePostReqdArg(ThreadContext context, IRubyObject[] args2, IRubyObject keywords, int pre, int opt, boolean rest, int post, int argIndex) {
        int required = pre + post;
        int n = keywords != UndefinedValue.UNDEFINED ? args2.length - 1 : args2.length;
        int remaining = n - pre;
        if (remaining < post) {
            if (pre + argIndex >= n) {
                return context.nil;
            }
            return args2[pre + argIndex];
        }
        if (rest) {
            return args2[n - post + argIndex];
        }
        if (n > required + opt) {
            return args2[pre + opt + argIndex];
        }
        return args2[n - post + argIndex];
    }

    @JIT
    @Interp
    public static IRubyObject receiveOptArg(IRubyObject[] args2, IRubyObject keywords, int requiredArgs, int preArgs, int argIndex) {
        int argsLength;
        int optArgIndex = argIndex;
        int n = argsLength = keywords != UndefinedValue.UNDEFINED ? args2.length - 1 : args2.length;
        if (requiredArgs + optArgIndex >= argsLength) {
            return UndefinedValue.UNDEFINED;
        }
        return args2[preArgs + optArgIndex];
    }

    public static IRubyObject getPreArgSafe(ThreadContext context, IRubyObject[] args2, int argIndex) {
        IRubyObject result2 = argIndex < args2.length ? args2[argIndex] : context.nil;
        return result2;
    }

    @JIT
    public static IRubyObject receiveKeywordArg(ThreadContext context, IRubyObject keywords, String id2) {
        return IRRuntimeHelpers.receiveKeywordArg(keywords, Convert.asSymbol(context, id2));
    }

    @Interp
    public static IRubyObject receiveKeywordArg(IRubyObject keywords, RubySymbol key2) {
        if (keywords == UndefinedValue.UNDEFINED) {
            return UndefinedValue.UNDEFINED;
        }
        IRubyObject value2 = ((RubyHash)keywords).delete(key2);
        return value2 == null ? UndefinedValue.UNDEFINED : value2;
    }

    @JIT
    public static IRubyObject keywordRestOnHash(ThreadContext context, IRubyObject rest) {
        TypeConverter.checkType(context, rest, Access.hashClass(context));
        return ((RubyHash)rest).dupFast(context);
    }

    @JIT
    @Interp
    public static IRubyObject receiveKeywordRestArg(ThreadContext context, IRubyObject keywords) {
        return keywords == UndefinedValue.UNDEFINED ? Create.newSmallHash(context) : (RubyHash)keywords;
    }

    public static IRubyObject setCapturedVar(ThreadContext context, IRubyObject matchRes, String id2) {
        if (matchRes.isNil()) {
            return context.nil;
        }
        RubyMatchData backref = (RubyMatchData)context.getBackRef();
        return RubyRegexp.nth_match(context, backref.getNameToBackrefNumber(context, id2), (IRubyObject)backref);
    }

    @JIT
    public static IRubyObject instanceSuperSplatArgs(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.instanceSuper(context, self2, methodName, definingModule, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @JIT
    public static IRubyObject instanceSuperIterSplatArgs(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.instanceSuperIter(context, self2, methodName, definingModule, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @Interp
    public static IRubyObject instanceSuper(ThreadContext context, IRubyObject self2, String id2, RubyModule definingModule, IRubyObject[] args2, Block block) {
        CacheEntry entry = IRRuntimeHelpers.getSuperMethodEntry(id2, definingModule);
        DynamicMethod method2 = entry.method;
        if (method2 instanceof InstanceMethodInvoker && self2 instanceof JavaProxy) {
            return IRRuntimeHelpers.javaProxySuper(context, (JavaProxy)self2, id2, (RubyClass)definingModule, args2, (InstanceMethodInvoker)method2);
        }
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), id2, CallType.SUPER, args2, block);
        }
        return method2.call(context, self2, entry.sourceModule, id2, args2, block);
    }

    private static IRubyObject javaProxySuper(ThreadContext context, JavaProxy self2, String id2, RubyClass definingModule, IRubyObject[] args2, InstanceMethodInvoker superMethod) {
        JavaProxyMethod jpm;
        Object javaInvokee = self2.getObject();
        JavaMethod javaMethod = (JavaMethod)superMethod.findCallable(self2, id2, args2, args2.length);
        Object[] newArgs = RubyToJavaInvoker.convertArguments(javaMethod, args2);
        JavaProxyClass jpc = JavaProxyClass.getProxyClass(context, definingModule);
        if (jpc != null && (jpm = jpc.getMethod(id2, javaMethod.getParameterTypes())) != null && jpm.hasSuperImplementation()) {
            return javaMethod.invokeDirectSuperWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, newArgs);
        }
        return javaMethod.invokeDirectWithExceptionHandling(context, javaMethod.getValue(), javaInvokee, newArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Interp
    public static IRubyObject instanceSuperIter(ThreadContext context, IRubyObject self2, String id2, RubyModule definingModule, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject = IRRuntimeHelpers.instanceSuper(context, self2, id2, definingModule, args2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    private static CacheEntry getSuperMethodEntry(String id2, RubyModule definingModule) {
        RubyClass superClass = definingModule.getMethodLocation().getSuperClass();
        return superClass != null ? superClass.searchWithCache(id2) : CacheEntry.NULL_CACHE;
    }

    @JIT
    public static IRubyObject classSuperSplatArgs(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.classSuper(context, self2, methodName, definingModule, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @JIT
    public static IRubyObject classSuperIterSplatArgs(ThreadContext context, IRubyObject self2, String methodName, RubyModule definingModule, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.classSuperIter(context, self2, methodName, definingModule, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @Interp
    public static IRubyObject classSuper(ThreadContext context, IRubyObject self2, String id2, RubyModule definingModule, IRubyObject[] args2, Block block) {
        CacheEntry entry = IRRuntimeHelpers.getSuperMethodEntry(id2, definingModule.getMetaClass());
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method2.getVisibility(), id2, CallType.SUPER, args2, block);
        }
        return method2.call(context, self2, entry.sourceModule, id2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Interp
    public static IRubyObject classSuperIter(ThreadContext context, IRubyObject self2, String id2, RubyModule definingModule, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject = IRRuntimeHelpers.classSuper(context, self2, id2, definingModule, args2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @JIT
    public static IRubyObject unresolvedSuperSplatArgs(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.unresolvedSuper(context, self2, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @JIT
    public static IRubyObject unresolvedSuperIterSplatArgs(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block, boolean[] splatMap) {
        return IRRuntimeHelpers.unresolvedSuperIter(context, self2, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    @Interp
    public static IRubyObject unresolvedSuper(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String methodName = context.getFrameName();
        Helpers.checkSuperDisabledOrOutOfMethod(context, klazz, methodName);
        RubyClass superClass = IRRuntimeHelpers.searchNormalSuperclass(klazz);
        CacheEntry entry = superClass != null ? superClass.searchWithCache(methodName) : CacheEntry.NULL_CACHE;
        IRubyObject rVal = entry.method.isUndefined() ? Helpers.callMethodMissing(context, self2, entry.method.getVisibility(), methodName, CallType.SUPER, args2, block) : entry.method.call(context, self2, entry.sourceModule, methodName, args2, block);
        return rVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Interp
    public static IRubyObject unresolvedSuperIter(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject = IRRuntimeHelpers.unresolvedSuper(context, self2, args2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    private static RubyClass searchNormalSuperclass(RubyModule klazz) {
        if (klazz.isIncluded() && klazz.getOrigin().isRefinement()) {
            klazz = klazz.getOrigin();
        }
        klazz = klazz.getMethodLocation();
        return klazz.getSuperClass();
    }

    public static IRubyObject zSuperSplatArgs(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block, boolean[] splatMap) {
        if (block == null || !block.isGiven()) {
            block = context.getFrameBlock();
        }
        return IRRuntimeHelpers.unresolvedSuper(context, self2, IRRuntimeHelpers.splatArguments(args2, splatMap), block);
    }

    public static IRubyObject zSuper(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        if (block == null || !block.isGiven()) {
            block = context.getFrameBlock();
        }
        return IRRuntimeHelpers.unresolvedSuper(context, self2, args2, block);
    }

    public static IRubyObject[] splatArguments(IRubyObject[] args2, boolean[] splatMap) {
        if (splatMap != null && splatMap.length > 0) {
            int count2 = 0;
            for (int i2 = 0; i2 < splatMap.length; ++i2) {
                count2 += splatMap[i2] && args2[i2] instanceof RubyArray ? ((RubyArray)args2[i2]).size() : 1;
            }
            IRubyObject[] newArgs = new IRubyObject[count2];
            int actualOffset = 0;
            for (int i3 = 0; i3 < splatMap.length; ++i3) {
                if (splatMap[i3] && args2[i3] instanceof RubyArray) {
                    RubyArray ary = (RubyArray)args2[i3];
                    for (int j = 0; j < ary.size(); ++j) {
                        newArgs[actualOffset++] = ary.eltOk(j);
                    }
                    continue;
                }
                newArgs[actualOffset++] = args2[i3];
            }
            args2 = newArgs;
        }
        return args2;
    }

    public static String encodeSplatmap(boolean[] splatmap) {
        if (splatmap == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (boolean b2 : splatmap) {
            builder.append(b2 ? (char)'1' : '0');
        }
        return builder.toString();
    }

    public static boolean[] decodeSplatmap(String splatmapString) {
        boolean[] splatMap;
        if (splatmapString.length() > 0) {
            splatMap = new boolean[splatmapString.length()];
            for (int i2 = 0; i2 < splatmapString.length(); ++i2) {
                if (splatmapString.charAt(i2) != '1') continue;
                splatMap[i2] = true;
            }
        } else {
            splatMap = null;
        }
        return splatMap;
    }

    public static boolean[] buildSplatMap(Operand[] args2) {
        boolean[] splatMap = null;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            Operand operand = args2[i2];
            if (!(operand instanceof Splat)) continue;
            if (splatMap == null) {
                splatMap = new boolean[args2.length];
            }
            splatMap[i2] = true;
        }
        return splatMap;
    }

    public static boolean anyTrue(boolean[] booleans) {
        for (boolean b2 : booleans) {
            if (!b2) continue;
            return true;
        }
        return false;
    }

    public static boolean needsSplatting(boolean[] splatmap) {
        return splatmap != null && splatmap.length > 0 && IRRuntimeHelpers.anyTrue(splatmap);
    }

    public static final Type[] typesFromSignature(com.headius.invokebinder.Signature signature) {
        Type[] types = new Type[signature.argCount()];
        for (int i2 = 0; i2 < signature.argCount(); ++i2) {
            types[i2] = Type.getType(signature.argType(i2));
        }
        return types;
    }

    @JIT
    public static RubyString newFrozenStringFromRaw(ThreadContext context, String str, String encoding2, int cr, String file2, int line) {
        return IRRuntimeHelpers.newFrozenString(context, IRRuntimeHelpers.newByteListFromRaw(context.runtime, str, encoding2), cr, file2, line);
    }

    @JIT
    public static RubyString newFrozenStringFromRaw(ThreadContext context, String str, String encoding2, int cr) {
        return IRRuntimeHelpers.newFrozenString(context, IRRuntimeHelpers.newByteListFromRaw(context.runtime, str, encoding2), cr);
    }

    @JIT
    public static final ByteList newByteListFromRaw(Ruby runtime2, String str, String encoding2) {
        return new ByteList(RubyEncoding.encodeISO(str), runtime2.getEncodingService().getEncodingFromString(encoding2), false);
    }

    @JIT
    public static RubyEncoding retrieveEncoding(ThreadContext context, String name2) {
        return Access.encodingService(context).getEncoding(IRRuntimeHelpers.retrieveJCodingsEncoding(context, name2));
    }

    @JIT
    public static Encoding retrieveJCodingsEncoding(ThreadContext context, String name2) {
        return Access.encodingService(context).findEncodingOrAliasEntry(name2.getBytes()).getEncoding();
    }

    @JIT
    public static RubyHash constructHashFromArray(ThreadContext context, IRubyObject[] pairs) {
        int length2 = pairs.length / 2;
        boolean useSmallHash = length2 <= 10;
        RubyHash hash2 = useSmallHash ? Create.newSmallHash(context) : Create.newHash(context);
        int i2 = 0;
        while (i2 < pairs.length) {
            if (useSmallHash) {
                hash2.fastASetSmall(context.runtime, pairs[i2++], pairs[i2++], true);
                continue;
            }
            hash2.fastASet(context.runtime, pairs[i2++], pairs[i2++], true);
        }
        return hash2;
    }

    @JIT
    public static RubyHash dupKwargsHashAndPopulateFromArray(ThreadContext context, RubyHash dupHash, IRubyObject[] pairs) {
        Ruby runtime2 = context.runtime;
        RubyHash hash2 = dupHash.dupFast(context);
        int i2 = 0;
        while (i2 < pairs.length) {
            hash2.fastASetCheckString(runtime2, pairs[i2++], pairs[i2++]);
        }
        return hash2;
    }

    @JIT
    public static IRubyObject searchConst(ThreadContext context, StaticScope staticScope, String constName, boolean noPrivateConsts) {
        IRubyObject constant = staticScope.getScopedConstant(context, constName);
        RubyModule module = null;
        if (constant == null) {
            module = staticScope.getModule();
            constant = noPrivateConsts ? module.getConstantFromNoConstMissing(context, constName, false) : module.getConstantNoConstMissing(context, constName);
        }
        return constant != null ? constant : module.callMethod(context, "const_missing", (IRubyObject)context.runtime.fastNewSymbol(constName));
    }

    @JIT
    public static IRubyObject inheritedSearchConst(ThreadContext context, IRubyObject cmVal, String constName, boolean noPrivateConsts) {
        if (!(cmVal instanceof RubyModule)) {
            throw Error.typeError(context, "", cmVal, " is not a class/module");
        }
        RubyModule module = (RubyModule)cmVal;
        IRubyObject constant = noPrivateConsts ? module.getConstantFromNoConstMissing(context, constName, false) : module.getConstantNoConstMissing(context, constName);
        return constant == null ? UndefinedValue.UNDEFINED : constant;
    }

    @JIT
    public static IRubyObject lexicalSearchConst(ThreadContext context, StaticScope staticScope, String constName) {
        IRubyObject constant = staticScope.getScopedConstant(context, constName);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        return constant;
    }

    public static IRubyObject setInstanceVariable(IRubyObject self2, IRubyObject value2, String name2) {
        return self2.getInstanceVariables().setInstanceVariable(name2, value2);
    }

    @Interp
    public static DynamicMethod newInterpretedMetaClass(ThreadContext context, IRScope metaClassBody, IRubyObject obj) {
        RubyClass singletonClass = IRRuntimeHelpers.newMetaClassFromIR(context, metaClassBody.getStaticScope(), obj, metaClassBody.maybeUsingRefinements());
        return new InterpretedIRBodyMethod(metaClassBody, singletonClass);
    }

    @JIT
    public static DynamicMethod newCompiledMetaClass(ThreadContext context, MethodHandle handle, StaticScope scope, IRubyObject obj, int line, boolean refinements2, boolean dynscopeEliminated) {
        RubyClass singletonClass = IRRuntimeHelpers.newMetaClassFromIR(context, scope, obj, refinements2);
        return new CompiledIRNoProtocolMethod(handle, scope, scope.getFile(), line, singletonClass, !dynscopeEliminated);
    }

    private static RubyClass newMetaClassFromIR(ThreadContext context, StaticScope scope, IRubyObject obj, boolean refinements2) {
        RubyClass singletonClass = obj.singletonClass(context);
        scope.setModule(singletonClass);
        if (refinements2) {
            scope.captureParentRefinements(context);
        }
        return singletonClass;
    }

    @JIT
    public static DynamicMethod newCompiledModuleBody(ThreadContext context, MethodHandle handle, String id2, int line, StaticScope scope, Object rubyContainer, boolean maybeRefined) {
        RubyModule newRubyModule = IRRuntimeHelpers.newRubyModuleFromIR(context, id2, scope, rubyContainer, maybeRefined);
        return new CompiledIRMethod(handle, id2, line, scope, Visibility.PUBLIC, newRubyModule);
    }

    @Interp
    @JIT
    public static RubyModule newRubyModuleFromIR(ThreadContext context, String id2, StaticScope scope, Object rubyContainer, boolean maybeRefined) {
        if (!(rubyContainer instanceof RubyModule)) {
            throw Error.typeError(context, "no outer class/module");
        }
        RubyModule newRubyModule = ((RubyModule)rubyContainer).defineOrGetModuleUnder(context, id2, scope.getFile(), context.getLine() + 1);
        scope.setModule(newRubyModule);
        if (maybeRefined) {
            scope.captureParentRefinements(context);
        }
        return newRubyModule;
    }

    @JIT
    public static DynamicMethod newCompiledClassBody(ThreadContext context, MethodHandle handle, String id2, int line, StaticScope scope, Object container, Object superClass, boolean maybeRefined) {
        RubyModule newRubyClass = IRRuntimeHelpers.newRubyClassFromIR(context, id2, scope, superClass, container, maybeRefined);
        return new CompiledIRMethod(handle, id2, line, scope, Visibility.PUBLIC, newRubyClass);
    }

    @Interp
    public static RubyModule newRubyClassFromIR(ThreadContext context, String id2, StaticScope scope, Object superClass, Object container, boolean maybeRefined) {
        RubyClass sc;
        if (!(container instanceof RubyModule)) {
            throw Error.typeError(context, "no outer class/module");
        }
        if (superClass == UndefinedValue.UNDEFINED) {
            sc = null;
        } else {
            RubyClass.checkInheritable(context, (IRubyObject)superClass);
            sc = (RubyClass)superClass;
        }
        RubyClass newRubyClass = ((RubyModule)container).defineClassUnder(context, id2, sc, null, scope.getFile(), context.getLine() + 1);
        scope.setModule(newRubyClass);
        if (maybeRefined) {
            scope.captureParentRefinements(context);
        }
        return newRubyClass;
    }

    @Interp
    public static void defInterpretedClassMethod(ThreadContext context, IRScope method2, IRubyObject obj) {
        context.setLine(method2.getLine());
        String id2 = method2.getId();
        RubyClass rubyClass = IRRuntimeHelpers.checkClassForDef(context, id2, obj);
        if (method2.maybeUsingRefinements()) {
            method2.getStaticScope().captureParentRefinements(context);
        }
        AbstractIRMethod newMethod = Access.instanceConfig(context).getCompileMode() == RubyInstanceConfig.CompileMode.OFF ? new InterpretedIRMethod(method2, Visibility.PUBLIC, rubyClass) : new MixedModeIRMethod(method2, Visibility.PUBLIC, rubyClass);
        rubyClass.addMethod(context, id2, newMethod);
        if (!rubyClass.isRefinement()) {
            obj.callMethod(context, "singleton_method_added", method2.getName());
        }
    }

    @JIT
    public static void defCompiledClassMethod(ThreadContext context, MethodHandle handle, String id2, int line, StaticScope scope, String encodedArgumentDescriptors, IRubyObject obj, boolean maybeRefined, boolean receivesKeywordArgs, boolean needsToFindImplementer) {
        context.setLine(line);
        RubyClass rubyClass = IRRuntimeHelpers.checkClassForDef(context, id2, obj);
        if (maybeRefined) {
            scope.captureParentRefinements(context);
        }
        rubyClass.addMethod(context, id2, new CompiledIRMethod(handle, null, -1, id2, line, scope, Visibility.PUBLIC, rubyClass, encodedArgumentDescriptors, receivesKeywordArgs, needsToFindImplementer));
        if (!rubyClass.isRefinement()) {
            obj.callMethod(context, "singleton_method_added", Convert.asSymbol(context, id2));
        }
    }

    @JIT
    public static void defCompiledClassMethod(ThreadContext context, MethodHandle variable, MethodHandle specific, int specificArity, String id2, int line, StaticScope scope, String encodedArgumentDescriptors, IRubyObject obj, boolean maybeRefined, boolean receivesKeywordArgs, boolean needsToFindImplementer) {
        context.setLine(line);
        RubyClass rubyClass = IRRuntimeHelpers.checkClassForDef(context, id2, obj);
        if (maybeRefined) {
            scope.captureParentRefinements(context);
        }
        rubyClass.addMethod(context, id2, new CompiledIRMethod(variable, specific, specificArity, id2, line, scope, Visibility.PUBLIC, rubyClass, encodedArgumentDescriptors, receivesKeywordArgs, needsToFindImplementer));
        if (!rubyClass.isRefinement()) {
            obj.callMethod(context, "singleton_method_added", Convert.asSymbol(context, id2));
        }
    }

    private static RubyClass checkClassForDef(ThreadContext context, String id2, IRubyObject obj) {
        if (obj instanceof RubyFixnum || obj instanceof RubySymbol || obj instanceof RubyFloat) {
            throw Error.typeError(context, RubyStringBuilder.str(context.runtime, "can't define singleton method \"", RubyStringBuilder.ids(context.runtime, id2), "\" for ", obj.getMetaClass().rubyBaseName(context)));
        }
        return obj.singletonClass(context);
    }

    @Interp
    public static void defInterpretedInstanceMethod(ThreadContext context, IRScope method2, DynamicScope currDynScope, IRubyObject self2) {
        context.setLine(method2.getLine());
        RubySymbol methodName = method2.getName();
        RubyModule rubyClass = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        Visibility currVisibility = context.getCurrentVisibility();
        Visibility newVisibility = Helpers.performNormalMethodChecksAndDetermineVisibility(context, rubyClass, methodName, currVisibility);
        if (method2.maybeUsingRefinements()) {
            method2.getStaticScope().captureParentRefinements(context);
        }
        AbstractIRMethod newMethod = Access.instanceConfig(context).getCompileMode() == RubyInstanceConfig.CompileMode.OFF ? new InterpretedIRMethod(method2, newVisibility, rubyClass) : new MixedModeIRMethod(method2, newVisibility, rubyClass);
        Helpers.addInstanceMethod(rubyClass, methodName, newMethod, currVisibility, context);
    }

    @JIT
    public static void defCompiledInstanceMethod(ThreadContext context, MethodHandle handle, String id2, int line, StaticScope scope, String encodedArgumentDescriptors, DynamicScope currDynScope, IRubyObject self2, boolean maybeRefined, boolean receivesKeywordArgs, boolean needsToFindImplementer) {
        context.setLine(line);
        RubySymbol methodName = Convert.asSymbol(context, id2);
        RubyModule clazz = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        Visibility currVisibility = context.getCurrentVisibility();
        Visibility newVisibility = Helpers.performNormalMethodChecksAndDetermineVisibility(context, clazz, methodName, currVisibility);
        if (maybeRefined) {
            scope.captureParentRefinements(context);
        }
        CompiledIRMethod newMethod = new CompiledIRMethod(handle, null, -1, id2, line, scope, newVisibility, clazz, encodedArgumentDescriptors, receivesKeywordArgs, needsToFindImplementer);
        Helpers.addInstanceMethod(clazz, methodName, newMethod, currVisibility, context);
    }

    @JIT
    public static void defCompiledInstanceMethod(ThreadContext context, MethodHandle variable, MethodHandle specific, int specificArity, String id2, int line, StaticScope scope, String encodedArgumentDescriptors, DynamicScope currDynScope, IRubyObject self2, boolean maybeRefined, boolean receivesKeywordArgs, boolean needsToFindImplementer) {
        context.setLine(line);
        RubySymbol methodName = Convert.asSymbol(context, id2);
        RubyModule clazz = IRRuntimeHelpers.findInstanceMethodContainer(context, currDynScope, self2);
        Visibility currVisibility = context.getCurrentVisibility();
        Visibility newVisibility = Helpers.performNormalMethodChecksAndDetermineVisibility(context, clazz, methodName, currVisibility);
        if (maybeRefined) {
            scope.captureParentRefinements(context);
        }
        CompiledIRMethod newMethod = new CompiledIRMethod(variable, specific, specificArity, id2, line, scope, newVisibility, clazz, encodedArgumentDescriptors, receivesKeywordArgs, needsToFindImplementer);
        Helpers.addInstanceMethod(clazz, methodName, newMethod, currVisibility, context);
    }

    @JIT
    public static IRubyObject invokeModuleBody(ThreadContext context, DynamicMethod method2) {
        RubyModule implClass = method2.getImplementationClass();
        return method2.call(context, (IRubyObject)implClass, implClass, "", Block.NULL_BLOCK);
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject[] pieces, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context, options2, pieces);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context, options2, arg0);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, IRubyObject arg1, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context, options2, arg0, arg1);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context, options2, arg0, arg1, arg2);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context, options2, arg0, arg1, arg2, arg3);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newDynamicRegexp(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, int embeddedOptions) {
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(embeddedOptions);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context, options2, arg0, arg1, arg2, arg3, arg4);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, options2);
        re.setLiteral();
        return re;
    }

    public static RubyRegexp newLiteralRegexp(ThreadContext context, ByteList source2, RegexpOptions options2) {
        RubyRegexp re = RubyRegexp.newRegexp(context.runtime, source2, options2);
        re.setLiteral();
        return re;
    }

    @JIT
    public static RubyRegexp newLiteralRegexp(ThreadContext context, ByteList source2, int embeddedOptions) {
        return IRRuntimeHelpers.newLiteralRegexp(context, source2, RegexpOptions.fromEmbeddedOptions(embeddedOptions));
    }

    @JIT
    public static RubyArray irSplat(ThreadContext context, IRubyObject ary) {
        RubyArray result2;
        int callInfo = ThreadContext.resetCallInfo(context);
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck(context, ary, Access.arrayClass(context), IRRuntimeHelpers.sites((ThreadContext)context).to_a_checked);
        if (tmp.isNil()) {
            result2 = IRRuntimeHelpers.newArray(context, ary);
            context.callInfo = callInfo;
        } else {
            result2 = ((RubyArray)tmp).aryDup();
            if (result2.last(context) == UndefinedValue.UNDEFINED) {
                result2.pop(context);
                context.callInfo |= callInfo | 8;
            }
        }
        return result2;
    }

    @JIT
    @Interp
    public static RubyArray splatArray(ThreadContext context, IRubyObject ary, boolean dupArray) {
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck(context, ary, Access.arrayClass(context), IRRuntimeHelpers.sites((ThreadContext)context).to_a_checked);
        if (tmp.isNil()) {
            return IRRuntimeHelpers.newArray(context, ary);
        }
        if (dupArray) {
            return ((RubyArray)tmp).aryDup();
        }
        return (RubyArray)tmp;
    }

    @JIT
    @Interp
    public static RubyArray splatArray(ThreadContext context, IRubyObject ary) {
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck(context, ary, Access.arrayClass(context), IRRuntimeHelpers.sites((ThreadContext)context).to_a_checked);
        if (tmp.isNil()) {
            return IRRuntimeHelpers.newArray(context, ary);
        }
        return (RubyArray)tmp;
    }

    @JIT
    @Interp
    public static RubyArray splatArrayDup(ThreadContext context, IRubyObject ary) {
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck(context, ary, Access.arrayClass(context), IRRuntimeHelpers.sites((ThreadContext)context).to_a_checked);
        return tmp.isNil() ? IRRuntimeHelpers.newArray(context, ary) : ((RubyArray)tmp).aryDup();
    }

    public static IRubyObject irToAry(ThreadContext context, IRubyObject value2) {
        return value2 instanceof RubyArray ? value2 : RubyArray.aryToAry(context, value2);
    }

    public static int irReqdArgMultipleAsgnIndex(int n, int preArgsCount, int index2, int postArgsCount) {
        if (preArgsCount == -1) {
            return index2 < n ? index2 : -1;
        }
        int remaining = n - preArgsCount;
        if (remaining <= index2) {
            return -1;
        }
        return remaining > postArgsCount ? n - postArgsCount + index2 : preArgsCount + index2;
    }

    public static IRubyObject irReqdArgMultipleAsgn(ThreadContext context, RubyArray rubyArray, int preArgsCount, int index2, int postArgsCount) {
        int i2 = IRRuntimeHelpers.irReqdArgMultipleAsgnIndex(rubyArray.getLength(), preArgsCount, index2, postArgsCount);
        return i2 == -1 ? context.nil : rubyArray.entry(i2);
    }

    public static IRubyObject irNot(ThreadContext context, IRubyObject obj) {
        return Convert.asBoolean(context, !obj.isTrue());
    }

    @JIT
    public static RaiseException newRequiredKeywordArgumentError(ThreadContext context, String id2) {
        return Error.argumentError(context, RubyStringBuilder.str(context.runtime, "missing keyword: ", RubyStringBuilder.ids(context.runtime, id2)));
    }

    public static void pushExitBlock(ThreadContext context, Block blk) {
        context.runtime.pushEndBlock(context.runtime.newProc(Block.Type.LAMBDA, blk));
    }

    @JIT
    public static void pushExitBlock(ThreadContext context, Object blk) {
        context.runtime.pushEndBlock(context.runtime.newProc(Block.Type.LAMBDA, IRRuntimeHelpers.getBlockFromObject(context, blk)));
    }

    @JIT
    public static FunctionalCachingCallSite newFunctionalCachingCallSite(String name2) {
        return new FunctionalCachingCallSite(name2);
    }

    public static ProfilingCachingCallSite newProfilingCachingCallSite(CallType callType, String name2, IRScope scope, long callSiteId) {
        return new ProfilingCachingCallSite(callType, name2, scope, callSiteId);
    }

    @JIT
    public static MonomorphicCallSite newMonomorphicCallSite(String name2) {
        return new MonomorphicCallSite(name2);
    }

    @JIT
    public static VariableCachingCallSite newVariableCachingCallSite(String name2) {
        return new VariableCachingCallSite(name2);
    }

    @JIT
    public static RefinedCachingCallSite newRefinedCachingCallSite(String name2, StaticScope scope, String callType) {
        return new RefinedCachingCallSite(name2, scope, CallType.valueOf(callType));
    }

    @JIT
    public static IRScope decodeScopeFromBytes(Ruby runtime2, byte[] scopeBytes, String filename2) {
        try {
            return IRReader.load(runtime2.getIRManager(), new IRReaderStream(runtime2.getIRManager(), scopeBytes, filename2));
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @JIT
    public static VariableAccessor getVariableAccessorForRead(IRubyObject object, String name2) {
        return ((RubyBasicObject)object).getMetaClass().getRealClass().getVariableAccessorForRead(name2);
    }

    @JIT
    public static VariableAccessor getVariableAccessorForWrite(IRubyObject object, String name2) {
        return ((RubyBasicObject)object).getMetaClass().getRealClass().getVariableAccessorForWrite(name2);
    }

    @JIT
    public static RubyFixnum getArgScopeDepth(ThreadContext context, StaticScope currScope) {
        int i2 = 0;
        while (!currScope.isArgumentScope()) {
            currScope = currScope.getEnclosingScope();
            ++i2;
        }
        return Convert.asFixnum(context, i2);
    }

    public static IRubyObject[] toAry(ThreadContext context, IRubyObject[] args2) {
        IRubyObject ary;
        if (args2.length == 1 && (ary = Helpers.aryOrToAry(context, args2[0])) != context.nil) {
            if (!(ary instanceof RubyArray)) {
                throw Error.typeError(context, "", args2[0], "#to_ary should return Array");
            }
            args2 = ((RubyArray)ary).toJavaArray(context);
        }
        return args2;
    }

    private static IRubyObject[] prepareProcArgs(ThreadContext context, Block b2, IRubyObject[] args2) {
        if (args2.length != 1) {
            return args2;
        }
        return IRRuntimeHelpers.convertValueIntoArgArray(context, args2[0], b2.getBody().getSignature());
    }

    private static IRubyObject[] prepareBlockArgsInternal(ThreadContext context, Block block, IRubyObject[] args2) {
        if (args2 == null) {
            args2 = IRubyObject.NULL_ARRAY;
        }
        switch (block.type) {
            case LAMBDA: {
                Signature sig = block.getBody().getSignature();
                if (sig.arityValue() != -1 && sig.required() != 1) {
                    args2 = IRRuntimeHelpers.toAry(context, args2);
                }
                sig.checkArity(context, args2);
                return args2;
            }
            case PROC: {
                return IRRuntimeHelpers.prepareProcArgs(context, block, args2);
            }
        }
        Signature sig = block.getBody().getSignature();
        if (!sig.isSpreadable()) {
            return args2;
        }
        args2 = IRRuntimeHelpers.toAry(context, args2);
        int needsKwargs = sig.hasKwargs() ? 1 - sig.getRequiredKeywordForArityCount() : 0;
        int required = sig.required();
        int actual = args2.length;
        if (needsKwargs == 0 || required > actual) {
            return args2;
        }
        if (sig.isFixed() && required > 0 && required + needsKwargs != actual) {
            int len = required + needsKwargs;
            IRubyObject[] newArgs = ArraySupport.newCopy(args2, len);
            newArgs[len - 1] = actual < len ? Create.newHash(context) : args2[args2.length - 1];
            args2 = newArgs;
        }
        return args2;
    }

    @Interp
    @JIT
    public static IRubyObject[] prepareNoBlockArgs(ThreadContext context, Block block, IRubyObject[] args2) {
        if (args2 == null) {
            args2 = IRubyObject.NULL_ARRAY;
        }
        if (block.type == Block.Type.LAMBDA) {
            block.getSignature().checkArity(context, args2);
        }
        return args2;
    }

    @Interp
    @JIT
    public static IRubyObject[] prepareSingleBlockArgs(ThreadContext context, Block block, IRubyObject[] args2) {
        if (args2 == null) {
            args2 = IRubyObject.NULL_ARRAY;
        }
        switch (block.type) {
            case LAMBDA: {
                block.getBody().getSignature().checkArity(context, args2);
                return args2;
            }
            case PROC: {
                args2 = args2.length == 0 ? context.runtime.getSingleNilArray() : (args2.length == 1 ? IRRuntimeHelpers.prepareProcArgs(context, block, args2) : new IRubyObject[]{args2[0]});
            }
        }
        return args2;
    }

    @Interp
    @JIT
    public static IRubyObject[] prepareFixedBlockArgs(ThreadContext context, Block block, IRubyObject[] args2) {
        if (args2 == null) {
            args2 = IRubyObject.NULL_ARRAY;
        }
        switch (block.type) {
            case LAMBDA: {
                block.getBody().getSignature().checkArity(context, args2);
                return args2;
            }
            case PROC: {
                return IRRuntimeHelpers.prepareProcArgs(context, block, args2);
            }
        }
        return IRRuntimeHelpers.toAry(context, args2);
    }

    @Interp
    @JIT
    public static IRubyObject[] prepareBlockArgs(ThreadContext context, Block block, IRubyObject[] args2, boolean usesKwArgs, boolean ruby2Keywords) {
        return IRRuntimeHelpers.prepareBlockArgsInternal(context, block, args2);
    }

    private static DynamicScope getNewBlockScope(Block block, boolean pushNewDynScope, boolean reuseParentDynScope) {
        DynamicScope newScope = block.getBinding().getDynamicScope();
        if (pushNewDynScope) {
            return block.allocScope(newScope);
        }
        if (reuseParentDynScope) {
            return newScope;
        }
        return null;
    }

    @Interp
    public static DynamicScope pushBlockDynamicScopeIfNeeded(ThreadContext context, Block block, boolean pushNewDynScope, boolean reuseParentDynScope) {
        DynamicScope newScope = IRRuntimeHelpers.getNewBlockScope(block, pushNewDynScope, reuseParentDynScope);
        if (newScope != null) {
            context.pushScope(newScope);
        }
        return newScope;
    }

    @JIT
    public static DynamicScope pushBlockDynamicScopeNew(ThreadContext context, Block block) {
        DynamicScope newScope = block.allocScope(block.getBinding().getDynamicScope());
        context.pushScope(newScope);
        return newScope;
    }

    @JIT
    public static DynamicScope pushBlockDynamicScopeReuse(ThreadContext context, Block block) {
        DynamicScope newScope = block.getBinding().getDynamicScope();
        context.pushScope(newScope);
        return newScope;
    }

    @Interp
    @JIT
    public static IRubyObject updateBlockState(Block block, IRubyObject self2) {
        if (self2 == null || block.getEvalType() == EvalType.BINDING_EVAL) {
            self2 = IRRuntimeHelpers.useBindingSelf(block.getBinding());
        }
        return self2;
    }

    public static IRubyObject useBindingSelf(Binding binding2) {
        IRubyObject self2 = binding2.getSelf();
        binding2.getFrame().setSelf(self2);
        return self2;
    }

    @JIT
    public static RubyProc newSymbolProc(ThreadContext context, ByteList value2) {
        return IRRuntimeHelpers.newSymbolProc(context, Convert.asSymbol(context, value2));
    }

    @Interp
    public static RubyProc newSymbolProc(ThreadContext context, RubySymbol symbol) {
        return (RubyProc)symbol.to_proc(context);
    }

    @JIT
    public static IRubyObject[] singleBlockArgToArray(IRubyObject value2) {
        IRubyObject[] iRubyObjectArray;
        if (value2 instanceof RubyArray) {
            iRubyObjectArray = ((RubyArray)value2).toJavaArray(value2.getRuntime().getCurrentContext());
        } else {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = value2;
        }
        return iRubyObjectArray;
    }

    @JIT
    public static Block prepareBlock(ThreadContext context, IRubyObject self2, DynamicScope scope, BlockBody body) {
        Binding binding2 = IRRuntimeHelpers.newFrameScopeBinding(context, self2, scope);
        return new Block(body, binding2);
    }

    public static Binding newFrameScopeBinding(ThreadContext context, IRubyObject self2, DynamicScope scope) {
        Frame frame = context.getCurrentFrame().capture();
        Binding binding2 = new Binding(self2, frame, frame.getVisibility(), scope);
        binding2.setMethod(frame.getName());
        return binding2;
    }

    public static RubyString newFrozenString(ThreadContext context, ByteList bytelist, int coderange, String file2, int line) {
        Ruby runtime2 = context.runtime;
        if (Access.instanceConfig(context).isDebuggingFrozenStringLiteral()) {
            return RubyString.newDebugFrozenString(runtime2, Access.stringClass(context), bytelist, coderange, file2, line + 1);
        }
        return runtime2.freezeAndDedupString(RubyString.newString(runtime2, bytelist, coderange));
    }

    public static RubyString newFrozenString(ThreadContext context, ByteList bytelist, int coderange) {
        Ruby runtime2 = context.runtime;
        return runtime2.freezeAndDedupString(RubyString.newString(runtime2, bytelist, coderange));
    }

    @JIT
    @Interp
    public static RubyString freezeLiteralString(RubyString string2) {
        string2.setFrozen(true);
        return string2;
    }

    @JIT
    @Interp
    public static RubyString chillLiteralString(RubyString string2) {
        string2.chill();
        return string2;
    }

    @JIT
    public static IRubyObject callOptimizedAref(ThreadContext context, IRubyObject caller2, IRubyObject target2, RubyString keyStr, CallSite site) {
        RubyHash h;
        return target2 instanceof RubyHash && !(h = (RubyHash)target2).isComparedByIdentity() && ((CachingCallSite)site).isBuiltin(target2) ? h.op_aref(context, keyStr) : site.call(context, caller2, target2, (IRubyObject)Create.dupString(context, keyStr));
    }

    @JIT
    public static RubyString asString(ThreadContext context, IRubyObject caller2, IRubyObject target2, CallSite site) {
        RubyString string2;
        IRubyObject str = site.call(context, caller2, target2);
        return str instanceof RubyString ? (string2 = (RubyString)str) : (RubyString)target2.anyToString();
    }

    @JIT
    public static RubyArray newArray(ThreadContext context) {
        return RubyArray.newEmptyArray(context.runtime);
    }

    @JIT
    public static RubyArray newArray(ThreadContext context, IRubyObject obj) {
        return Create.newArray(context, obj);
    }

    @JIT
    public static RubyArray newArray(ThreadContext context, IRubyObject obj0, IRubyObject obj1) {
        return Create.newArray(context, obj0, obj1);
    }

    @JIT
    @Interp
    public static RubyString getFileNameStringFromScope(ThreadContext context, StaticScope currScope) {
        String file2 = currScope.getFile();
        return Create.newString(context, file2);
    }

    @JIT
    public static void callTrace(ThreadContext context, IRubyObject selfClass, RubyEvent event2, String name2, String filename2, int line) {
        TraceEventManager traceEvents = context.traceEvents;
        if (traceEvents.hasEventHooks()) {
            int linenumber = line == -1 ? context.getLine() : line;
            traceEvents.callEventHooks(context, event2, filename2, linenumber, name2, selfClass);
        }
    }

    public static void traceRaise(ThreadContext context) {
        TraceEventManager traceEvents = context.traceEvents;
        if (traceEvents.hasEventHooks()) {
            RubyStackTraceElement backtraceElement = context.getSingleBacktrace();
            String file2 = backtraceElement.getFileName();
            int line = backtraceElement.getLineNumber();
            int linenumber = line == -1 ? context.getLine() : line;
            traceEvents.callEventHooks(context, RubyEvent.RAISE, file2, linenumber, null, context.nil);
        }
    }

    public static void traceRescue(ThreadContext context, String file2, int line) {
        TraceEventManager traceEvents = context.traceEvents;
        if (traceEvents.hasEventHooks()) {
            traceEvents.callEventHooks(context, RubyEvent.RESCUE, file2, line, null, context.getErrorInfo());
        }
    }

    @JIT
    public static void callTrace(ThreadContext context, Block selfBlock, RubyEvent event2, String name2, String filename2, int line) {
        TraceEventManager traceEvents = context.traceEvents;
        if (traceEvents.hasEventHooks()) {
            int linenumber = line == -1 ? context.getLine() : line;
            traceEvents.callEventHooks(context, event2, filename2, linenumber, name2, selfBlock.getFrameClass());
        }
    }

    @JIT
    public static void callTraceHooks(ThreadContext context, Block selfBlock, RubyEvent event2, String name2, String filename2, int line) {
        int linenumber = line == -1 ? context.getLine() : line;
        context.traceEvents.callEventHooks(context, event2, filename2, linenumber, name2, selfBlock.getFrameClass());
    }

    public static void warnSetConstInRefinement(ThreadContext context, IRubyObject self2) {
        if (self2 instanceof RubyModule && ((RubyModule)self2).isRefinement()) {
            Warn.warn(context, "not defined at the refinement, but at the outer class/module");
        }
    }

    @Interp
    public static void putConst(ThreadContext context, IRubyObject self2, IRubyObject module, String id2, IRubyObject value2) {
        IRRuntimeHelpers.putConst(context, self2, module, id2, value2, context.getFile(), context.getLine() + 1);
    }

    @JIT
    public static void putConst(ThreadContext context, IRubyObject self2, IRubyObject module, String id2, IRubyObject value2, StaticScope scope, int line) {
        IRRuntimeHelpers.putConst(context, self2, module, id2, value2, scope.getFile(), line);
    }

    private static void putConst(ThreadContext context, IRubyObject self2, IRubyObject module, String id2, IRubyObject value2, String filename2, int line) {
        if (!(module instanceof RubyModule)) {
            throw Error.typeError(context, String.valueOf(module.inspect(context)) + " is not a class/module");
        }
        RubyModule mod = (RubyModule)module;
        IRRuntimeHelpers.warnSetConstInRefinement(context, self2);
        mod.setConstant(context, id2, value2, filename2, line);
    }

    @Interp
    @JIT
    public static IRubyObject getClassVariable(ThreadContext context, RubyModule module, String id2) {
        return module.getClassVar(context, id2);
    }

    @Interp
    @JIT
    public static void putClassVariable(ThreadContext context, IRubyObject self2, RubyModule module, String id2, IRubyObject value2) {
        IRRuntimeHelpers.warnSetConstInRefinement(context, self2);
        module.setClassVar(context, id2, value2);
    }

    @JIT
    public static RubyRational newRationalCanonicalize(ThreadContext context, IRubyObject num, IRubyObject den) {
        return (RubyRational)RubyRational.newRationalCanonicalize(context, num, den);
    }

    @JIT
    public static RubyComplex newComplexRaw(ThreadContext context, IRubyObject i2) {
        return RubyComplex.newComplexRawImage(context.runtime, i2);
    }

    @JIT
    public static RubySymbol newDSymbol(ThreadContext context, IRubyObject symbol) {
        return Convert.asSymbol(context, symbol.asString());
    }

    @JIT
    public static RubyClass getStandardError(ThreadContext context) {
        return context.runtime.getStandardError();
    }

    @JIT
    public static RubyClass getArray(ThreadContext context) {
        return Access.arrayClass(context);
    }

    @JIT
    public static RubyClass getHash(ThreadContext context) {
        return Access.hashClass(context);
    }

    @JIT
    public static RubyClass getObject(ThreadContext context) {
        return Access.objectClass(context);
    }

    @JIT
    public static RubyClass getSymbol(ThreadContext context) {
        return Access.symbolClass(context);
    }

    @JIT
    @Interp
    public static IRubyObject svalue(ThreadContext context, Object val) {
        return val instanceof RubyArray ? (RubyArray)val : context.nil;
    }

    @JIT
    public static void aliasGlobalVariable(Ruby runtime2, Object newName, Object oldName) {
        runtime2.getGlobalVariables().alias(newName.toString(), oldName.toString());
    }

    private static JavaSites.IRRuntimeHelpersSites sites(ThreadContext context) {
        return context.sites.IRRuntimeHelpers;
    }

    @Interp
    @JIT
    public static int arrayLength(RubyArray array2) {
        return array2.getLength();
    }

    @Interp
    @JIT
    public static String getFrameNameFromBlock(Block block) {
        return block.getBinding().getFrame().getName();
    }

    @Interp
    @JIT
    public static Block getFrameBlockFromBlock(Block block) {
        return block.getBinding().getFrame().getBlock();
    }

    private static class InvalidKeyException
    extends RuntimeException {
        private InvalidKeyException() {
        }
    }

    private static class GatherUnwantedKeywordsVisitor
    extends RubyHash.VisitorWithState<StaticScope> {
        RubyArray invalidKwargs;

        private GatherUnwantedKeywordsVisitor() {
        }

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, StaticScope scope) {
            if (!IRRuntimeHelpers.isValidKeyword(scope, key2)) {
                if (this.invalidKwargs == null) {
                    this.invalidKwargs = IRRuntimeHelpers.newArray(context);
                }
                this.invalidKwargs.add(key2.inspect(context));
            }
        }

        public void raiseIfError(ThreadContext context) {
            if (this.invalidKwargs != null) {
                RubyString errorMessage = (RubyString)this.invalidKwargs.join(context, Create.newString(context, ", "));
                String prefix = this.invalidKwargs.size() == 1 ? "unknown keyword: " : "unknown keywords: ";
                throw Error.argumentError(context, prefix + String.valueOf(errorMessage));
            }
        }
    }

    private static class KwargMergeVisitor
    extends RubyHash.VisitorWithState<Block> {
        final RubyHash target;

        KwargMergeVisitor(RubyHash target2) {
            this.target = target2;
        }

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
            if (this.target.fastARef(key2) != null) {
                context.runtime.getWarnings().warn(context, key2, KwargMergeVisitor::duplicationWarning);
            }
            this.target.op_aset(context, key2, value2);
        }

        private static String duplicationWarning(ThreadContext c, IRubyObject k, RubyStackTraceElement trace2) {
            return RubyStringBuilder.str(c.runtime, "key ", k.inspect(c), " is duplicated and overwritten on line " + trace2.getLineNumber());
        }
    }
}

