/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageFilter;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.VectorBool;
import org.itk.simple.VectorDouble;
import org.itk.simple.VectorUInt32;

public class DICOMOrientImageFilter
extends ImageFilter {
    private transient long swigCPtr;

    protected DICOMOrientImageFilter(long l, boolean bl) {
        super(SimpleITKJNI.DICOMOrientImageFilter_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(DICOMOrientImageFilter dICOMOrientImageFilter) {
        return dICOMOrientImageFilter == null ? 0L : dICOMOrientImageFilter.swigCPtr;
    }

    protected static long swigRelease(DICOMOrientImageFilter dICOMOrientImageFilter) {
        long l = 0L;
        if (dICOMOrientImageFilter != null) {
            if (!dICOMOrientImageFilter.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = dICOMOrientImageFilter.swigCPtr;
            dICOMOrientImageFilter.swigCMemOwn = false;
            dICOMOrientImageFilter.delete();
        }
        return l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_DICOMOrientImageFilter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public DICOMOrientImageFilter() {
        this(SimpleITKJNI.new_DICOMOrientImageFilter(), true);
    }

    public static String getOrientationFromDirectionCosines(VectorDouble vectorDouble) {
        return SimpleITKJNI.DICOMOrientImageFilter_getOrientationFromDirectionCosines(VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public static VectorDouble getDirectionCosinesFromOrientation(String string) {
        return new VectorDouble(SimpleITKJNI.DICOMOrientImageFilter_getDirectionCosinesFromOrientation(string), true);
    }

    public void setDesiredCoordinateOrientation(String string) {
        SimpleITKJNI.DICOMOrientImageFilter_setDesiredCoordinateOrientation(this.swigCPtr, this, string);
    }

    public String getDesiredCoordinateOrientation() {
        return SimpleITKJNI.DICOMOrientImageFilter_getDesiredCoordinateOrientation(this.swigCPtr, this);
    }

    public VectorBool getFlipAxes() {
        return new VectorBool(SimpleITKJNI.DICOMOrientImageFilter_getFlipAxes(this.swigCPtr, this), true);
    }

    public VectorUInt32 getPermuteOrder() {
        return new VectorUInt32(SimpleITKJNI.DICOMOrientImageFilter_getPermuteOrder(this.swigCPtr, this), true);
    }

    @Override
    public String getName() {
        return SimpleITKJNI.DICOMOrientImageFilter_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.DICOMOrientImageFilter_toString(this.swigCPtr, this);
    }

    public Image execute(Image image) {
        return new Image(SimpleITKJNI.DICOMOrientImageFilter_execute(this.swigCPtr, this, Image.getCPtr(image), image), true);
    }
}

