/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.common.impl;

import org.apache.groovy.contracts.common.spi.AnnotationProcessor;
import org.apache.groovy.contracts.common.spi.ProcessingContextInformation;
import org.apache.groovy.contracts.domain.ClassInvariant;
import org.apache.groovy.contracts.domain.Contract;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;

public class ClassInvariantAnnotationProcessor
extends AnnotationProcessor {
    @Override
    public void process(ProcessingContextInformation processingContextInformation, Contract contract, ClassNode classNode, BlockStatement blockStatement, BooleanExpression booleanExpression) {
        if (!processingContextInformation.isClassInvariantsEnabled()) {
            return;
        }
        if (booleanExpression == null) {
            return;
        }
        Expression currentInvariant = contract.classInvariant().booleanExpression().getExpression();
        if (currentInvariant instanceof MethodCallExpression || currentInvariant instanceof BinaryExpression) {
            booleanExpression = GeneralUtils.boolX((Expression)GeneralUtils.andX((Expression)booleanExpression, (Expression)currentInvariant));
        }
        contract.setClassInvariant(new ClassInvariant(blockStatement, booleanExpression));
    }
}

