/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaProperty;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MethodRankHelper;

public class MissingPropertyException
extends GroovyRuntimeException {
    public static final Object MPE = new Object();
    private static final long serialVersionUID = -1780027060966200019L;
    private final String property;
    private final Class type;

    public MissingPropertyException(String property, Class type) {
        this.property = property;
        this.type = type;
    }

    public MissingPropertyException(String property, Class type, Throwable cause) {
        super(cause);
        this.property = property;
        this.type = type;
    }

    public MissingPropertyException(String message) {
        super(message);
        this.property = null;
        this.type = null;
    }

    public MissingPropertyException(String message, String property, Class type) {
        super(message);
        this.property = property;
        this.type = type;
    }

    @Override
    public String getMessageWithoutLocationText() {
        Object message = super.getMessageWithoutLocationText();
        String name = this.getProperty();
        Class type = this.getType();
        if (name != null && type != null) {
            if (this.getCause() != null) {
                message = "No such property: " + name + " for class: " + type.getName() + ". Reason: " + this.getCause();
            } else if (message == null) {
                MetaProperty mp = InvokerHelper.getMetaClass(type).getMetaProperty(name);
                message = mp instanceof MetaBeanProperty && ((MetaBeanProperty)mp).getField() == null && ((MetaBeanProperty)mp).getGetter() == null ? "Cannot get write-only property: " + name + " for class: " + type.getName() : "No such property: " + name + " for class: " + type.getName() + MethodRankHelper.getPropertySuggestionString(name, type);
            }
        }
        return message;
    }

    public String getProperty() {
        return this.property;
    }

    public Class getType() {
        return this.type;
    }
}

