/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

class CallbackSupport {
    CallbackSupport() {
    }

    static <T extends Extension> void invokeBeforeCallbacks(Class<T> type, JupiterEngineExecutionContext context, CallbackInvoker<T> callbackInvoker) {
        MutableExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        for (Extension callback : registry.getExtensions(type)) {
            throwableCollector.execute(() -> callbackInvoker.invoke(callback, extensionContext));
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    static <T extends Extension> void invokeAfterCallbacks(Class<T> type, JupiterEngineExecutionContext context, CallbackInvoker<T> callbackInvoker) {
        MutableExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        CollectionUtils.forEachInReverseOrder(registry.getExtensions(type), callback -> throwableCollector.execute(() -> callbackInvoker.invoke(callback, extensionContext)));
    }

    @FunctionalInterface
    protected static interface CallbackInvoker<T extends Extension> {
        public void invoke(T var1, ExtensionContext var2) throws Throwable;
    }
}

